/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv;

import com.sap.sldserv.J2EEAssocInst;
import com.sap.sldserv.J2EEInst;
import com.sap.sldserv.J2EEObjInst;
import com.sap.sldserv.exception.SldServiceException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class J2EEClass
implements Cloneable {
    private HashMap data;
    private String className;
    private boolean isObjectClass;

    public J2EEClass(String className) {
        this.className = className;
        this.data = new HashMap();
        this.isObjectClass = true;
    }

    public J2EEClass(String className, boolean isObjectClass) {
        this.className = className;
        this.isObjectClass = isObjectClass;
        this.data = new HashMap();
    }

    public Object clone() {
        J2EEClass cloneClass = null;
        try {
            cloneClass = (J2EEClass)super.clone();
            cloneClass.data = new HashMap(this.data.size());
            Iterator it = this.data.values().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                cloneClass.addInstance((J2EEInst)((J2EEInst)o).clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return cloneClass;
    }

    public void addInstance(J2EEInst inst) {
        this.data.put(inst.getInstName(), inst);
    }

    public void removeInstance(J2EEInst inst) {
        this.data.remove(inst.getInstName());
    }

    public J2EEInst getInstance(String instName) {
        return (J2EEInst)this.data.get(instName);
    }

    public J2EEInst getInstance(J2EEInst otherInst) throws SldServiceException {
        Iterator it = this.instanceIterator();
        while (it.hasNext()) {
            J2EEInst inst = (J2EEInst)it.next();
            if (!inst.equals(otherInst)) continue;
            return inst;
        }
        return null;
    }

    public int getMaxInstNumber() throws SldServiceException {
        int maxInstNum = Integer.MIN_VALUE;
        Iterator it = this.instanceIterator();
        while (it.hasNext()) {
            J2EEInst inst = (J2EEInst)it.next();
            try {
                maxInstNum = Math.max(maxInstNum, Integer.parseInt(inst.getInstName()));
            }
            catch (NumberFormatException e) {
                throw new SldServiceException("sld_3013", new Object[]{this.className, e.getMessage()});
            }
        }
        return maxInstNum;
    }

    public J2EEAssocInst getInstance(J2EEAssocInst otherInst) throws SldServiceException {
        Iterator it = this.instanceIterator();
        while (it.hasNext()) {
            Object instObj = it.next();
            if (!(instObj instanceof J2EEAssocInst)) {
                throw new SldServiceException("sld_3006", new Object[]{instObj.getClass().toString()});
            }
            J2EEAssocInst inst = (J2EEAssocInst)instObj;
            if (!inst.equals(otherInst)) continue;
            return inst;
        }
        return null;
    }

    public static J2EEObjInst getNewObjInst(String className, String instName) {
        return new J2EEObjInst(className, instName);
    }

    public J2EEObjInst createObjectInst(String instName) throws SldServiceException {
        if (!this.isObjectClass()) {
            throw new SldServiceException("sld_2006", new Object[]{this.className, "object", "association"});
        }
        return new J2EEObjInst(this.className, instName);
    }

    public static J2EEAssocInst getNewAssocInst(String className, String instName) {
        return new J2EEAssocInst(className, instName);
    }

    public J2EEAssocInst createAssocInst(String instName) throws SldServiceException {
        if (this.isObjectClass()) {
            throw new SldServiceException("sld_2006", new Object[]{this.className, "association", "object"});
        }
        return new J2EEAssocInst(this.className, instName);
    }

    public Iterator instanceIterator() {
        return this.data.values().iterator();
    }

    public String getName() {
        return this.className;
    }

    void setName(String className) {
        this.className = className;
    }

    public boolean isObjectClass() {
        return this.isObjectClass;
    }

    public boolean isAssocClass() {
        return !this.isObjectClass;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof J2EEClass)) {
            return false;
        }
        if (this != obj) {
            J2EEClass otherClass = (J2EEClass)obj;
            if (!otherClass.className.equalsIgnoreCase(this.className)) {
                return false;
            }
            if (otherClass.getInstanceCount() != this.getInstanceCount()) {
                return false;
            }
            Iterator oiit = otherClass.instanceIterator();
            while (oiit.hasNext()) {
                J2EEInst otherInst = (J2EEInst)oiit.next();
                boolean found = false;
                Iterator tiit = this.instanceIterator();
                while (tiit.hasNext()) {
                    J2EEInst thisInst = (J2EEInst)tiit.next();
                    if (!thisInst.equals(otherInst)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashMap clonedData = (HashMap)this.data.clone();
        Object[] oa = clonedData.values().toArray();
        Arrays.sort(oa);
        return (this.className + oa.toString()).hashCode();
    }

    public int getInstanceCount() {
        return this.data.size();
    }

    public void merge(J2EEClass otherClass) throws SldServiceException {
        if (this.className.equalsIgnoreCase(otherClass.className)) {
            try {
                int nextNewInstNumber = this.getMaxInstNumber() + 1;
                Iterator it = otherClass.instanceIterator();
                while (it.hasNext()) {
                    J2EEInst otherInst = (J2EEInst)it.next();
                    otherInst = (J2EEInst)otherInst.clone();
                    otherInst.setInstName(nextNewInstNumber++);
                    this.addInstance(otherInst);
                }
            }
            catch (NumberFormatException e) {
                throw new SldServiceException("sld_3013", new Object[]{this.className, e.getMessage()});
            }
        }
    }
}

