/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv;

import com.sap.sldserv.J2EEInst;
import com.sap.sldserv.ServiceConst;
import com.sap.sldserv.exception.SldServiceException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class J2EEAssocInst
extends J2EEInst
implements Cloneable,
Comparable {
    private ArrayList instRefs = new ArrayList();

    public J2EEAssocInst(String className, String instName) {
        super(className, instName);
    }

    public Object clone() {
        ServiceConst p;
        Iterator it;
        J2EEAssocInst o = (J2EEAssocInst)super.clone();
        if (this.instProps != null && this.instProps.size() != 0) {
            o.instProps = new ArrayList(this.instProps.size());
            it = ((AbstractList)this.instProps).iterator();
            while (it.hasNext()) {
                p = (J2EEInst.J2EEInstProp)it.next();
                p = (J2EEInst.J2EEInstProp)((J2EEInst.J2EEInstProp)p).clone();
                o.instProps.add(p);
            }
        }
        if (this.instRefs != null && this.instRefs.size() != 0) {
            o.instRefs = new ArrayList(this.instRefs.size());
            it = ((AbstractList)this.instRefs).iterator();
            while (it.hasNext()) {
                p = (J2EEInst.J2EEInstRef)it.next();
                p = (J2EEInst.J2EEInstRef)((J2EEInst.J2EEInstRef)p).clone();
                o.instRefs.add(p);
            }
        }
        return o;
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof J2EEAssocInst)) {
            return false;
        }
        J2EEAssocInst otherInst = (J2EEAssocInst)otherObj;
        if (this != otherObj) {
            if (otherInst.instRefs.size() != this.instRefs.size()) {
                return false;
            }
            Iterator it = ((AbstractList)this.instRefs).iterator();
            while (it.hasNext()) {
                J2EEInst.J2EEInstRef r = (J2EEInst.J2EEInstRef)it.next();
                J2EEInst.J2EEInstRef r2 = otherInst.getRef(r.getRoleName());
                if (r2 != null && r.equals(r2)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList clonedInstRefs = (ArrayList)this.instRefs.clone();
        Arrays.sort(clonedInstRefs.toArray());
        return (this.className + this.instName + clonedInstRefs.toString()).hashCode();
    }

    public void setValues() throws SldServiceException {
        super.setValues();
        Iterator it = ((AbstractList)this.instProps).iterator();
        while (it.hasNext()) {
            J2EEInst.J2EEInstProp currProp = (J2EEInst.J2EEInstProp)it.next();
            if (currProp.hasMultipleValues()) {
                throw new SldServiceException("sld_3004", new Object[]{this.className, this.instName});
            }
            try {
                this.instRefs.add(new J2EEInst.J2EEInstRef(currProp.getName(), currProp.getFirstValue()));
            }
            catch (SldServiceException ex) {
                throw new SldServiceException("sld_3005", new Object[]{ex.getMessage()}, (Throwable)((Object)ex));
            }
        }
    }

    private J2EEInst.J2EEInstRef getRef(String roleName) {
        Iterator it = ((AbstractList)this.instRefs).iterator();
        while (it.hasNext()) {
            J2EEInst.J2EEInstRef r = (J2EEInst.J2EEInstRef)it.next();
            if (!r.getRoleName().equalsIgnoreCase(roleName)) continue;
            return r;
        }
        return null;
    }

    public boolean isAssociation() {
        return true;
    }

    public List getRoleNames() {
        ArrayList<String> l = new ArrayList<String>(this.instRefs.size());
        Iterator it = ((AbstractList)this.instRefs).iterator();
        while (it.hasNext()) {
            l.add(((J2EEInst.J2EEInstRef)it.next()).getRoleName());
        }
        return l;
    }

    public String getAssociationClassname(String roleName) {
        J2EEInst.J2EEInstRef r = this.getRef(roleName);
        return r != null ? r.getClassName() : null;
    }

    public String getAssociationID(String roleName) {
        J2EEInst.J2EEInstRef r = this.getRef(roleName);
        return r != null ? r.getInstId() : null;
    }

    public Iterator getRefIterator() {
        return ((AbstractList)this.instRefs).iterator();
    }

    public void addRefValue(String className, String roleName, String refValue) {
        this.instRefs.add(new J2EEInst.J2EEInstRef(className, roleName, refValue));
    }

    public int compareTo(Object o) {
        int rvalue = 0;
        J2EEAssocInst oi = (J2EEAssocInst)o;
        if (this.className.equals(oi.className)) {
            ArrayList clonedOtherInstRefs = (ArrayList)oi.clone();
            Arrays.sort(clonedOtherInstRefs.toArray());
            ArrayList clonedInstRefs = (ArrayList)this.instProps.clone();
            Arrays.sort(clonedInstRefs.toArray());
            rvalue = clonedInstRefs.toString().compareTo(clonedOtherInstRefs.toString());
        } else {
            rvalue = this.className.compareTo(oi.className);
        }
        return rvalue;
    }
}

