/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.message.ListenerAlreadyRegisteredException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.engine.frame.cluster.message.MessageListener;
import com.sap.engine.frame.cluster.monitor.ClusterMonitor;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.locking.LockException;
import com.sap.engine.frame.core.locking.ServerInternalLocking;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.timeout.TimeoutListener;
import com.sap.engine.services.timeout.TimeoutManager;
import com.sap.sldserv.CollectTimeInterval;
import com.sap.sldserv.J2EEData;
import com.sap.sldserv.Params;
import com.sap.sldserv.SendInfo;
import com.sap.sldserv.ServiceManagementInterface;
import com.sap.sldserv.ServiceManagementResponse;
import com.sap.sldserv.comm.BridgeCommunicationHTTP;
import com.sap.sldserv.comm.BridgeCommunicationRfc;
import com.sap.sldserv.comm.IBridgeCommunication;
import com.sap.sldserv.data.GetData;
import com.sap.sldserv.data.GetDataClasses;
import com.sap.sldserv.data.SldMessage;
import com.sap.sldserv.data.listen.SldListener;
import com.sap.sldserv.exception.ResourceUtil;
import com.sap.sldserv.exception.SldServiceException;
import com.sap.sldserv.util.ServiceUtils;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.directory.InvalidAttributesException;

class DataCollector
implements TimeoutListener {
    private static final String GETTER_METHOD = "getData";
    private static final String CLASS_NAME_METHOD = "getServedClassName";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final long WITHOUT_CALL_TIMEOUT = 0L;
    private static final long MINIMUM_CHECK_PERIOD_MIN = 5L;
    private static final long MINIMUM_CHECK_PERIOD_MS = 5000L;
    private static final boolean useDatabase4SendInfo = true;
    private ApplicationServiceContext applServCtx = null;
    private Params params = null;
    private IBridgeCommunication bridgeComm = null;
    private ServerInternalLocking siLocking = null;
    private SldListener listener = null;
    private long processingStartTime = 0L;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sldserv$SldServerFrame == null ? (class$com$sap$sldserv$SldServerFrame = DataCollector.class$("com.sap.sldserv.SldServerFrame")) : class$com$sap$sldserv$SldServerFrame));
    private static final Category CATEGORY = Category.getCategory((Category)LoggingHelper.SYS_SERVER, (String)"SLDService");
    private volatile boolean stopIt = false;
    private J2EEData oldJ2EEData = null;
    private Context jndiCtx = null;
    private static MessageContext msgCtx = null;
    private boolean useRfc = true;
    private boolean isManagementRun = false;
    private boolean thisIsTheLockHolder = false;
    private volatile int collectorStatus = 0;
    private volatile int collectorProgress = 0;
    private volatile boolean collectIsRunning = false;
    private Date nextStartTime = null;
    private volatile String collectorInfo = "<unknown>";
    private SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy.MM.dd@HH:mm:ss");
    private Object accessObject = new Object();
    private ServiceManagementInterface serviceManagement = null;
    private TimeoutManager timeoutMgr = null;
    private String collectMessage = null;
    private long lastCheckTime = 0L;
    private static ClusterMonitor clusterMonitor = null;
    private Object accessConfigParams = new Object();
    private int sendReceiveBytes = 0;
    private boolean isInitialRun = true;
    static /* synthetic */ Class class$com$sap$sldserv$SldServerFrame;
    static /* synthetic */ Class class$com$sap$engine$frame$ApplicationServiceContext;
    static /* synthetic */ Class class$com$sap$sldserv$Params$Ids;

    DataCollector(ApplicationServiceContext applServCtx, Params params, ServerInternalLocking siLocking) throws SldServiceException {
        this.applServCtx = applServCtx;
        this.initTimer();
        this.params = params;
        this.siLocking = siLocking;
        this.listener = SldListener.getInstance(applServCtx);
        try {
            applServCtx.getClusterContext().getMessageContext().registerListener((MessageListener)this.listener);
        }
        catch (ListenerAlreadyRegisteredException e) {
            throw new SldServiceException("sld_3016", e);
        }
        this.prepareMessaging();
        this.prepareJndiContext();
        if (!this.setBridgeCommunication()) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3039"));
        }
        clusterMonitor = applServCtx.getClusterContext().getClusterMonitor();
    }

    DataCollector(ServiceManagementInterface serviceManagement, ApplicationServiceContext applServCtx, Params params, ServerInternalLocking siLocking) throws SldServiceException {
        this(applServCtx, params, siLocking);
        this.serviceManagement = serviceManagement;
    }

    private boolean setBridgeCommunication() throws SldServiceException {
        String method = "setBridgeCommunication";
        boolean rvalue = true;
        this.params.refreshConfig();
        this.useRfc = this.params.getCommunicationType().equalsIgnoreCase("jco");
        if (this.useRfc && !this.params.hasValidRfcParams()) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_9057"));
        } else if (!this.useRfc && !this.params.hasValidHttpParams()) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_9058"));
        }
        if (this.params.hasValidRfcParams() || this.params.hasValidHttpParams()) {
            LOCATION.debugT("setBridgeCommunication", ResourceUtil.formatString(this.useRfc ? "sld_9041" : "sld_9042"));
            this.bridgeComm = this.useRfc ? new BridgeCommunicationRfc(this.params) : new BridgeCommunicationHTTP(this.params);
        } else {
            rvalue = false;
            this.bridgeComm = null;
        }
        return rvalue;
    }

    protected void finalize() {
        String method = "finalize";
        if (this.thisIsTheLockHolder) {
            try {
                this.unlock();
            }
            catch (SldServiceException e) {
                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_9003"));
                LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"finalize", (Throwable)((Object)e));
            }
        }
    }

    /*
     * Loose catch block
     */
    public void timeout() {
        block18: {
            block17: {
                String method = "timeout";
                LOCATION.debugT("timeout", ResourceUtil.formatString("sld_9000"));
                this.nextStartTime = new Date(System.currentTimeMillis() + this.params.getRepeatTimeMs());
                try {
                    block16: {
                        if (this.stopIt) break block16;
                        this.params.refreshConfig();
                        if (this.params.hasValidConnectParams()) {
                            this.doCollect();
                            break block16;
                        }
                        CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_9040"));
                        this.setSendInfo(false);
                    }
                    Object var4_2 = null;
                    this.collectorProgress = 100;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.collectorProgress = 100;
                    LOCATION.debugT("timeout", ResourceUtil.formatString("sld_9001"));
                    LOCATION.debugT("timeout", ResourceUtil.formatString("sld_9072", new Object[]{this.timeFormat.format(this.nextStartTime)}));
                    throw throwable;
                }
                LOCATION.debugT("timeout", ResourceUtil.formatString("sld_9001"));
                LOCATION.debugT("timeout", ResourceUtil.formatString("sld_9072", new Object[]{this.timeFormat.format(this.nextStartTime)}));
                {
                    break block17;
                    catch (Exception e) {
                        this.collectMessage = this.collectMessage != null ? this.collectMessage : "";
                        CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_9002", new Object[]{this.collectMessage}));
                        LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"timeout", (Throwable)e);
                        Object var4_3 = null;
                        this.collectorProgress = 100;
                        LOCATION.debugT("timeout", ResourceUtil.formatString("sld_9001"));
                        LOCATION.debugT("timeout", ResourceUtil.formatString("sld_9072", new Object[]{this.timeFormat.format(this.nextStartTime)}));
                    }
                }
            }
            this.setTimeInterval();
            Object var6_8 = null;
            try {
                if (!this.unlock()) {
                    CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_9003"));
                }
                break block18;
            }
            catch (SldServiceException e2) {
                LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"timeout", (Throwable)((Object)e2));
                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_9003"));
            }
            break block18;
            {
                catch (Exception e) {
                    CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3017"));
                    LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"timeout", (Throwable)e);
                    Object var6_9 = null;
                    try {
                        if (!this.unlock()) {
                            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_9003"));
                        }
                        break block18;
                    }
                    catch (SldServiceException e2) {
                        LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"timeout", (Throwable)((Object)e2));
                        CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_9003"));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {
                    if (!this.unlock()) {
                        CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_9003"));
                    }
                }
                catch (SldServiceException e2) {
                    LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"timeout", (Throwable)((Object)e2));
                    CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_9003"));
                }
                throw throwable;
            }
        }
        LOCATION.infoT("timeout", "timeout: send/receive [bytes]: " + this.sendReceiveBytes);
    }

    public boolean check() {
        String method = "check(void)";
        boolean rvalue = false;
        this.sendReceiveBytes = 0;
        this.processingStartTime = System.currentTimeMillis();
        if (this.processingStartTime - this.lastCheckTime >= 5000L || this.isInitialRun) {
            this.lastCheckTime = this.processingStartTime;
            try {
                if (this.isInitialRun) {
                    CollectTimeInterval cti = this.getLastCollectTime();
                    if (cti == null || cti != null && cti.checkIntervalBeginIsHistoryForMin(5L)) {
                        rvalue = this.lock();
                    }
                    this.isInitialRun = false;
                } else if (this.lock() && !(rvalue = this.checkTimeBasedRun())) {
                    this.unlock();
                }
            }
            catch (SldServiceException e) {
                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_9003"));
                LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"check(void)", (Throwable)((Object)e));
            }
        }
        return rvalue;
    }

    public void timeoutProcessing() {
        try {
            if (this.timeoutMgr != null) {
                this.timeoutMgr.unregisterTimeoutListener((TimeoutListener)this);
                this.timeout();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.timeoutMgr.registerTimeoutListener((TimeoutListener)this, this.params.getRepeatTimeMs(), this.params.getRepeatTimeMs(), 0L, true);
            throw throwable;
        }
        this.timeoutMgr.registerTimeoutListener((TimeoutListener)this, this.params.getRepeatTimeMs(), this.params.getRepeatTimeMs(), 0L, true);
    }

    public void stopRequest() {
        this.stopIt = true;
    }

    public boolean hasValidConnectParams() {
        return this.params != null && (this.params.hasValidRfcParams() || this.params.hasValidHttpParams());
    }

    public synchronized ServiceManagementResponse doMgmCollect() {
        String method = "doMgmCollect";
        this.sendReceiveBytes = 0;
        LOCATION.debugT("doMgmCollect", ResourceUtil.formatString("sld_9068"));
        StringBuffer returnMsg = new StringBuffer();
        ServiceManagementResponse rvalue = new ServiceManagementResponse(false);
        if (!this.collectIsRunning) {
            try {
                block7: {
                    try {
                        this.isManagementRun = true;
                        this.doCollect();
                        if (this.bridgeComm == null) {
                            this.setMessage(returnMsg, ResourceUtil.formatStringNoParameterLocalization("sld_3001", new Object[]{"sld_3039"}));
                            rvalue.setMessage(returnMsg.toString());
                            break block7;
                        }
                        rvalue.setResult(true);
                    }
                    catch (Exception e) {
                        LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"doMgmCollect", (Throwable)e);
                        this.collectMessage = this.collectMessage != null ? this.collectMessage : "";
                        this.setMessage(returnMsg, ResourceUtil.formatStringNoParameterLocalization("sld_9002", new Object[]{this.collectMessage}));
                        rvalue.setMessage(returnMsg.toString());
                        Object var6_5 = null;
                        this.collectorProgress = 100;
                        this.isManagementRun = false;
                    }
                }
                Object var6_4 = null;
                this.collectorProgress = 100;
                this.isManagementRun = false;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.collectorProgress = 100;
                this.isManagementRun = false;
                throw throwable;
            }
        } else {
            this.setMessage(returnMsg, ResourceUtil.formatString("sld_9030"));
            rvalue.setMessage(returnMsg.toString());
        }
        LOCATION.debugT("doMgmCollect", ResourceUtil.formatString("sld_9069"));
        LOCATION.infoT("doMgmCollect", "doMgmCollect: Send/receive [bytes]: " + this.sendReceiveBytes);
        return rvalue;
    }

    public boolean setConfigParams(Properties props) {
        Object object = this.accessConfigParams;
        synchronized (object) {
            String method = "setConfigParams";
            Params.RuntimeParams rtParam = this.params.getRuntimeParams().getClone();
            Iterator it = ((Hashtable)props).keySet().iterator();
            while (it.hasNext()) {
                String keyName;
                rtParam.setParameter(keyName, ((Hashtable)props).get(keyName = (String)it.next()) != null ? ((String)((Hashtable)props).get(keyName)).trim() : "");
                if (keyName.equalsIgnoreCase("HttpPassword")) continue;
                LOCATION.debugT("setConfigParams", ResourceUtil.formatStringNoParameterLocalization("sld_9053", new Object[]{keyName, ((Hashtable)props).get(keyName)}));
            }
            this.params.getRuntimeParams().setClone(rtParam);
            boolean b1 = true;
            boolean b2 = true;
            if (this.params.containsRfcParams(props)) {
                b1 = this.params.setSecureStoreRfcParams();
            }
            if (this.params.containsHttpParams(props)) {
                b2 = this.params.setSecureStoreHttpParams();
            }
            if (b1 && b2) {
                LOCATION.debugT("setConfigParams", ResourceUtil.formatString("sld_9054"));
            } else {
                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3035"));
            }
            boolean bl = b1 && b2;
            return bl;
        }
    }

    public Properties getConfigParams() {
        Object object = this.accessConfigParams;
        synchronized (object) {
            Properties props = new Properties();
            props.setProperty("VersionId", this.params.getVersionId());
            props.setProperty("TypeId", this.params.getTypeId());
            this.params.refreshConfig();
            Params.RuntimeParams rtParam = this.params.getRuntimeParams().getClone();
            ((Hashtable)props).putAll(rtParam.getSettings());
            Properties properties = props;
            return properties;
        }
    }

    public SendInfo getLastSendInfo() {
        SendInfo.setServiceContext(this.applServCtx);
        return SendInfo.getInfoLocalNode();
    }

    public boolean deleteRfcParams() {
        return this.params.deleteRfcParams();
    }

    public boolean deleteHttpParams() {
        return this.params.deleteHttpParams();
    }

    protected void setManagementIf(ServiceManagementInterface serviceManagement) {
        this.serviceManagement = serviceManagement;
    }

    protected ServiceManagementInterface getManagementIf() {
        return this.serviceManagement;
    }

    private void setTimeInterval() throws SldServiceException {
        this.setTimeIntervalDatabase();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setTimeIntervalDatabase() throws SldServiceException {
        String method = "setTimeIntervalDatabase";
        int MAX_WAITING_LOOP = 100;
        CollectTimeInterval cti = null;
        long intervalTimeMin = this.params.getRepeatTimeMin() > 1L ? this.params.getRepeatTimeMin() - 1L : this.params.getRepeatTimeMin();
        try {
            ConfigurationHandlerFactory cfgFactory = this.applServCtx.getCoreContext().getConfigurationHandlerFactory();
            ConfigurationHandler cfgHandler = cfgFactory.getConfigurationHandler();
            Configuration tmCfgRoot = null;
            Configuration tmCfg = null;
            int cnt = 0;
            while (true) {
                block14: {
                    Object var14_12;
                    if (cnt >= 100) {
                        return;
                    }
                    try {
                        try {
                            tmCfgRoot = cfgHandler.openConfiguration("SLD", 1);
                            tmCfg = tmCfgRoot.getSubConfiguration("CollectTimeInterval");
                            cti = new CollectTimeInterval(this.processingStartTime, intervalTimeMin);
                            tmCfg.modifyConfigEntry("Interval", (Object)cti.getAsString());
                            var14_12 = null;
                        }
                        catch (ConfigurationLockedException e) {
                            ServiceUtils.waitSeconds(1L);
                            LOCATION.debugT("setTimeIntervalDatabase", ResourceUtil.formatString("sld_9087"));
                            var14_12 = null;
                            cfgHandler.commit();
                            cfgHandler.closeAllConfigurations();
                            break block14;
                        }
                        catch (NameNotFoundException e) {
                            if (tmCfgRoot == null) {
                                tmCfgRoot = cfgHandler.createRootConfiguration("SLD");
                            }
                            if (tmCfg == null && tmCfgRoot != null) {
                                tmCfg = tmCfgRoot.createSubConfiguration("CollectTimeInterval");
                            }
                            if (tmCfg != null && tmCfgRoot != null) {
                                cti = new CollectTimeInterval(this.processingStartTime, intervalTimeMin);
                                tmCfg.addConfigEntry("Interval", (Object)cti.getAsString());
                                var14_12 = null;
                                cfgHandler.commit();
                                cfgHandler.closeAllConfigurations();
                                return;
                            }
                            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3078"));
                            throw new SldServiceException("sld_3078");
                        }
                    }
                    catch (Throwable throwable) {
                        var14_12 = null;
                        cfgHandler.commit();
                        cfgHandler.closeAllConfigurations();
                        throw throwable;
                    }
                    cfgHandler.commit();
                    cfgHandler.closeAllConfigurations();
                    return;
                }
                ++cnt;
            }
        }
        catch (InconsistentReadException e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3078"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"setTimeIntervalDatabase", (Throwable)e);
            throw new SldServiceException("sld_3078", e);
        }
        catch (ConfigurationException e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3078"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"setTimeIntervalDatabase", (Throwable)e);
            throw new SldServiceException("sld_3078", e);
        }
    }

    private void setTimeIntervalMessage() throws SldServiceException {
        String method = "setTimeIntervalMessage";
        CollectTimeInterval cti = null;
        long intervalTimeMin = this.params.getRepeatTimeMin() > 1L ? this.params.getRepeatTimeMin() - 1L : this.params.getRepeatTimeMin();
        try {
            cti = (CollectTimeInterval)this.jndiCtx.lookup("SLD_COLLECT_TIME_INTERVAL");
            if (intervalTimeMin > 1L) {
                cti.setTimeInterval(this.processingStartTime, intervalTimeMin);
            } else {
                cti.setTimeIntervalMs(this.processingStartTime, 300000L);
            }
            ClusterElement ce = this.applServCtx.getClusterContext().getClusterMonitor().getCurrentParticipant();
            SldMessage smsg = new SldMessage();
            smsg.setMsgId(105);
            smsg.addCallParam("SetCollectTime", cti);
            ClusterElement[] ces = this.getAllServerClusterElements();
            int i = 0;
            while (i < ces.length) {
                if (ces[i].getClusterId() != ce.getClusterId()) {
                    try {
                        byte[] ba = smsg.toByteArray();
                        this.sendReceiveBytes += ba.length;
                        MessageAnswer answ = msgCtx.sendAndWaitForAnswer(ces[i].getClusterId(), smsg.getMsgId(), ba, 0, ba.length, 0L);
                        SldMessage rmsg = SldMessage.fromByteArray(answ.getMessage());
                        if (rmsg == null || rmsg.getMsgId() != 1) {
                            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_1011", new Object[]{ces[i]}));
                        }
                        if (rmsg != null) {
                            this.sendReceiveBytes += rmsg.toByteArray().length;
                        }
                    }
                    catch (Exception e) {
                        CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_1012", new Object[]{ces[i]}));
                        LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"setTimeIntervalMessage", (Throwable)e);
                    }
                }
                ++i;
            }
            this.jndiCtx.rebind("SLD_COLLECT_TIME_INTERVAL", (Object)cti);
        }
        catch (InvalidAttributesException e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_1009"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"setTimeIntervalMessage", (Throwable)e);
        }
        catch (NamingException e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_1010"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"setTimeIntervalMessage", (Throwable)e);
        }
    }

    private CollectTimeInterval getLastCollectTime() {
        return this.getLastCollectTimeIntervalDatabase();
    }

    private boolean checkTimeBasedRun() {
        return this.checkTimeBasedRunDatabase();
    }

    private boolean checkTimeBasedRunDatabase() {
        CollectTimeInterval cti = this.getLastCollectTimeIntervalDatabase();
        return cti != null && !cti.getIntervalEndTime().before(new Date());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CollectTimeInterval getLastCollectTimeIntervalDatabase() {
        String method = "getLastCollectTimeIntervalDatabase";
        CollectTimeInterval rvalue = null;
        int MAX_WAITING_LOOP = 100;
        try {
            ConfigurationHandlerFactory cfgFactory = this.applServCtx.getCoreContext().getConfigurationHandlerFactory();
            ConfigurationHandler cfgHandler = cfgFactory.getConfigurationHandler();
            int cnt = 0;
            while (true) {
                block11: {
                    Object var10_12;
                    if (cnt >= 100) {
                        return rvalue;
                    }
                    try {
                        try {
                            Configuration tmCfgRoot = cfgHandler.openConfiguration("SLD", 0);
                            Configuration tmCfg = tmCfgRoot.getSubConfiguration("CollectTimeInterval");
                            rvalue = CollectTimeInterval.getFromString((String)tmCfg.getConfigEntry("Interval"));
                            var10_12 = null;
                        }
                        catch (ConfigurationLockedException e) {
                            ServiceUtils.waitSeconds(1L);
                            LOCATION.debugT("getLastCollectTimeIntervalDatabase", ResourceUtil.formatString("sld_9087"));
                            var10_12 = null;
                            cfgHandler.closeAllConfigurations();
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        var10_12 = null;
                        cfgHandler.closeAllConfigurations();
                        throw throwable;
                    }
                    cfgHandler.closeAllConfigurations();
                    return rvalue;
                }
                ++cnt;
            }
        }
        catch (NameNotFoundException e) {
            return rvalue;
        }
        catch (ConfigurationException e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3078"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"getLastCollectTimeIntervalDatabase", (Throwable)e);
            return rvalue;
        }
        catch (Exception e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3078"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"getLastCollectTimeIntervalDatabase", (Throwable)e);
        }
        return rvalue;
    }

    private boolean checkTimeBasedRunMessage() {
        CollectTimeInterval cti = this.getLastCollectTimeIntervalMessage();
        return cti != null && !cti.isInitial() && !cti.getIntervalEndTime().before(new Date());
    }

    private CollectTimeInterval getLastCollectTimeIntervalMessage() {
        String method = "getLastCollectTimeIntervalMessage";
        CollectTimeInterval rvalue = null;
        CollectTimeInterval cti = null;
        CollectTimeInterval localCti = null;
        try {
            int currId = clusterMonitor.getCurrentParticipant().getClusterId();
            SldMessage smsg = new SldMessage();
            smsg.setMsgId(107);
            ClusterElement[] ces = this.getAllServerClusterElements();
            CollectTimeInterval maxInterval = null;
            int i = 0;
            while (i < ces.length) {
                block15: {
                    if (ces[i].getClusterId() != currId) {
                        try {
                            byte[] ba = smsg.toByteArray();
                            this.sendReceiveBytes += ba.length;
                            MessageAnswer answ = msgCtx.sendAndWaitForAnswer(ces[i].getClusterId(), smsg.getMsgId(), ba, 0, ba.length, 0L);
                            SldMessage rmsg = SldMessage.fromByteArray(answ.getMessage());
                            if (rmsg == null || rmsg.getMsgId() != 1) break block15;
                            this.sendReceiveBytes += rmsg.toByteArray().length;
                            cti = (CollectTimeInterval)rmsg.getFirstParamValue();
                            if (cti != null && (maxInterval == null || maxInterval.isInitial())) {
                                maxInterval = cti;
                            }
                        }
                        catch (Exception e) {
                            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_1013", new Object[]{ces[i]}));
                            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"getLastCollectTimeIntervalMessage", (Throwable)e);
                        }
                    } else {
                        try {
                            localCti = (CollectTimeInterval)this.jndiCtx.lookup("SLD_COLLECT_TIME_INTERVAL");
                            if (localCti != null) {
                                if (localCti.isInitial()) {
                                    localCti = new CollectTimeInterval(this.params.getRepeatTimeMin());
                                }
                                if (maxInterval == null || maxInterval.isInitial()) {
                                    maxInterval = localCti;
                                } else if (!(maxInterval.isInitial() || localCti.isInitial() || maxInterval.getIntervalEndTime().after(localCti.getIntervalEndTime()))) {
                                    maxInterval = localCti;
                                }
                            }
                        }
                        catch (NamingException e) {
                            localCti = new CollectTimeInterval(this.params.getRepeatTimeMin());
                            this.jndiCtx.bind("SLD_COLLECT_TIME_INTERVAL", (Object)localCti);
                            if (maxInterval == null || maxInterval.getIntervalEndTime().after(localCti.getIntervalEndTime())) break block15;
                            maxInterval = localCti;
                        }
                    }
                }
                ++i;
            }
            rvalue = maxInterval;
        }
        catch (Exception e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_2007"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"getLastCollectTimeIntervalMessage", (Throwable)e);
        }
        return rvalue;
    }

    private boolean lock() throws SldServiceException {
        String method = "lock(void)";
        boolean locked = true;
        try {
            this.siLocking.lock("_SLD_", "sld_lock_arg", 'X');
            LOCATION.infoT("lock(void)", ResourceUtil.formatString("sld_9085", new Object[]{String.valueOf(clusterMonitor.getCurrentParticipant().getClusterId())}));
            this.thisIsTheLockHolder = true;
        }
        catch (LockException e) {
            locked = false;
        }
        catch (TechnicalLockException e) {
            locked = false;
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_9005"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"lock(void)", (Throwable)e);
            throw new SldServiceException("sld_3002", e);
        }
        catch (IllegalArgumentException e) {
            locked = false;
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_2003"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"lock(void)", (Throwable)e);
            throw new SldServiceException("sld_2003", e);
        }
        return locked;
    }

    private boolean unlock() throws SldServiceException {
        String method = "unlock";
        boolean unlocked = true;
        try {
            this.siLocking.unlock("_SLD_", "sld_lock_arg", 'X');
            LOCATION.infoT("unlock", ResourceUtil.formatString("sld_9086", new Object[]{String.valueOf(clusterMonitor.getCurrentParticipant().getClusterId())}));
            this.thisIsTheLockHolder = false;
        }
        catch (TechnicalLockException e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_9005"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"unlock", (Throwable)e);
            unlocked = false;
            throw new SldServiceException("sld_3003", e);
        }
        catch (IllegalArgumentException e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_2004"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"unlock", (Throwable)e);
            unlocked = false;
            throw new SldServiceException("sld_2004", e);
        }
        return unlocked;
    }

    private synchronized void doCollect() throws SldServiceException {
        String method = "doCollect";
        try {
            this.collectMessage = null;
            this.collectIsRunning = true;
            if (!this.stopIt) {
                this.newCollectorInfo(ResourceUtil.formatString("sld_4001"));
                this.collectorStatus = 1;
                this.collectorProgress = 0;
                J2EEData currJ2EEData = this.getJ2EEData();
                if (!this.stopIt) {
                    if (currJ2EEData.empty()) {
                        CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_9027"));
                    }
                    if (this.params.isFullDataTrace()) {
                        this.addCollectorInfo(ResourceUtil.formatString("sld_4007"));
                        currJ2EEData.write2File();
                    }
                    boolean hasValidCommParams = this.setBridgeCommunication();
                    if ((this.isManagementRun || this.params.getSendData() == 2) && !currJ2EEData.empty() || this.params.getSendData() == 1) {
                        try {
                            if (hasValidCommParams) {
                                this.addCollectorInfo(ResourceUtil.formatString(this.params.useHttpCommunication() ? "sld_4012" : "sld_4006"));
                                this.bridgeComm.connect();
                                this.bridgeComm.prepare();
                                this.bridgeComm.setData(currJ2EEData);
                                this.bridgeComm.send();
                                this.addCollectorInfo(ResourceUtil.formatString("sld_4015"));
                                CATEGORY.infoT(LOCATION, "doCollect", ResourceUtil.formatString("sld_6001"));
                            } else {
                                this.addCollectorInfo(ResourceUtil.formatString("sld_4014"));
                                CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_9040"));
                            }
                        }
                        catch (SldServiceException e) {
                            this.collectorStatus = 2;
                            if (this.params.useHttpCommunication()) {
                                this.collectMessage = e.getMessage();
                                this.addCollectorInfo(ResourceUtil.formatStringNoParameterLocalization("sld_4011", new Object[]{e.getMessage()}));
                            } else if (this.params.useRfcCommunication()) {
                                this.addCollectorInfo(ResourceUtil.formatString("sld_4009"));
                            }
                            this.setSendInfo(false);
                            CATEGORY.warningT(LOCATION, "doCollect", ResourceUtil.formatStringNoParameterLocalization("sld_6000", new Object[]{this.collectMessage}));
                            throw e;
                        }
                        this.setSendInfo(hasValidCommParams);
                    } else {
                        this.addCollectorInfo(ResourceUtil.formatString(this.params.useHttpCommunication() ? "sld_4010" : "sld_4008"));
                        LOCATION.debugT("doCollect", ResourceUtil.formatString(this.params.useHttpCommunication() ? "sld_4010" : "sld_4008"));
                        this.setSendInfo(true);
                    }
                    if (this.oldJ2EEData != null && currJ2EEData.equals(this.oldJ2EEData)) {
                        LOCATION.debugT("doCollect", ResourceUtil.formatString("sld_9026"));
                        if (this.params.getSendData() == 2 || this.isManagementRun) {
                            LOCATION.debugT("doCollect", ResourceUtil.formatString("sld_9046"));
                        }
                    }
                }
                if (!this.isManagementRun) {
                    this.oldJ2EEData = currJ2EEData;
                }
            }
            Object var6_5 = null;
            this.collectIsRunning = false;
            int n = this.collectorStatus = this.collectorStatus == 1 ? 0 : 2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.collectIsRunning = false;
            int n = this.collectorStatus = this.collectorStatus == 1 ? 0 : 2;
            if (this.bridgeComm != null) {
                this.bridgeComm.disconnect();
            }
            this.addCollectorInfo(ResourceUtil.formatString("sld_4013"));
            throw throwable;
        }
        if (this.bridgeComm != null) {
            this.bridgeComm.disconnect();
        }
        this.addCollectorInfo(ResourceUtil.formatString("sld_4013"));
    }

    private J2EEData getJ2EEData() throws SldServiceException {
        String method = "getJ2EEData";
        J2EEData j2eeData = new J2EEData(this.params.getTypeId(), this.params.getVersionId());
        List classList = GetDataClasses.getClasses();
        this.addCollectorInfo(ResourceUtil.formatString("sld_4002"));
        int totalCount = classList.size();
        int currCount = 0;
        GetData.newCollecting();
        Method meth = null;
        String servedClassName = null;
        Iterator it = classList.iterator();
        while (it.hasNext() && !this.stopIt) {
            Class clazz = (Class)it.next();
            if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) continue;
            LOCATION.debugT("getJ2EEData", ResourceUtil.formatStringNoParameterLocalization("sld_9029", new Object[]{clazz.getName()}));
            this.addCollectorInfo(ResourceUtil.formatStringNoParameterLocalization("sld_4003", new Object[]{clazz.getName()}));
            try {
                Constructor construct = clazz.getDeclaredConstructor(class$com$sap$engine$frame$ApplicationServiceContext == null ? DataCollector.class$("com.sap.engine.frame.ApplicationServiceContext") : class$com$sap$engine$frame$ApplicationServiceContext, class$com$sap$sldserv$Params$Ids == null ? DataCollector.class$("com.sap.sldserv.Params$Ids") : class$com$sap$sldserv$Params$Ids);
                Object o = construct.newInstance(this.applServCtx, this.params.getIdParams());
                try {
                    meth = clazz.getMethod(CLASS_NAME_METHOD, null);
                    servedClassName = (String)meth.invoke(o, null);
                    if (this.params.negativeListContained(servedClassName)) {
                        LOCATION.debugT("getJ2EEData", ResourceUtil.formatStringNoParameterLocalization("sld_9045", new Object[]{servedClassName}));
                        continue;
                    }
                    meth = clazz.getMethod(GETTER_METHOD, null);
                    j2eeData.merge((J2EEData)meth.invoke(o, null));
                }
                catch (NoSuchMethodException e) {}
            }
            catch (Exception e) {
                this.collectorStatus = 2;
                CATEGORY.warningT(LOCATION, ResourceUtil.formatStringNoParameterLocalization("sld_3014", new Object[]{clazz.getName()}));
                LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"getJ2EEData", (Throwable)e);
            }
            this.collectorProgress = this.calculateProgress(++currCount, totalCount);
        }
        if (this.collectorStatus == 2) {
            this.addCollectorInfo(ResourceUtil.formatString("sld_4004"));
        } else {
            this.addCollectorInfo(ResourceUtil.formatString("sld_4005"));
        }
        LOCATION.infoT("getJ2EEData", "GetData: send/receive [bytes]: " + GetData.getSendReceiveBytes());
        return j2eeData;
    }

    private int calculateProgress(int currentCount, int totalCount) {
        return totalCount == 0 ? 0 : Math.abs((int)((double)currentCount / (double)totalCount * 100.0));
    }

    private void prepareJndiContext() throws SldServiceException {
        String method = "buildJndiContext";
        try {
            this.jndiCtx = new InitialContext();
        }
        catch (NamingException e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_1008"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"buildJndiContext", (Throwable)e);
            throw new SldServiceException(ResourceUtil.formatString("sld_1008"), e);
        }
        try {
            this.jndiCtx.bind("SLD_COLLECT_TIME_INTERVAL", (Object)new CollectTimeInterval());
        }
        catch (NameAlreadyBoundException e) {
        }
        catch (InvalidAttributesException e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_1009"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"buildJndiContext", (Throwable)e);
            throw new SldServiceException(ResourceUtil.formatString("sld_1009"), e);
        }
        catch (NamingException e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_1010"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"buildJndiContext", (Throwable)e);
            throw new SldServiceException(ResourceUtil.formatString("sld_1010"), e);
        }
    }

    private void prepareMessaging() {
        msgCtx = this.applServCtx.getClusterContext().getMessageContext();
    }

    private void setSendInfo(boolean success) {
        String method = "setSendInfoMessage";
        SendInfo sendInfo = null;
        ClusterElement ce = this.applServCtx.getClusterContext().getClusterMonitor().getCurrentParticipant();
        try {
            Date nst = null;
            if (this.isManagementRun) {
                SendInfo.setServiceContext(this.applServCtx);
                SendInfo si = SendInfo.getInfoLocalNode();
                if (si != null) {
                    nst = si.getNextTime();
                }
            } else {
                nst = this.nextStartTime != null ? this.nextStartTime : new Date(System.currentTimeMillis() + this.params.getRepeatTimeMs());
            }
            sendInfo = new SendInfo(this.applServCtx, this.useRfc, this.params.getRuntimeParams(), ce.getClusterId(), InetAddress.getLocalHost().getHostName(), success, this.isManagementRun, this.params.getHttpsSetting(), nst);
            SendInfo.setServiceContext(this.applServCtx);
            SendInfo.setInfoLocalNode(sendInfo);
        }
        catch (Exception e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_1010"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"setSendInfoMessage", (Throwable)e);
        }
    }

    private ClusterElement[] getAllServerClusterElements() {
        ClusterElement currentElement = clusterMonitor.getCurrentParticipant();
        ClusterElement[] clusterElements = clusterMonitor.getServiceNodes();
        ClusterElement[] ce = new ClusterElement[clusterElements.length];
        int count = 0;
        int i = 0;
        while (i < clusterElements.length) {
            if (clusterElements[i].getType() == 2) {
                ce[count++] = clusterElements[i];
            }
            ++i;
        }
        ClusterElement[] rce = new ClusterElement[count + 1];
        rce[0] = currentElement;
        int i2 = 0;
        int j = 1;
        while (i2 < count) {
            rce[j] = ce[i2];
            ++i2;
            ++j;
        }
        return rce;
    }

    private void setMessage(StringBuffer msgOut, String msgIn) {
        if (msgOut != null) {
            msgOut.delete(0, msgOut.length());
            msgOut.append(msgIn);
        }
    }

    public String getCollectorInformation() {
        Object object = this.accessObject;
        synchronized (object) {
            String string = this.collectorInfo;
            return string;
        }
    }

    public int getCollectorProgress() {
        return this.collectorProgress;
    }

    public int getCollectorStatus() {
        return this.collectorStatus;
    }

    private void addCollectorInfo(String info) {
        String string = this.collectorInfo;
        synchronized (string) {
            this.collectorInfo = this.collectorInfo + LINE_SEPARATOR + this.timeFormat.format(new Date()) + ": " + info;
        }
    }

    private void newCollectorInfo(String info) {
        String string = this.collectorInfo;
        synchronized (string) {
            this.collectorInfo = "";
            this.collectorInfo = this.collectorInfo + LINE_SEPARATOR + this.timeFormat.format(new Date()) + ": " + info;
        }
    }

    private void initTimer() throws SldServiceException {
        try {
            this.timeoutMgr = (TimeoutManager)this.applServCtx.getContainerContext().getObjectRegistry().getServiceInterface("timeout");
        }
        catch (Exception e) {
            throw new SldServiceException("sld_1004");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteInfoLocalNodeDb() {
        String method = "deleteInfoLocalNodeDb";
        int MAX_WAITING_LOOP = 5;
        if (this.applServCtx == null) return;
        try {
            ConfigurationHandlerFactory cfgFactory = this.applServCtx.getCoreContext().getConfigurationHandlerFactory();
            ConfigurationHandler cfgHandler = cfgFactory.getConfigurationHandler();
            Configuration tmCfgRoot = null;
            int cnt = 0;
            while (true) {
                block10: {
                    Object var9_11;
                    if (cnt >= 5) {
                        return;
                    }
                    try {
                        try {
                            tmCfgRoot = cfgHandler.openConfiguration("SLD", 1);
                            tmCfgRoot.deleteAllSubConfigurations();
                            CATEGORY.infoT(LOCATION, ResourceUtil.formatString("sld_9088"));
                        }
                        catch (ConfigurationLockedException e) {
                            ServiceUtils.waitSeconds(1L);
                            LOCATION.debugT("deleteInfoLocalNodeDb", ResourceUtil.formatString("sld_9087"));
                            var9_11 = null;
                            cfgHandler.commit();
                            cfgHandler.closeAllConfigurations();
                            break block10;
                        }
                        var9_11 = null;
                    }
                    catch (Throwable throwable) {
                        var9_11 = null;
                        cfgHandler.commit();
                        cfgHandler.closeAllConfigurations();
                        throw throwable;
                    }
                    cfgHandler.commit();
                    cfgHandler.closeAllConfigurations();
                }
                ++cnt;
            }
        }
        catch (NameNotFoundException e) {
            return;
        }
        catch (ConfigurationException e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3079"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"deleteInfoLocalNodeDb", (Throwable)e);
            return;
        }
        catch (Exception e) {
            CATEGORY.warningT(LOCATION, ResourceUtil.formatString("sld_3079"));
            LoggingHelper.traceThrowable((int)100, (Location)LOCATION, (String)"deleteInfoLocalNodeDb", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

