/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sldserv;

import com.sap.sldserv.exception.SldServiceException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class CollectTimeInterval
implements Serializable {
    static final long serialVersionUID = -1528470864076046196L;
    private static final char VALUE_SEPERATOR = ':';
    public static final String CTI_NAME = "SLD_COLLECT_TIME_INTERVAL";
    private long fromTime = 0L;
    private long toTime = 0L;

    CollectTimeInterval() {
    }

    CollectTimeInterval(Date fromTime, Date toTime) {
        this.fromTime = fromTime.getTime();
        this.toTime = toTime.getTime();
    }

    CollectTimeInterval(long fromTime, long min) throws SldServiceException {
        this.setTimeInterval(fromTime, min);
    }

    CollectTimeInterval(long min) {
        this.setTimeInterval(min);
    }

    private CollectTimeInterval(String s) throws SldServiceException, NumberFormatException {
        int i = s.indexOf(58);
        if (i <= 0) {
            throw new SldServiceException("Invalid initalization string: " + s);
        }
        String a = s.substring(0, i);
        String b = s.substring(i + 1);
        this.fromTime = Long.parseLong(a);
        this.toTime = Long.parseLong(b);
    }

    boolean isInitial() {
        return this.fromTime == 0L || this.toTime == 0L;
    }

    private void setTimeInterval(long min) {
        this.fromTime = System.currentTimeMillis();
        this.toTime = this.fromTime + min * 60000L;
    }

    void setTimeInterval(long fromTime, long min) throws SldServiceException {
        this.fromTime = fromTime;
        this.toTime = fromTime + min * 60000L;
        if (fromTime > this.toTime) {
            throw new SldServiceException("Invalid time interval specified.");
        }
    }

    void setTimeIntervalMs(long fromTime, long ms) throws SldServiceException {
        this.fromTime = fromTime;
        this.toTime = fromTime + ms;
        if (fromTime > this.toTime) {
            throw new SldServiceException("Invalid time interval specified.");
        }
    }

    boolean checkIsInInterval() throws SldServiceException {
        if (!this.isInitial()) {
            long currTime = System.currentTimeMillis();
            return this.fromTime >= currTime && currTime <= this.toTime;
        }
        throw new SldServiceException("Time interval not initalized");
    }

    boolean checkIsAfterInterval() throws SldServiceException {
        if (!this.isInitial()) {
            return this.toTime <= System.currentTimeMillis();
        }
        throw new SldServiceException("Time interval not initalized");
    }

    boolean checkIntervalEndIsHistoryForMin(long min) {
        return this.toTime + min * 1000L <= System.currentTimeMillis();
    }

    boolean checkIntervalBeginIsHistoryForMin(long min) {
        return this.fromTime + min * 1000L <= System.currentTimeMillis();
    }

    public String toString() {
        SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy.MM.dd@HH:mm:ss");
        if (!this.isInitial()) {
            return "(fromTime, toTime) = (" + timeFormat.format(new Date(this.fromTime)) + ", " + timeFormat.format(new Date(this.toTime)) + ")";
        }
        return this.getClass().getName() + ": <initial>";
    }

    public String getAsString() {
        return String.valueOf(this.fromTime) + ':' + String.valueOf(this.toTime);
    }

    public static CollectTimeInterval getFromString(String s) throws SldServiceException {
        return new CollectTimeInterval(s);
    }

    public void setInfoJndi(String jndiName) throws NamingException {
        InitialContext jndiCtx = new InitialContext();
        jndiCtx.rebind(jndiName, (Object)this);
    }

    Date getIntervalEndTime() {
        return new Date(this.toTime);
    }
}

