/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.plugins.resources;

import com.sap.portal.plugins.resources.ConfigElement;
import com.sap.portal.plugins.resources.IConfigResource;
import com.sap.portal.plugins.tools.IConfigConstants;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public abstract class ConfigResource
extends ConfigElement
implements IConfigResource {
    protected ConfigResource(IResource resource) {
        super(resource);
    }

    public void delete() throws CoreException {
        this.m_resource.delete(false, IConfigConstants.PROJECT_MONITOR);
    }

    public void copy(IConfigResource out) throws CoreException {
        if (!out.exists()) {
            out.create();
        }
        this.m_resource.copy(out.getFullPath().append(this.m_resource.getName()), false, IConfigConstants.PROJECT_MONITOR);
    }

    public void create() throws CoreException {
        this.createFolders((IResource)this.getParent());
    }

    public void move(IConfigResource resource) throws CoreException {
        this.copy(resource);
        this.delete();
    }

    public IContainer getParent() {
        return this.m_resource.getParent();
    }

    public int getType() {
        return this.m_resource.getType();
    }

    public String getFileExtension() {
        return this.m_resource.getFileExtension();
    }

    private void createFolders(IResource resource) throws CoreException {
        if (!resource.exists()) {
            this.createFolders((IResource)resource.getParent());
            this.createFolder(resource);
        }
    }

    protected void createFolder(IResource resource) throws CoreException {
        if (resource.getType() == 2) {
            ((IFolder)resource).create(false, true, IConfigConstants.PROJECT_MONITOR);
        }
    }
}

