/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.plugins.resources;

import com.sap.portal.plugins.resources.ConfigArchive;
import com.sap.portal.plugins.resources.ConfigElement;
import com.sap.portal.plugins.resources.ConfigFile;
import com.sap.portal.plugins.resources.ConfigFolder;
import com.sap.portal.plugins.resources.ConfigProperties;
import com.sap.portal.plugins.resources.ConfigResource;
import com.sap.portal.plugins.resources.IConfigArchive;
import com.sap.portal.plugins.resources.IConfigFile;
import com.sap.portal.plugins.resources.IConfigFolder;
import com.sap.portal.plugins.resources.IConfigProject;
import com.sap.portal.plugins.resources.IConfigProperties;
import com.sap.portal.plugins.resources.IConfigResource;
import com.sap.portal.plugins.tools.IConfigConstants;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class ConfigProject
extends ConfigElement
implements IConfigProject {
    protected ConfigProject(IProject project) {
        super((IResource)project);
    }

    public IConfigResource[] members() throws CoreException {
        IResource[] resource = ((IProject)this.m_resource).members();
        IConfigResource[] configResource = new ConfigResource[resource.length];
        int i = 0;
        while (i < resource.length) {
            if (resource[i].getType() == 2) {
                configResource[i] = new ConfigFolder((IFolder)resource[i]);
            } else if (resource[i].getType() == 1) {
                configResource[i] = new ConfigFile((IFile)resource[i]);
            }
            ++i;
        }
        return configResource;
    }

    public IConfigFile getFile(String path) {
        return new ConfigFile(((IProject)this.m_resource).getFile(path));
    }

    public IConfigFile getFile(IPath path) {
        return new ConfigFile(((IProject)this.m_resource).getFile(path));
    }

    public IConfigFolder getFolder(String path) {
        return new ConfigFolder(((IProject)this.m_resource).getFolder(path));
    }

    public IConfigFolder getFolder(IPath path) {
        return new ConfigFolder(((IProject)this.m_resource).getFolder(path));
    }

    public IConfigProperties getProperties(String path) throws IOException, CoreException {
        return new ConfigProperties(((IProject)this.m_resource).getFile(path));
    }

    public IConfigProperties getProperties(IPath path) throws IOException, CoreException {
        return new ConfigProperties(((IProject)this.m_resource).getFile(path));
    }

    public IConfigArchive getArchive(String path) {
        return new ConfigArchive(((IProject)this.m_resource).getFile(path));
    }

    public IConfigArchive getArchive(IPath path) {
        return new ConfigArchive(((IProject)this.m_resource).getFile(path));
    }

    public void refresh() throws CoreException {
        ((IProject)this.m_resource).refreshLocal(2, IConfigConstants.PROJECT_MONITOR);
    }
}

