/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.plugins.resources;

import com.sap.portal.plugins.resources.ConfigManifest;
import com.sap.portal.plugins.resources.ConfigResource;
import com.sap.portal.plugins.resources.IConfigArchive;
import com.sap.portal.plugins.resources.IConfigFile;
import com.sap.portal.plugins.resources.IConfigFolder;
import com.sap.portal.plugins.resources.IConfigManifest;
import com.sap.portal.plugins.resources.IConfigResource;
import com.sap.portal.plugins.tools.ConfigPluginException;
import com.sap.portal.plugins.tools.IConfigConstants;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.InflaterInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class ConfigArchive
extends ConfigResource
implements IConfigArchive {
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private IConfigManifest mm_manifest = null;

    protected ConfigArchive(IFile file) {
        super((IResource)file);
    }

    public void extract(IConfigFolder folder) throws IOException, CoreException, ConfigPluginException {
        JarInputStream jis = new JarInputStream(new BufferedInputStream(((IFile)this.m_resource).getContents()));
        if (jis.getManifest() != null) {
            this.mm_manifest = new ConfigManifest(jis.getManifest());
        }
        this.extract(jis, folder);
        jis.close();
    }

    public void compact(IConfigManifest manifest, IConfigFolder folder) throws FileNotFoundException, IOException, CoreException {
        this.setManifest(manifest);
        this.create();
        JarOutputStream jos = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(this.m_resource.getLocation().toFile())), (Manifest)((Object)manifest));
        this.addEntry(jos, folder, folder.getFullPath().segmentCount());
        jos.close();
        this.m_resource.getParent().refreshLocal(1, IConfigConstants.PROJECT_MONITOR);
    }

    public IConfigManifest getManifest() throws ConfigPluginException {
        if (this.mm_manifest == null) {
            throw new ConfigPluginException("Missing Manifest file in archive " + this.m_resource.getFullPath());
        }
        return this.mm_manifest;
    }

    private void setManifest(IConfigManifest manifest) {
        this.mm_manifest = manifest == null ? new ConfigManifest() : manifest;
    }

    private void addEntry(JarOutputStream jos, IConfigFolder folder, int segments) throws IOException, CoreException {
        IConfigResource[] resource = folder.members();
        if (resource.length == 0) {
            jos.putNextEntry(new JarEntry(folder.getFullPath().removeFirstSegments(segments) + "/"));
        } else {
            int i = 0;
            while (i < resource.length) {
                if (resource[i].getType() == 2) {
                    this.addEntry(jos, (IConfigFolder)resource[i], segments);
                } else {
                    jos.putNextEntry(new JarEntry(resource[i].getFullPath().removeFirstSegments(segments).toString()));
                    this.process(jos, (IConfigFile)resource[i]);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void process(JarOutputStream jos, IConfigFile file) throws IOException, CoreException {
        int c;
        InputStream is = file.getContents();
        while ((c = is.read()) != -1) {
            void var4_4;
            jos.write((int)var4_4);
        }
        is.close();
    }

    private void extract(JarInputStream jis, IConfigFolder folder) throws IOException, CoreException, ConfigPluginException {
        folder.create();
        JarEntry jarEntry = null;
        Object baos = null;
        while ((jarEntry = jis.getNextJarEntry()) != null) {
            if (this.mm_manifest == null && jarEntry.getName().equalsIgnoreCase(MANIFEST_NAME)) {
                Manifest man = new Manifest();
                try {
                    man.read(this.copy(jis));
                }
                catch (IOException e) {
                    throw new ConfigPluginException("Invalid Manifest file in archive " + this.m_resource.getFullPath());
                }
                this.mm_manifest = new ConfigManifest(man);
            }
            if (jarEntry.isDirectory()) {
                folder.getFolder(jarEntry.getName()).create();
                continue;
            }
            folder.getFile(jarEntry.getName()).create(this.copy(jis));
        }
    }

    /*
     * WARNING - void declaration
     */
    private ByteArrayInputStream copy(JarInputStream jis) throws IOException {
        int c;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((c = ((InflaterInputStream)jis).read()) != -1) {
            void var3_3;
            baos.write((int)var3_3);
        }
        baos.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

