/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.plugins;

import com.sap.portal.developmentTools.general.api.IFinishResult;
import com.sap.portal.developmentTools.general.api.IParIdePlugin;
import com.sap.portal.plugins.resources.ConfigPlugin;
import com.sap.portal.plugins.resources.IConfigArchive;
import com.sap.portal.plugins.resources.IConfigFile;
import com.sap.portal.plugins.resources.IConfigFolder;
import com.sap.portal.plugins.resources.IConfigManifest;
import com.sap.portal.plugins.resources.IConfigProject;
import com.sap.portal.plugins.resources.IConfigProperties;
import com.sap.portal.plugins.resources.IConfigResource;
import com.sap.portal.plugins.tools.ConfigInfo;
import com.sap.portal.plugins.tools.ConfigPluginException;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class ConfigFrameworkArchiver
implements IParIdePlugin {
    private static final boolean VERBOSE = false;
    private static final String DIST_DIRNAME = "dist/";
    private static final String PORTALINF_DIRNAME = "PORTAL-INF/";
    private static final String CONFIG_SRC_DIRNAME = "src.config/";
    private static final String CONFIG_DIRNAME = "config/";
    private static final String LOCAL_DIRNAME = "local/";
    private static final String META_DIRNAME = "meta/";
    private static final String DATA_DIRNAME = "data/";
    private static final String TEMP_DIRNAME = "config.tmp/";
    private static final String ARCHIVE_DIRNAME = "archive/";
    private static final String INSTALL_DIRNAME = "install/";
    private static final String LIB_DIRNAME = "lib/";
    private static final String EXPANDED_DIRNAME = "expanded/";
    private static final String METAINF_DIRNAME = "META-INF/";
    private static final String SYSTEM_DIRNAME = "system";
    private static final String CLASSES_DIRNAME = "classes";
    private static final String BUNDLES_DIRNAME = "bundles";
    private static final String CONFIG_PROPERTIES = "configArchive.properties";
    private static final String PRIVATE_CONFIG_PROPERTIES = "privateArchive.properties";
    private static final String PLUGIN_HEADER_PROPERTIES = "plugin.header.properties";
    private static final String PLUGIN_PROPERTIES = "plugin.properties";
    private static final String META_EXT = "configmeta";
    private static final String ARCHIVE_EXT = "configarchive";
    private static final String CC_XML_EXT = "cc.xml";
    private static final String CO_XML_EXT = "co.xml";
    private static final String TEMP_PATH = "config.tmp/";
    private static final String ARCHIVE_PATH = "config.tmp/archive/";
    private static final String INSTALL_OUT_PATH = "config.tmp/archive/install/";
    private static final String LIB_OUT_PATH = "config.tmp/archive/install/meta/lib/";
    private static final String PORTALINF_PATH = "dist/PORTAL-INF/";
    private static final String INSTALL_IN_PATH = "src.config/install/";
    private static final String LIB_IN_PATH = "src.config/install/meta/lib/";
    private static final String CONFIG_OUT_PATH = "dist/PORTAL-INF/config/";
    private static final String PROPERTIES_PATH = "src.config/configArchive.properties";
    private static final String PRIVATE_PROPERTIES_PATH = "src.config/privateArchive.properties";
    private static final String META_METAINF_PATH = "src.config/install/meta/expanded/META-INF/";
    private static final String ARCHIVE_METAINF_PATH = "src.config/install/META-INF/";
    private static final String MAPPING_PATH = "system/command/";
    private static final String PROP_FORCE_INSTALL = "force.install.value";
    private static final String PROP_SKIP_BUILD = "skip.archive.construction";

    public void pack(Object object, IFinishResult finishResult) {
        IConfigProject project = ConfigPlugin.getProject((IProject)object);
        try {
            boolean result = this.exportArchive(project, finishResult);
            if (result) {
                finishResult.setFinalState(0);
            } else {
                finishResult.setFinalState(2);
            }
        }
        catch (Exception e) {
            this.error(finishResult, e.getMessage(), e);
            finishResult.setFinalState(2);
            this.cleanExport(project);
        }
    }

    public void unpack(Object object, IFinishResult finishResult) {
        IConfigProject project = ConfigPlugin.getProject((IProject)object);
        try {
            boolean result = this.importArchive(project, finishResult);
            if (result) {
                finishResult.setFinalState(0);
            } else {
                finishResult.setFinalState(2);
            }
        }
        catch (Exception e) {
            this.warning(finishResult, e.getMessage(), e);
            finishResult.setFinalState(1);
            this.cleanImport(project);
        }
    }

    private boolean exportArchive(IConfigProject project, IFinishResult result) {
        long date1 = System.currentTimeMillis();
        this.refresh(project);
        if (!project.getFolder(CONFIG_SRC_DIRNAME).exists()) {
            return true;
        }
        IConfigProperties properties = null;
        IConfigProperties privateProperties = null;
        try {
            properties = project.getProperties(PROPERTIES_PATH);
            properties.load();
            try {
                privateProperties = project.getProperties(PRIVATE_PROPERTIES_PATH);
                privateProperties.load();
            }
            catch (Exception e) {
                this.info(result, "No privateArchive.properties file is defined.");
                privateProperties = null;
            }
        }
        catch (Exception e) {
            this.error(result, e.getMessage(), e);
            return false;
        }
        boolean skipBuild = false;
        try {
            skipBuild = new Boolean(properties.getProperty(PROP_SKIP_BUILD));
            if (privateProperties != null) {
                boolean privateSkip = new Boolean(privateProperties.getProperty(PROP_SKIP_BUILD));
                skipBuild = skipBuild || privateSkip;
            }
            IConfigResource[] resources = project.getFolder(CONFIG_OUT_PATH).members();
            boolean makeBuild = false;
            int i = 0;
            while (i < resources.length) {
                if (resources[i].getFileExtension().equals(ARCHIVE_EXT)) {
                    makeBuild = true;
                    break;
                }
                ++i;
            }
            skipBuild = skipBuild && makeBuild;
        }
        catch (Exception e) {
            skipBuild = false;
        }
        ConfigInfo info = ConfigInfo.getInstance();
        this.cleanTemp(project);
        IConfigFolder metaFolder = project.getFolder("src.config/install/meta/expanded/");
        if (!metaFolder.exists()) {
            this.warning(result, "Invalid structure (missing " + metaFolder.getFullPath() + " folder)");
        } else if (this.isEmpty(metaFolder)) {
            this.warning(result, "Invalid structure (" + metaFolder.getFullPath() + " folder is empty)");
        } else {
            if (skipBuild) {
                this.info(result, "Archive construction skipped (forced by user)");
                return true;
            }
            try {
                IConfigResource[] resource = metaFolder.members();
                int i = 0;
                while (i < resource.length) {
                    if (resource[i].getType() == 2) {
                        this.checkPlugins(metaFolder.getFolder(resource[i].getName()), result);
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                this.warning(result, e.getMessage(), e);
            }
            IConfigManifest manifest = ConfigPlugin.getManifest();
            try {
                manifest.chooseAndPutValue(IConfigManifest.CMA_NAME, properties.getProperty("cma.name"), project.getName(), true);
                manifest.chooseAndPutValue(IConfigManifest.CMA_VERSION, properties.getProperty("cma.version"), null, true);
                manifest.chooseAndPutValue(IConfigManifest.CMA_DEPENDENCIES, properties.getProperty("cma.dependencies"), null, false);
                manifest.chooseAndPutValue(IConfigManifest.CMA_STORAGE, properties.getProperty("cma.storage"), null, true);
                manifest.chooseAndPutValue(IConfigManifest.CMA_CREATION_TIME, properties.getProperty("cma.creation.time"), info.getTime(), true);
                manifest.chooseAndPutValue(IConfigManifest.CMA_CREATION_DATE, properties.getProperty("cma.creation.date"), info.getDate(), true);
                manifest.chooseAndPutValue(IConfigManifest.CMA_CREATION_USER, properties.getProperty("cma.creation.user"), info.getUser(), true);
                manifest.chooseAndPutValue(IConfigManifest.CMA_CREATION_MACHINE, properties.getProperty("cma.creation.machine"), info.getMachine(), true);
            }
            catch (Exception e) {
                this.error(result, e.getMessage(), e);
                return false;
            }
            try {
                String name = this.getCMAName(properties);
                if (name == null || name.trim().equals("")) {
                    name = project.getName();
                }
                IConfigArchive archive = project.getArchive(LIB_OUT_PATH + name + "." + META_EXT);
                archive.compact(manifest, metaFolder);
            }
            catch (Exception e) {
                this.error(result, e.getMessage(), e);
                this.cleanTemp(project);
                return false;
            }
        }
        IConfigFolder dataFolder = project.getFolder("src.config/install/data/");
        if (!dataFolder.exists()) {
            this.warning(result, "Invalid structure (missing " + dataFolder.getFullPath() + " folder)");
        } else if (this.isEmpty(dataFolder)) {
            this.warning(result, "Invalid structure (" + dataFolder.getFullPath() + " folder is empty)");
        } else {
            if (skipBuild) {
                this.info(result, "Archive construction skipped (forced by user)");
                return true;
            }
            try {
                dataFolder.copy(project.getFolder(INSTALL_OUT_PATH));
            }
            catch (CoreException e) {
                this.error(result, e.getMessage(), e);
                this.cleanTemp(project);
                return false;
            }
            try {
                if (new Boolean(properties.getProperty(PROP_FORCE_INSTALL)).booleanValue()) {
                    IConfigResource[] resources = dataFolder.members();
                    IConfigFile mapper = null;
                    int i = 0;
                    while (i < resources.length) {
                        mapper = project.getFile("config.tmp/archive/install/data/system/command/" + resources[i].getName() + "." + CO_XML_EXT);
                        if (!mapper.exists() && !mapper.getName().equals("system.co.xml")) {
                            mapper.create();
                            mapper.append("<?xml version=\"1.0\"  encoding=\"UTF-8\" ?>");
                            mapper.append("<Configurable configclass=\"MergeCommandMapping\">");
                            mapper.append("  <property name=\"name\" value=\"" + resources[i].getName() + "\"/>");
                            mapper.append("  <property name=\"uri\" value=\"/" + resources[i].getName() + "\"/>");
                            mapper.append("  <property name=\"command\" value=\"merge_plugin_force_install\"/>");
                            mapper.append("</Configurable>");
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                this.warning(result, e.getMessage(), e);
                this.cleanSystem(project);
            }
        }
        if (metaFolder.exists() && !this.isEmpty(metaFolder) && dataFolder.exists() && !this.isEmpty(dataFolder)) {
            try {
                if (dataFolder.members().length != 0) {
                    this.comparePlugins(metaFolder, dataFolder, result);
                    this.comparePlugins(dataFolder, metaFolder, result);
                }
            }
            catch (CoreException e) {
                this.warning(result, e.getMessage(), e);
            }
        }
        if (!project.getFolder(ARCHIVE_PATH).exists()) {
            this.error(result, "Cannot create config archive (you should have a valid data or meta folder)");
            this.cleanTemp(project);
            return false;
        }
        IConfigManifest manifest = ConfigPlugin.getManifest();
        try {
            manifest.chooseAndPutValue(IConfigManifest.CA_NAME, properties.getProperty("ca.name"), project.getName(), true);
            manifest.chooseAndPutValue(IConfigManifest.CA_VERSION, properties.getProperty("ca.version"), null, true);
            manifest.chooseAndPutValue(IConfigManifest.CA_DEPENDENCIES, properties.getProperty("ca.dependencies"), null, false);
            manifest.chooseAndPutValue(IConfigManifest.CA_CREATION_TIME, properties.getProperty("ca.creation.time"), info.getTime(), true);
            manifest.chooseAndPutValue(IConfigManifest.CA_CREATION_DATE, properties.getProperty("ca.creation.date"), info.getDate(), true);
            manifest.chooseAndPutValue(IConfigManifest.CA_CREATION_USER, properties.getProperty("ca.creation.user"), info.getUser(), true);
            manifest.chooseAndPutValue(IConfigManifest.CA_CREATION_MACHINE, properties.getProperty("ca.creation.machine"), info.getMachine(), true);
        }
        catch (Exception e) {
            this.error(result, e.getMessage(), e);
            this.cleanTemp(project);
            return false;
        }
        this.cleanExport(project);
        try {
            String name = this.getCAName(properties);
            if (name == null || name.trim().equals("")) {
                name = project.getName();
            }
            IConfigArchive archive = project.getArchive(CONFIG_OUT_PATH + name + "." + ARCHIVE_EXT);
            archive.compact(manifest, project.getFolder(ARCHIVE_PATH));
        }
        catch (Exception e) {
            this.error(result, e.getMessage(), e);
            this.cleanTemp(project);
            this.cleanExport(project);
            return false;
        }
        this.info(result, "Config archive successfully created (time to export " + (System.currentTimeMillis() - date1) + " ms)");
        this.cleanTemp(project);
        this.refresh(project);
        return true;
    }

    private String getCAName(IConfigProperties properties) throws Exception {
        String result = properties.getProperty("ca.name");
        return result;
    }

    private String getCMAName(IConfigProperties properties) throws Exception {
        String result = properties.getProperty("cma.name");
        if (result == null || result.length() == 0) {
            result = properties.getProperty("ca.name");
        }
        return result;
    }

    private boolean importArchive(IConfigProject project, IFinishResult result) {
        long date1 = System.currentTimeMillis();
        this.refresh(project);
        if (!project.getFolder(CONFIG_OUT_PATH).exists()) {
            return true;
        }
        IConfigArchive configArchive = null;
        try {
            configArchive = project.getArchive(this.getArchivePath(project.getFolder(CONFIG_OUT_PATH), ARCHIVE_EXT));
            configArchive.extract(project.getFolder(CONFIG_SRC_DIRNAME));
        }
        catch (Exception e) {
            this.warning(result, e.getMessage());
            this.cleanImport(project);
            return true;
        }
        try {
            project.getFolder(ARCHIVE_METAINF_PATH).delete();
        }
        catch (CoreException e) {
            this.warning(result, e.getMessage(), e);
            this.cleanImport(project);
            return true;
        }
        IConfigProperties properties = null;
        try {
            properties = project.getProperties(PROPERTIES_PATH);
            properties.addComment(project.getName());
            properties.addSeparator();
            properties.addProperty("ca.name", configArchive.getManifest().getValue(IConfigManifest.CA_NAME));
            properties.addProperty("ca.version", configArchive.getManifest().getValue(IConfigManifest.CA_VERSION));
            properties.addProperty("ca.dependencies", configArchive.getManifest().getValue(IConfigManifest.CA_DEPENDENCIES));
            properties.addProperty("ca.creation.time", configArchive.getManifest().getValue(IConfigManifest.CA_CREATION_TIME));
            properties.addProperty("ca.creation.date", configArchive.getManifest().getValue(IConfigManifest.CA_CREATION_DATE));
            properties.addProperty("ca.creation.user", configArchive.getManifest().getValue(IConfigManifest.CA_CREATION_USER));
            properties.addProperty("ca.creation.machine", configArchive.getManifest().getValue(IConfigManifest.CA_CREATION_MACHINE));
        }
        catch (Exception e) {
            this.warning(result, e.getMessage(), e);
            this.cleanImport(project);
            return true;
        }
        if (project.getFolder(LIB_IN_PATH).exists()) {
            IConfigArchive metaArchive = null;
            try {
                metaArchive = project.getArchive(this.getArchivePath(project.getFolder(LIB_IN_PATH), META_EXT));
                metaArchive.extract(project.getFolder("src.config/install/meta/expanded/"));
            }
            catch (ConfigPluginException e) {
                this.warning(result, e.getMessage());
                this.cleanFolder(project, "src.config/install/meta/expanded/");
            }
            catch (Exception e) {
                this.warning(result, e.getMessage(), e);
                this.cleanImport(project);
                return true;
            }
            try {
                project.getFolder(LIB_IN_PATH).delete();
                project.getFolder(META_METAINF_PATH).delete();
            }
            catch (CoreException e) {
                this.warning(result, e.getMessage(), e);
                this.cleanImport(project);
                return true;
            }
            if (metaArchive != null) {
                try {
                    properties.addSeparator();
                    properties.addProperty("cma.name", metaArchive.getManifest().getValue(IConfigManifest.CMA_NAME));
                    properties.addProperty("cma.version", metaArchive.getManifest().getValue(IConfigManifest.CMA_VERSION));
                    properties.addProperty("cma.dependencies", metaArchive.getManifest().getValue(IConfigManifest.CMA_DEPENDENCIES));
                    properties.addProperty("cma.storage", metaArchive.getManifest().getValue(IConfigManifest.CMA_STORAGE));
                    properties.addProperty("cma.creation.time", metaArchive.getManifest().getValue(IConfigManifest.CMA_CREATION_TIME));
                    properties.addProperty("cma.creation.date", metaArchive.getManifest().getValue(IConfigManifest.CMA_CREATION_DATE));
                    properties.addProperty("cma.creation.user", metaArchive.getManifest().getValue(IConfigManifest.CMA_CREATION_USER));
                    properties.addProperty("cma.creation.machine", metaArchive.getManifest().getValue(IConfigManifest.CMA_CREATION_MACHINE));
                }
                catch (Exception e) {
                    this.warning(result, e.getMessage(), e);
                    this.cleanImport(project);
                    return true;
                }
            }
        }
        this.info(result, "Config archive successfully deployed (time to import " + (System.currentTimeMillis() - date1) + " ms)");
        this.refresh(project);
        return true;
    }

    private void cleanTemp(IConfigProject project) {
        this.cleanFolder(project, "config.tmp/");
    }

    private void cleanExport(IConfigProject project) {
        this.cleanFolder(project, CONFIG_OUT_PATH);
    }

    private void cleanImport(IConfigProject project) {
        this.cleanFolder(project, CONFIG_SRC_DIRNAME);
    }

    private void cleanSystem(IConfigProject project) {
        this.cleanFolder(project, "config.tmp/archive/install/data/system");
    }

    private void cleanFolder(IConfigProject project, String path) {
        IConfigFolder folder = project.getFolder(path);
        if (folder.exists()) {
            try {
                folder.delete();
            }
            catch (CoreException e) {
                this.log(e, e.getMessage());
            }
        }
        this.refresh(project);
    }

    private void refresh(IConfigProject project) {
        try {
            project.refresh();
        }
        catch (CoreException e) {
            this.log(e, e.getMessage());
        }
    }

    private boolean isEmpty(IConfigFolder folder) {
        try {
            return folder.members().length == 0;
        }
        catch (CoreException e) {
            this.log(e, e.getMessage());
            return true;
        }
    }

    private void checkPlugins(IConfigFolder folder, IFinishResult result) throws CoreException {
        IConfigResource[] resource = folder.members();
        int i = 0;
        while (i < resource.length) {
            if (resource[i].getType() == 2 && !resource[i].getName().equals(CLASSES_DIRNAME) && !resource[i].getName().equals(BUNDLES_DIRNAME)) {
                this.checkPlugins((IConfigFolder)resource[i], result);
            }
            ++i;
        }
        if (this.isConfigClass(folder)) {
            if (folder.getFile(PLUGIN_HEADER_PROPERTIES).exists()) {
                this.checkBundles(folder, result);
            } else {
                this.warning(result, "Missing file plugin.header.properties in " + folder.getFullPath());
            }
        } else if (folder.getFile(PLUGIN_HEADER_PROPERTIES).exists()) {
            this.checkBundles(folder, result);
        }
    }

    private void checkBundles(IConfigFolder folder, IFinishResult result) {
        if (!(folder = folder.getFolder(BUNDLES_DIRNAME)).exists()) {
            this.warning(result, "Missing folder bundles in " + folder.getParent().getFullPath());
        } else {
            if (!folder.getFolder(CLASSES_DIRNAME).exists()) {
                this.warning(result, "Missing folder classes in " + folder.getFullPath());
            }
            if (!folder.getFile(PLUGIN_PROPERTIES).exists()) {
                this.warning(result, "Missing file plugin.properties in " + folder.getFullPath());
            }
        }
    }

    private boolean isConfigClass(IConfigFolder folder) throws CoreException {
        IConfigResource[] resource = folder.members();
        int i = 0;
        while (i < resource.length) {
            if (resource[i].getName().endsWith(CC_XML_EXT)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void comparePlugins(IConfigFolder folder1, IConfigFolder folder2, IFinishResult result) throws CoreException {
        IConfigFolder folder3 = null;
        IConfigResource[] resource = folder1.members();
        int i = 0;
        while (i < resource.length) {
            if (!(resource[i].getType() != 2 || resource[i].getName().equals(CLASSES_DIRNAME) || resource[i].getName().equals(BUNDLES_DIRNAME) || resource[i].getName().equals(SYSTEM_DIRNAME))) {
                folder3 = folder2.getFolder(resource[i].getFullPath().toString().substring(folder1.getFullPath().toString().length()));
                if (!folder3.exists()) {
                    this.warning(result, "Find folder with no counter part " + resource[i].getFullPath());
                } else {
                    this.comparePlugins((IConfigFolder)resource[i], folder3, result);
                }
            }
            ++i;
        }
    }

    private String getArchivePath(IConfigFolder folder, String ext) throws ConfigPluginException, CoreException {
        IConfigResource[] resource = folder.members();
        int i = 0;
        while (i < resource.length) {
            if (resource[i].getFileExtension().equalsIgnoreCase(ext)) {
                return resource[i].getFullPath().removeFirstSegments(1).toString();
            }
            ++i;
        }
        throw new ConfigPluginException("Cannot find archive file with extention ." + ext);
    }

    private void log(Throwable throwable, String message) {
        SapPortalPluginsLogger.logError((Object)this, (Throwable)throwable, (String)this.checkMessage(message));
    }

    private void log(String message) {
        SapPortalPluginsLogger.logError((Object)this, (String)this.checkMessage(message));
    }

    private void error(IFinishResult result, String message, Throwable throwable) {
        this.log(throwable, this.checkMessage(message));
        result.addError(this.checkMessage(message));
    }

    private void error(IFinishResult result, String message) {
        this.log(this.checkMessage(message));
        result.addError(this.checkMessage(message));
    }

    private void warning(IFinishResult result, String message, Throwable throwable) {
        this.log(throwable, this.checkMessage(message));
        result.addWarning(this.checkMessage(message));
    }

    private void warning(IFinishResult result, String message) {
        this.log(this.checkMessage(message));
        result.addWarning(this.checkMessage(message));
    }

    private void info(IFinishResult result, String message) {
        this.log(this.checkMessage(message));
        result.addInfo(this.checkMessage(message));
    }

    private String checkMessage(String message) {
        if (message == null || message.equals("")) {
            return "Unexpected Error";
        }
        return message;
    }
}

