/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.wizards.vi.pages;

import com.sap.ide.vi.endpoints.EndpointBrower;
import com.sap.ide.vi.services.CheckServices;
import com.sap.ide.vi.text.ViUiTexts;
import com.sap.ide.vi.wizards.generic.adapter.WizardButtonStatusAdapter;
import com.sap.ide.vi.wizards.generic.pages.WizardStatusContributor;
import com.sap.ide.vi.wizards.vi.NewVIWizard;
import com.sap.ide.vi.wizards.vi.pages.AbstractViWizardPage;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class NewVIWizardPage
extends AbstractViWizardPage {
    private static final String ENDPOINT_TYPE = "Endpoint Type";
    protected static String LABEL_VI_DEF = ViUiTexts.getString("NewVIWizardPage.fieldLabel");
    protected String viInitialName = null;
    private NewVIWizard viCreator;
    static /* synthetic */ Class class$com$sap$ide$vi$wizards$vi$pages$NewVIWizardPage;

    public NewVIWizardPage(String pageName) {
        super(pageName);
        this.setTitle(ViUiTexts.getString("NewVIWizardPage.title"));
        this.setDescription(ViUiTexts.getString("NewVIWizardPage.description"));
    }

    protected String getPageDescription() {
        return ViUiTexts.getString("NewVIWizardPage.description");
    }

    private IStatus endpointTypeSelectionChanged() {
        String text = (String)this.getContentByLabelText(ENDPOINT_TYPE);
        StatusInfo status = new StatusInfo();
        if (text == null || text.length() < 1) {
            status.setError(ViUiTexts.getString("AbstractViWizardPage.noEndpoint"));
        }
        return status;
    }

    private JavaProject getJavaProject(ICompilationUnit compilationUnit) {
        IJavaElement parent = compilationUnit.getParent();
        while (!(parent instanceof JavaProject)) {
            parent = parent.getParent();
        }
        return (JavaProject)parent;
    }

    public void createControl(Composite parent) {
        int nColumns = 4;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.initializeDialogUnits((Control)composite);
        this.createProjectSourceFolderControls(composite, nColumns);
        this.createPackageControls(composite, nColumns, true);
        this.createSeparator(composite, nColumns);
        this.createReferencedObjectControls(composite, nColumns, AbstractViWizardPage.LABEL_ENDPOINT, this.getUniqueProjectSourceFieldLabel(), new WizardButtonStatusAdapter(){

            public IStatus fieldChanged() {
                IPackageFragmentRoot root = NewVIWizardPage.this.getRootByContainer();
                if (root == null && this.getText() != null && this.getText().length() > 0) {
                    this.setText("");
                }
                this.setEnabled(root != null);
                return NewVIWizardPage.this.endPointChanged(root);
            }

            public void changeControlPressed(DialogField field) {
                String endpoint = NewVIWizardPage.this.chooseEndPoint();
                if (endpoint != null) {
                    this.setText(endpoint);
                }
            }

            public String fieldLabelText() {
                return AbstractViWizardPage.LABEL_ENDPOINT;
            }
        }, this.endpointName);
        this.createNameControls(composite, nColumns, LABEL_VI_DEF, new WizardStatusContributor(){

            public IStatus fieldChanged() {
                return NewVIWizardPage.this.viNameFieldChanged();
            }

            public String fieldLabelText() {
                return LABEL_VI_DEF;
            }
        }, this.viInitialName);
        this.setControl((Control)composite);
    }

    private String chooseEndPoint() {
        IPackageFragmentRoot root = this.getRootByContainer();
        if (root == null) {
            return null;
        }
        String projectName = root.getResource().getProject().getName();
        return EndpointBrower.browseEndpoints(projectName, root, (IRunnableContext)this.getWizard().getContainer());
    }

    private String browseJavaEndpoints(String projectName) {
        IPackageFragmentRoot packRoot = this.getRootByContainer(projectName);
        if (packRoot == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{};
        try {
            elements = packRoot.getJavaProject().getAllPackageFragmentRoots();
        }
        catch (JavaModelException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$wizards$vi$pages$NewVIWizardPage == null ? (class$com$sap$ide$vi$wizards$vi$pages$NewVIWizardPage = NewVIWizardPage.class$("com.sap.ide.vi.wizards.vi.pages.NewVIWizardPage")) : class$com$sap$ide$vi$wizards$vi$pages$NewVIWizardPage));
        }
        ArrayList<IJavaElement> list = new ArrayList<IJavaElement>();
        int i = 0;
        while (i < elements.length) {
            if (!(elements[i] instanceof JarPackageFragmentRoot)) {
                list.add(elements[i]);
            }
            ++i;
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])list.toArray(new IJavaElement[list.size()]));
        TypeSelectionDialog tdialog = new TypeSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), 5, scope);
        tdialog.setFilter("*");
        tdialog.setTitle(ViUiTexts.getString("NewVIWizardPage.endpoint.class.title"));
        tdialog.setMessage(NewWizardMessages.getString((String)"NewTypeWizardPage.SuperClassDialog.message"));
        if (tdialog.open() == 0) {
            return ((IType)tdialog.getFirstResult()).getFullyQualifiedName();
        }
        return null;
    }

    public String getVIName() {
        return (String)this.getContentByLabelText(LABEL_VI_DEF);
    }

    protected IStatus viNameFieldChanged() {
        String viName = (String)this.getContentByLabelText(LABEL_VI_DEF);
        StatusInfo status = new StatusInfo();
        if (viName == null || viName.length() < 1) {
            status.setError(ViUiTexts.getString("NewVIWizardPage.noEndpoint"));
        } else if (!CheckServices.isValidIdentifier(viName)) {
            status.setError(ViUiTexts.getString("NewVIWizardPage.invalid", viName));
        } else {
            String project = this.getProjectFromProjectSourceFolderField();
            if (project != null && project.length() > 0 && ResourcesPlugin.getWorkspace().getRoot().getProject(project).isAccessible() && NewVIWizard.exists(project, this.getPackageName(), viName) != null) {
                status.setError(ViUiTexts.getString("NewVIWizardPage.exists"));
            }
        }
        return status;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

