/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.wizards.vi.pages;

import com.sap.ide.vi.check.ViBasics;
import com.sap.ide.vi.endpoints.EndpointAnalyser;
import com.sap.ide.vi.endpoints.EndpointReference;
import com.sap.ide.vi.outline.VepOutlineTreeLabelProvider;
import com.sap.ide.vi.services.WsGUIDGenerator;
import com.sap.ide.vi.text.ViUiTexts;
import com.sap.ide.vi.types.MethodAttributes;
import com.sap.ide.vi.wizards.generic.pages.IExtendedCheckStateListener;
import com.sap.ide.vi.wizards.generic.pages.WizardCheckTableObjectProvider;
import com.sap.ide.vi.wizards.generic.pages.WizardCheckTableSelectionListener;
import com.sap.ide.vi.wizards.generic.pages.WizardStatusContributor;
import com.sap.ide.vi.wizards.vi.AbstractViWizard;
import com.sap.ide.vi.wizards.vi.pages.AbstractViWizardPage;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MethodSelectionPage
extends AbstractViWizardPage {
    private String typeName;
    private String projectName;
    private String type;
    private static String VI_METHODS_LABEL = ViUiTexts.getString("MethodSelectionPage.fieldLabel");
    private WizardCheckTableObjectProvider methodProvider;

    public MethodSelectionPage() {
        super(ViUiTexts.getString("MethodSelectionPage.pageName"));
        this.setDescription(ViUiTexts.getString("MethodSelectionPage.description"));
        this.setTitle(ViUiTexts.getString("MethodSelectionPage.title"));
    }

    protected String getPageDescription() {
        return ViUiTexts.getString("MethodSelectionPage.description");
    }

    public void setEndpoint(EndpointReference ref) {
        if (!(this.projectName != null && this.projectName.equals(ref.getProjectName()) && this.typeName != null && this.typeName.equals(ref.getName()) && this.type != null && this.type.equals(ref.getType()))) {
            this.projectName = ref.getProjectName();
            this.typeName = ref.getName();
            this.type = ref.getType();
            if (this.projectName != null && this.typeName != null && this.typeName.length() > 0) {
                IType type = EndpointAnalyser.getITypeByEndpoint((EndpointReference)ref);
                Object[] mas = ViBasics.buildUpMethodAttributeList((String)WsGUIDGenerator.generateGuid(), (String)this.projectName, (IType)type);
                ((AbstractViWizard)this.getWizard()).setMethodAttributes((MethodAttributes[])mas);
                ((AbstractViWizard)this.getWizard()).setCheckRelevancy();
                ((AbstractViWizard)this.getWizard()).reCheckVi((MethodAttributes[])mas);
                this.methodProvider = new WizardCheckTableObjectProvider(mas, false){

                    public Object toString(Object obj) {
                        return ((MethodAttributes)obj).getNameWithSignatureAndReturnType();
                    }

                    public Object toElement(String toStringOfElement) {
                        Object[] elements = this.getElements();
                        int i = 0;
                        while (i < elements.length) {
                            if (((MethodAttributes)elements[i]).getNameWithSignatureAndReturnType().equals(toStringOfElement)) {
                                return elements[i];
                            }
                            ++i;
                        }
                        return null;
                    }
                };
                this.changeContentProviderForCheckTable(VI_METHODS_LABEL, this.methodProvider, true);
            }
        }
    }

    public void createControl(Composite parent) {
        int nColumns = 4;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createCheckboxTableControls(composite, nColumns, VI_METHODS_LABEL, (ILabelProvider)new VepOutlineTreeLabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                return (String)element;
            }
        }, new WizardCheckTableObjectProvider(null, false){

            public Object toString(Object obj) {
                return null;
            }

            public Object toElement(String toStringOfElement) {
                return null;
            }
        }, new WizardStatusContributor(){

            public IStatus fieldChanged() {
                MethodAttributes[] methods = ((AbstractViWizard)MethodSelectionPage.this.getWizard()).getMethodAttributes();
                if (methods.length < 1) {
                    return new StatusInfo(4, "No methods available for VI");
                }
                int i = 0;
                while (i < methods.length) {
                    if (methods[i].isToBeContained()) {
                        return new StatusInfo();
                    }
                    ++i;
                }
                return new StatusInfo(4, "No method selected for VI");
            }

            public String fieldLabelText() {
                return VI_METHODS_LABEL;
            }
        }, new IExtendedCheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                MethodSelectionPage.this.checkboxStateChanged(event, MethodSelectionPage.this.methodProvider.getViewer());
            }

            public void allElementsCheckedInternally() {
                MethodSelectionPage.this.allCheckBoxesChangedState(true);
            }

            public void allElementsUnCheckedInternally() {
                MethodSelectionPage.this.allCheckBoxesChangedState(false);
            }
        }, new WizardCheckTableSelectionListener(){

            public void selectionChanged(Object selectedObject) {
                if (selectedObject != null) {
                    if (((MethodAttributes)selectedObject).isForbidden()) {
                        MethodSelectionPage.super.setBottomStatusLineText(((MethodAttributes)selectedObject).getForbiddenReason().getMessage());
                    } else {
                        MethodSelectionPage.super.setBottomStatusLineText(ViUiTexts.getString("MethodSelectionPage.methodAvailableMessage"));
                    }
                }
            }
        }, ViUiTexts.getString("MethodSelectionPage.methodInfoLabel"), false, 160);
        this.setControl((Control)composite);
    }

    public MethodAttributes[] getResultMethods() {
        return (MethodAttributes[])this.methodProvider.getResults();
    }

    private void checkboxStateChanged(CheckStateChangedEvent event, CheckboxTableViewer ctv) {
        ((AbstractViWizard)this.getWizard()).clearPages();
        MethodAttributes[] mas = ((AbstractViWizard)this.getWizard()).getMethodAttributes();
        if (mas != null) {
            int i = 0;
            while (i < mas.length) {
                if (mas[i].getNameWithSignatureAndReturnType().equals(event.getElement())) {
                    if (mas[i].isForbidden()) {
                        ctv.setChecked(event.getElement(), false);
                    } else {
                        mas[i].setToBeContained(event.getChecked());
                        ((AbstractViWizard)this.getWizard()).setCheckRelevancy();
                        ((AbstractViWizard)this.getWizard()).reCheckVi(mas);
                        this.getContainer().updateButtons();
                    }
                }
                ++i;
            }
        }
    }

    private void allCheckBoxesChangedState(boolean checked) {
        MethodAttributes[] mas = ((AbstractViWizard)this.getWizard()).getMethodAttributes();
        if (mas != null) {
            int i = 0;
            while (i < mas.length) {
                if (!mas[i].isForbidden()) {
                    mas[i].setToBeContained(checked);
                    ((AbstractViWizard)this.getWizard()).setCheckRelevancy();
                    ((AbstractViWizard)this.getWizard()).reCheckVi(mas);
                    this.getContainer().updateButtons();
                }
                ++i;
            }
        }
    }
}

