/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.wizards.vi.pages;

import com.sap.ide.metamodel.vi.InterfaceType;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.vi.check.ViBasics;
import com.sap.ide.vi.endpoints.EndpointAnalyser;
import com.sap.ide.vi.endpoints.EndpointReference;
import com.sap.ide.vi.endpoints.InadmissableTypeException;
import com.sap.ide.vi.services.WsGUIDGenerator;
import com.sap.ide.vi.text.ViUiTexts;
import com.sap.ide.vi.types.MethodAttributes;
import com.sap.ide.vi.wizards.generic.pages.BasicProjectSelectionPage;
import com.sap.ide.vi.wizards.vi.AbstractViWizard;
import com.sap.ide.webservices.tsmodel.vi.provider.VIDataSourceManager;
import com.sap.ide.ws.core.services.content.provider.EndpointProjectProvider;
import com.sap.ide.ws.core.services.content.provider.ProjectProvider;
import com.sap.ide.ws.core.services.filter.WebServiceFilterFactory;
import com.sap.ide.ws.core.services.selena.SelenaJavaAdapter;
import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ejb.IEjbModule;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.model.ejb.ISessionBean;
import com.tssap.selena.model.elements.Element;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class AbstractViWizardPage
extends BasicProjectSelectionPage {
    protected static String LABEL_ENDPOINT = ViUiTexts.getString("AbstractViWizardPage.endpointFieldLabel");
    protected String endpointName;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IPackageFragmentRoot;

    public AbstractViWizardPage(String pageName) {
        super(pageName);
    }

    public ProjectProvider getMyProjectListContentProvider() {
        return new EndpointProjectProvider();
    }

    public Class[] getMyAcceptedProjectSelectionClasses() {
        return new Class[]{class$org$eclipse$jdt$core$IPackageFragmentRoot == null ? (class$org$eclipse$jdt$core$IPackageFragmentRoot = AbstractViWizardPage.class$("org.eclipse.jdt.core.IPackageFragmentRoot")) : class$org$eclipse$jdt$core$IPackageFragmentRoot};
    }

    protected IStatus endPointChanged(IPackageFragmentRoot root) {
        StatusInfo status = new StatusInfo();
        String endPointName = this.getEndPointName();
        if (endPointName != null && endPointName.length() == 0) {
            status.setError(ViUiTexts.getString("AbstractViWizardPage.noEndpoint"));
        }
        if (root != null) {
            VirtualInterface tempVi = ((AbstractViWizard)this.getWizard()).getVirtualInterfaceCreatedTilNow();
            IEjbModule proj = J2eeProjectManager.getEjbModule((String)root.getResource().getProject().getName());
            IEnterpriseJavaBean bean = null;
            if (proj != null) {
                bean = proj.getEnterpriseBean(endPointName);
                if (bean == null) {
                    status.setError(ViUiTexts.getString("AbstractViWizardPage.endpointNotExists"));
                } else if (!(bean instanceof ISessionBean)) {
                    status.setError(ViUiTexts.getString("AbstractViWizardPage.endpointNoSessionBean"));
                } else {
                    ((AbstractViWizard)this.getWizard()).updateEndPointReference(EndpointReference.EJB_TYPE);
                    if (tempVi == null || !endPointName.equals(EndpointAnalyser.getEndPointName((com.sap.ide.metamodel.vi.EndpointReference)tempVi.getEndpointReference()))) {
                        try {
                            this.createVi(root.getResource().getProject().getName(), tempVi, InterfaceType.EJB);
                        }
                        catch (InadmissableTypeException e) {
                            status.setError(e.getMessage());
                            return status;
                        }
                    }
                }
            } else {
                InterfaceType ifType;
                String epType;
                if (WebServiceFilterFactory.isPortalProject((IProject)root.getResource().getProject())) {
                    epType = EndpointReference.PAR_TYPE;
                    ifType = InterfaceType.PAR;
                } else {
                    epType = EndpointReference.CLASS_TYPE;
                    ifType = InterfaceType.JAVACLASS;
                }
                ((AbstractViWizard)this.getWizard()).updateEndPointReference(epType);
                if (EndpointAnalyser.getITypeByEndpoint((EndpointReference)((AbstractViWizard)this.getWizard()).getEndpointReference()) == null) {
                    status.setError(ViUiTexts.getString("AbstractViWizardPage.endpointNotExists"));
                } else if (tempVi == null || !endPointName.equals(EndpointAnalyser.getEndPointName((com.sap.ide.metamodel.vi.EndpointReference)tempVi.getEndpointReference()))) {
                    try {
                        this.createVi(root.getResource().getProject().getName(), tempVi, ifType);
                    }
                    catch (InadmissableTypeException e) {
                        status.setError(e.getMessage());
                        return status;
                    }
                }
                try {
                    if (this.endpointName != null && endPointName.length() > 0 && ifType == InterfaceType.JAVACLASS && EndpointAnalyser.getITypeByEndpoint((EndpointReference)new EndpointReference(root.getJavaProject().getProject().getName(), this.endpointName, EndpointReference.CLASS_TYPE)).isInterface()) {
                        status.setError("The endpoint you have entered is an interface.");
                        return status;
                    }
                }
                catch (JavaModelException e) {
                    status.setError("It was not possible to evaluate if endpoint is an interface or class.");
                    return status;
                }
            }
        }
        ((AbstractViWizard)this.getWizard()).setCheckRelevancy();
        return status;
    }

    private void createVi(String projectName, VirtualInterface tempVi, InterfaceType ifType) throws InadmissableTypeException {
        VIDataSourceManager.deleteVi((String)projectName, (VirtualInterface)tempVi, (boolean)false);
        ((AbstractViWizard)this.getWizard()).setVirtualInterfaceCreatedTilNow(null);
        ((AbstractViWizard)this.getWizard()).clearPages();
        EndpointReference endPointRef = ((AbstractViWizard)this.getWizard()).getEndpointReference();
        MethodAttributes[] mas = ViBasics.buildUpMethodAttributeList((String)WsGUIDGenerator.generateGuid(), (String)endPointRef.getProjectName(), (IType)EndpointAnalyser.getITypeByEndpoint((EndpointReference)endPointRef));
        ((AbstractViWizard)this.getWizard()).setMethodAttributes(mas);
        tempVi = ((AbstractViWizard)this.getWizard()).createNewVi(this.getPackageName(), WsGUIDGenerator.generateGuid(), this.getContainerName(), (IProgressMonitor)new NullProgressMonitor(), ifType, false);
        ((AbstractViWizard)this.getWizard()).setVirtualInterfaceCreatedTilNow(tempVi);
    }

    public String getEndPointName() {
        return (String)this.getContentByLabelText(LABEL_ENDPOINT);
    }

    public String getEndpointType() {
        if (WebServiceFilterFactory.isEjbModuleOrEjbModuleDcProject((IProject)this.getRootByContainer().getResource().getProject())) {
            return EndpointReference.EJB_TYPE;
        }
        if (WebServiceFilterFactory.isPortalProject((IProject)this.getRootByContainer().getResource().getProject())) {
            return EndpointReference.PAR_TYPE;
        }
        return EndpointReference.CLASS_TYPE;
    }

    public void init(Element selenaSelection) {
        super.init(selenaSelection);
        if (SelenaJavaAdapter.getCompilationUnit((Element)selenaSelection) != null) {
            ICompilationUnit compilationUnit = SelenaJavaAdapter.getCompilationUnit((Element)selenaSelection);
            this.endpointName = compilationUnit.getType(compilationUnit.getElementName().substring(0, compilationUnit.getElementName().indexOf(46))).getFullyQualifiedName();
        } else if (J2eeElementManager.isEnterpriseJavaBean((Element)selenaSelection)) {
            IEnterpriseJavaBean bean = J2eeElementManager.getEnterpriseJavaBean((Element)selenaSelection);
            this.endpointName = bean.getBeanClass().getFullyQualifiedName();
        }
        this.setPackage();
    }

    public void init(IStructuredSelection selection) {
        super.init(selection);
        if (selection.getFirstElement() instanceof ICompilationUnit) {
            ICompilationUnit compilationUnit = (ICompilationUnit)selection.getFirstElement();
            this.endpointName = compilationUnit.getType(compilationUnit.getElementName().substring(0, compilationUnit.getElementName().indexOf(46))).getFullyQualifiedName();
        }
        this.setPackage();
    }

    private void setPackage() {
        if (this.endpointName != null && this.endpointName.indexOf(".") > -1) {
            this.preselectedPackageName = this.endpointName.substring(0, this.endpointName.lastIndexOf("."));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

