/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.wizards.vi;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.SaveException;
import com.sap.ide.metamodel.vi.Elementary;
import com.sap.ide.metamodel.vi.InterfaceType;
import com.sap.ide.metamodel.vi.Structure;
import com.sap.ide.metamodel.vi.Table;
import com.sap.ide.metamodel.vi.Type;
import com.sap.ide.metamodel.vi.VIRoot;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.metamodel.vi.plugin.VIRootManager;
import com.sap.ide.vi.builder.modules.ViEndpointCheckModule;
import com.sap.ide.vi.check.CheckTypeException;
import com.sap.ide.vi.check.ViBasics;
import com.sap.ide.vi.check.ViCheck;
import com.sap.ide.vi.endpoints.EndPointIsAbstractOrInterfaceException;
import com.sap.ide.vi.endpoints.EndpointAnalyser;
import com.sap.ide.vi.endpoints.EndpointReference;
import com.sap.ide.vi.endpoints.InadmissableTypeException;
import com.sap.ide.vi.services.WsGUIDGenerator;
import com.sap.ide.vi.types.MethodAttributes;
import com.sap.ide.vi.types.TypeAnalyser;
import com.sap.ide.vi.wizards.generic.GenericProjectWizard;
import com.sap.ide.vi.wizards.rtClass.pages.RuntimeClassWizardPage;
import com.sap.ide.vi.wizards.vi.pages.AbstractViWizardPage;
import com.sap.ide.vi.wizards.vi.pages.MethodSelectionPage;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;

public abstract class AbstractViWizard
extends GenericProjectWizard {
    protected Vector rtPages = null;
    protected EndpointReference endPointRef;
    private MethodAttributes[] mas = null;
    private VirtualInterface tempVi = null;
    private String runtimeClassIsMissingForType = null;
    protected MethodSelectionPage secondPage;
    private Hashtable rtcClassesForBaseClasses = new Hashtable();
    private boolean checkRelevancy = false;
    static /* synthetic */ Class class$com$sap$ide$vi$wizards$vi$pages$AbstractViWizardPage;
    static /* synthetic */ Class class$com$sap$ide$vi$wizards$vi$AbstractViWizard;

    public AbstractViWizard() {
        TypeAnalyser.clearAnalysedTypes();
    }

    public AbstractViWizard(EndpointReference eP) {
        this.endPointRef = eP;
        TypeAnalyser.clearAnalysedTypes();
    }

    public String getRuntimeClassIsMissingFor() {
        return this.runtimeClassIsMissingForType;
    }

    public VirtualInterface getVirtualInterfaceCreatedTilNow() {
        return this.tempVi;
    }

    private void deleteVirtualInterfaceCreatedTilNow() {
        if (this.tempVi != null && !this.tempVi.isDeleted()) {
            try {
                this.tempVi.delete();
                this.tempVi = null;
            }
            catch (DeleteException e) {
                WebServiceCorePlugin.logError((Throwable)e, ((Object)((Object)this)).getClass());
            }
        }
    }

    public void setVirtualInterfaceCreatedTilNow(VirtualInterface vi) {
        this.tempVi = vi;
    }

    public EndpointReference getEndpointReference() {
        return this.endPointRef;
    }

    public void setCheckRelevancy() {
        this.checkRelevancy = true;
    }

    public void setMethodAttributes(MethodAttributes[] meat) {
        this.mas = meat;
    }

    public MethodAttributes[] getMethodAttributes() {
        return this.mas;
    }

    public void reCheckVi(MethodAttributes[] mas) {
        this.reCheckVi(mas, null);
    }

    public void reCheckVi(MethodAttributes[] mas, Type[] existingTypes) {
        if (!this.checkRelevancy) {
            return;
        }
        this.checkRelevancy = false;
        if (mas == null) {
            return;
        }
        this.setMethodAttributes(mas);
        try {
            if (this.tempVi != null && !this.tempVi.isDeleted()) {
                try {
                    this.tempVi.delete();
                }
                catch (DeleteException e1) {
                    WebServiceCorePlugin.logError((Throwable)e1, ((Object)((Object)this)).getClass());
                }
            }
            this.tempVi = this.createNewVi(this.projectPage.getPackageName(), WsGUIDGenerator.generateGuid(), this.getAbstractViWizardPage().getContainerName(), (IProgressMonitor)new NullProgressMonitor(), InterfaceType.EJB, false);
        }
        catch (InadmissableTypeException e) {
            WebServiceCorePlugin.logErrorSimulated((Throwable)e);
        }
        if (existingTypes != null) {
            int i = 0;
            while (i < existingTypes.length) {
                try {
                    if (!this.tempVi.hasType(existingTypes[i].getName())) {
                        Table newType = null;
                        if (existingTypes[i] instanceof org.eclipse.swt.widgets.Table) {
                            newType = this.tempVi.createTypeAsTable(existingTypes[i].getName());
                        } else if (existingTypes[i] instanceof Structure) {
                            newType = this.tempVi.createTypeAsStructure(existingTypes[i].getName());
                        } else if (existingTypes[i] instanceof Elementary) {
                            newType = this.tempVi.createTypeAsElementary(existingTypes[i].getName());
                        }
                        if (newType != null) {
                            newType.createOriginalAsComplexTypeReference(existingTypes[i].getOriginal().getName());
                            newType.setParentTypeName(existingTypes[i].getParentTypeName());
                        }
                    }
                }
                catch (CreateException e1) {
                    WebServiceCorePlugin.logError((Throwable)e1, ((Object)((Object)this)).getClass());
                }
                ++i;
            }
        }
        this.checkTemporaryVi();
    }

    public boolean checkTemporaryVi() {
        this.runtimeClassIsMissingForType = null;
        if (this.tempVi == null) {
            return true;
        }
        try {
            String pn = this.projectPage.getProjectFromProjectSourceFolderField();
            if (pn == null) {
                pn = this.getProjectName();
            }
            new ViCheck().checkViSingularly(pn, this.tempVi, null);
            return true;
        }
        catch (CheckTypeException ex) {
            WebServiceCorePlugin.logError((Throwable)ex, (Class)(class$com$sap$ide$vi$wizards$vi$pages$AbstractViWizardPage == null ? (class$com$sap$ide$vi$wizards$vi$pages$AbstractViWizardPage = AbstractViWizard.class$("com.sap.ide.vi.wizards.vi.pages.AbstractViWizardPage")) : class$com$sap$ide$vi$wizards$vi$pages$AbstractViWizardPage));
        }
        catch (EndPointIsAbstractOrInterfaceException ex) {
            this.runtimeClassIsMissingForType = ex.getBaseClassName();
        }
        return false;
    }

    public abstract AbstractViWizardPage getAbstractViWizardPage();

    public boolean canFinish() {
        if (!super.canFinish()) {
            return false;
        }
        if (this.rtPages != null) {
            int i = 0;
            while (i < this.rtPages.size()) {
                if (!((RuntimeClassWizardPage)((Object)this.rtPages.elementAt(i))).isPageComplete()) {
                    return false;
                }
                ++i;
            }
        }
        return this.runtimeClassIsMissingForType == null;
    }

    public void clearPages() {
        this.rtPages = null;
    }

    public boolean performCancel() {
        this.deleteVirtualInterfaceCreatedTilNow();
        return true;
    }

    public boolean performFinish() {
        this.deleteVirtualInterfaceCreatedTilNow();
        super.performFinish();
        return true;
    }

    public VirtualInterface createNewVi(String packageName, String viName, String containerName, IProgressMonitor monitor, InterfaceType endPointType, boolean commitChanges) throws InadmissableTypeException {
        if (this.endPointRef.getProjectName() == null) {
            return null;
        }
        this.taskCounter = 1;
        VirtualInterface tempVi = null;
        try {
            VIRoot viRoot = VIRootManager.getVIRoot((String)this.endPointRef.getProjectName());
            tempVi = viRoot.createVirtualInterface(packageName, viName, GenericProjectWizard.getSourcePathIdentifier(containerName, this.endPointRef.getProjectName()));
            tempVi.setInterfaceType(endPointType);
            if (tempVi == null) {
                return null;
            }
            EndpointAnalyser.setEndPointReferenceInMetadata((VirtualInterface)tempVi, (EndpointReference)this.endPointRef);
            tempVi.setGuid(WsGUIDGenerator.generateGuid());
        }
        catch (CreateException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$wizards$vi$AbstractViWizard == null ? (class$com$sap$ide$vi$wizards$vi$AbstractViWizard = AbstractViWizard.class$("com.sap.ide.vi.wizards.vi.AbstractViWizard")) : class$com$sap$ide$vi$wizards$vi$AbstractViWizard));
        }
        this.nextProgressStep(monitor);
        ViBasics.fillMetaDataByIType((VirtualInterface)tempVi, (String)this.endPointRef.getProjectName(), (IType)EndpointAnalyser.getITypeByEndpoint((EndpointReference)this.endPointRef), (MethodAttributes[])this.mas);
        if (this.rtPages != null) {
            int i = 0;
            while (i < this.rtPages.size()) {
                String baseClassName = ((RuntimeClassWizardPage)((Object)this.rtPages.elementAt(i))).getBaseClassName();
                String rtcName = ((RuntimeClassWizardPage)((Object)this.rtPages.elementAt(i))).getRuntimeClass();
                if (rtcName != null) {
                    ViBasics.createTypeReferenceForDO((VirtualInterface)tempVi, (String)this.endPointRef.getProjectName(), (String)rtcName, (String)rtcName, (DevelopmentObject)tempVi.getType(baseClassName));
                }
                ++i;
            }
        }
        this.nextProgressStep(monitor);
        if (commitChanges) {
            try {
                tempVi.commitChanges();
            }
            catch (SaveException e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$wizards$vi$AbstractViWizard == null ? (class$com$sap$ide$vi$wizards$vi$AbstractViWizard = AbstractViWizard.class$("com.sap.ide.vi.wizards.vi.AbstractViWizard")) : class$com$sap$ide$vi$wizards$vi$AbstractViWizard));
            }
            catch (DeleteException e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$wizards$vi$AbstractViWizard == null ? (class$com$sap$ide$vi$wizards$vi$AbstractViWizard = AbstractViWizard.class$("com.sap.ide.vi.wizards.vi.AbstractViWizard")) : class$com$sap$ide$vi$wizards$vi$AbstractViWizard));
            }
            ViEndpointCheckModule.setViToBeChecked(this.endPointRef.getProjectName(), tempVi);
        }
        return tempVi;
    }

    public void addRtcClass(String base, String rtc) {
        this.rtcClassesForBaseClasses.put(base, rtc);
    }

    public void updateEndPointReference(String epType) {
        this.endPointRef = new EndpointReference(this.getAbstractViWizardPage().getProjectFromProjectSourceFolderField(), this.getAbstractViWizardPage().getEndPointName(), epType);
    }

    protected IWizardPage possiblyAddNewRtPage() {
        RuntimeClassWizardPage rtPage = null;
        String runtimeClassIsMissingFor = this.getRuntimeClassIsMissingFor();
        if (runtimeClassIsMissingFor != null) {
            String initialValue = "";
            if (this.rtcClassesForBaseClasses.get(runtimeClassIsMissingFor) != null) {
                initialValue = (String)this.rtcClassesForBaseClasses.get(runtimeClassIsMissingFor);
            }
            rtPage = new RuntimeClassWizardPage(this.tempVi, runtimeClassIsMissingFor, initialValue);
            rtPage.setWizard((IWizard)this);
            if (this.rtPages == null) {
                this.rtPages = new Vector(1);
            }
            this.rtPages.add(rtPage);
        }
        return rtPage;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

