/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.wizards.rtClass.pages;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.vi.Type;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.vi.check.CheckTypeException;
import com.sap.ide.vi.check.ViBasics;
import com.sap.ide.vi.check.ViCheck;
import com.sap.ide.vi.endpoints.InadmissableTypeException;
import com.sap.ide.vi.text.ViUiTexts;
import com.sap.ide.vi.wizards.generic.adapter.WizardButtonStatusAdapter;
import com.sap.ide.vi.wizards.generic.pages.BasicProjectSelectionPage;
import com.sap.ide.vi.wizards.rtClass.NewRuntimeClassWizard;
import com.sap.ide.vi.wizards.vi.AbstractViWizard;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RuntimeClassWizardPage
extends BasicProjectSelectionPage {
    private static String LABEL_RT_CLASS = ViUiTexts.getString("RuntimeClassWizardPage.fieldLabel");
    private String projectName;
    private String baseClassName;
    private String lastCreatedTypeName = null;
    private VirtualInterface virtualInterface;
    private boolean isPageComplete = false;
    private String init;
    static /* synthetic */ Class class$com$sap$ide$vi$wizards$rtClass$pages$RuntimeClassWizardPage;

    public RuntimeClassWizardPage(VirtualInterface vi, String baseClass, String initialValue) {
        super(ViUiTexts.getString("RuntimeClassWizardPage.pageName"));
        this.setTitle(ViUiTexts.getString("RuntimeClassWizardPage.title"));
        this.setDescription(ViUiTexts.getString("RuntimeClassWizardPage.description", baseClass));
        this.projectName = vi.getMetamodel().getName();
        this.virtualInterface = vi;
        this.baseClassName = baseClass;
        this.init = initialValue;
        this.setPageComplete(false);
    }

    protected String getPageDescription() {
        return ViUiTexts.getString("RuntimeClassWizardPage.description", this.baseClassName);
    }

    public String getBaseClassName() {
        return this.baseClassName;
    }

    public void createControl(Composite parent) {
        int nColumns = 4;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.initializeDialogUnits((Control)composite);
        this.createReferencedObjectControls(composite, nColumns, LABEL_RT_CLASS, new WizardButtonStatusAdapter(){

            public IStatus fieldChanged() {
                return RuntimeClassWizardPage.this.rtClassNameFieldChanged();
            }

            public void changeControlPressed(DialogField field) {
                String type = RuntimeClassWizardPage.this.chooseType();
                if (type != null) {
                    this.setText(type);
                }
            }

            public String fieldLabelText() {
                return LABEL_RT_CLASS;
            }
        }, this.init);
        this.setControl((Control)composite);
    }

    private String chooseType() {
        IPackageFragmentRoot root = this.getRootByContainer(this.projectName);
        if (root == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{root.getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        TypeSelectionDialog dialog = new TypeSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), 5, scope);
        dialog.setFilter("*");
        dialog.setTitle(ViUiTexts.getString("RuntimeClassWizardPage.title"));
        dialog.setMessage(NewWizardMessages.getString((String)"NewTypeWizardPage.SuperClassDialog.message"));
        if (dialog.open() == 0) {
            return ((IType)dialog.getFirstResult()).getFullyQualifiedName();
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private IStatus rtClassNameFieldChanged() {
        StatusInfo status;
        String rtcName;
        block20: {
            this.isPageComplete = false;
            rtcName = this.getRuntimeClass();
            status = new StatusInfo();
            if (rtcName == null || rtcName.length() < 1) {
                status.setError(ViUiTexts.getString("RuntimeClassWizardPage.description", this.baseClassName));
                return status;
            }
            try {
                new ViCheck().checkRunTimeClass(rtcName, this.baseClassName, this.projectName, null);
                ViBasics.createTypeIntoTypeHierarchy((VirtualInterface)this.virtualInterface, (String)this.projectName, (String)rtcName, (boolean)false, (String)rtcName, null);
                Object var6_3 = null;
                try {
                    Type type = this.virtualInterface.getType(rtcName);
                    if (type != null) {
                        type.delete();
                    }
                    break block20;
                }
                catch (DeleteException e1) {
                    WebServiceCorePlugin.logError((Throwable)e1, ((Object)((Object)this)).getClass());
                }
                break block20;
                {
                    catch (InadmissableTypeException e) {
                        status.setError(e.getMessage());
                        StatusInfo statusInfo = status;
                        Object var6_4 = null;
                        try {
                            Type type = this.virtualInterface.getType(rtcName);
                            if (type != null) {
                                type.delete();
                            }
                        }
                        catch (DeleteException e1) {
                            WebServiceCorePlugin.logError((Throwable)e1, ((Object)((Object)this)).getClass());
                        }
                        return statusInfo;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    try {
                        Type type = this.virtualInterface.getType(rtcName);
                        if (type != null) {
                            type.delete();
                        }
                    }
                    catch (DeleteException e1) {
                        WebServiceCorePlugin.logError((Throwable)e1, ((Object)((Object)this)).getClass());
                    }
                    throw throwable;
                }
            }
            catch (CheckTypeException ex) {
                status.setError(ex.getMessage());
                return status;
            }
        }
        if (this.getWizard() instanceof NewRuntimeClassWizard && this.virtualInterface.hasType(rtcName)) {
            status.setWarning(ViUiTexts.getString("RuntimeClassWizardPage.runtimeClass.Exists", rtcName));
            return status;
        }
        this.isPageComplete = true;
        if (this.getWizard() instanceof AbstractViWizard) {
            ((AbstractViWizard)this.getWizard()).addRtcClass(this.baseClassName, rtcName);
        }
        if (this.getWizard() instanceof AbstractViWizard) {
            if (this.lastCreatedTypeName != null) {
                ViBasics.deleteTypeFromTypeHierarchy((VirtualInterface)this.virtualInterface, (DevelopmentObject)this.virtualInterface.getType(this.baseClassName), (String)this.lastCreatedTypeName, null);
            }
            try {
                ViBasics.createTypeReferenceForDO((VirtualInterface)this.virtualInterface, (String)this.projectName, (String)rtcName, (String)rtcName, (DevelopmentObject)this.virtualInterface.getType(this.baseClassName));
                this.lastCreatedTypeName = rtcName;
            }
            catch (InadmissableTypeException e) {
                this.lastCreatedTypeName = null;
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$wizards$rtClass$pages$RuntimeClassWizardPage == null ? (class$com$sap$ide$vi$wizards$rtClass$pages$RuntimeClassWizardPage = RuntimeClassWizardPage.class$("com.sap.ide.vi.wizards.rtClass.pages.RuntimeClassWizardPage")) : class$com$sap$ide$vi$wizards$rtClass$pages$RuntimeClassWizardPage));
            }
            ((AbstractViWizard)this.getWizard()).checkTemporaryVi();
            this.getContainer().updateButtons();
        }
        return status;
    }

    public String getRuntimeClass() {
        return (String)this.getContentByLabelText(LABEL_RT_CLASS);
    }

    public boolean isPageComplete() {
        return this.isPageComplete;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

