/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.wizards.generic.pages;

import com.sap.ide.vi.types.MethodAttributes;
import java.util.Vector;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public abstract class WizardCheckTableObjectProvider
implements IStructuredContentProvider {
    private CheckboxTableViewer ctv;
    protected Object[] elements;
    private boolean onlyForAdding;

    public WizardCheckTableObjectProvider(Object[] rawElements, boolean onlyForAdding) {
        this.elements = rawElements;
        this.onlyForAdding = onlyForAdding;
    }

    public void setViewer(CheckboxTableViewer viewer) {
        this.ctv = viewer;
    }

    public CheckboxTableViewer getViewer() {
        return this.ctv;
    }

    public Object[] getResults() {
        return this.elements;
    }

    public abstract Object toElement(String var1);

    public abstract Object toString(Object var1);

    public Object[] getElements(Object inputElement) {
        Vector<Object> elems = new Vector<Object>();
        Vector grayVector = new Vector();
        if (this.elements != null) {
            int i = 0;
            while (i < this.elements.length) {
                MethodAttributes ma = (MethodAttributes)this.elements[i];
                if (!this.onlyForAdding || !ma.isToBeContained() && !ma.isForbidden()) {
                    Object el = this.toString(this.elements[i]);
                    elems.add(el);
                    if (this.ctv != null) {
                        this.ctv.setGrayed(el, ma.isForbidden());
                        if (this.onlyForAdding) {
                            this.ctv.setChecked(el, false);
                        } else {
                            this.ctv.setChecked(el, !ma.isForbidden());
                        }
                    }
                }
                ++i;
            }
        }
        return elems.toArray(new Object[elems.size()]);
    }

    public void checkAllElements() {
        if (this.elements != null) {
            int i = 0;
            while (i < this.elements.length) {
                MethodAttributes ma = (MethodAttributes)this.elements[i];
                if (!ma.isForbidden()) {
                    this.ctv.setChecked(this.toString(this.elements[i]), true);
                }
                ++i;
            }
        }
    }

    public void uncheckAllElements() {
        if (this.elements != null) {
            int i = 0;
            while (i < this.elements.length) {
                this.ctv.setChecked(this.toString(this.elements[i]), false);
                ++i;
            }
        }
    }

    public Object[] getElements() {
        return this.elements;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

