/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.wizards.generic.pages;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.general.exception.IllegalNamingException;
import com.sap.ide.vi.text.ViUiTexts;
import com.sap.ide.vi.wizards.generic.adapter.ProjectSourceFolderAdapter;
import com.sap.ide.vi.wizards.generic.adapter.WizardButtonStatusAdapter;
import com.sap.ide.vi.wizards.generic.pages.BasicPage;
import com.sap.ide.vi.wizards.generic.pages.EndpointProjectLabelProvider;
import com.sap.ide.vi.wizards.generic.pages.WizardStatusContributor;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.content.provider.AllProjectsProvider;
import com.sap.ide.ws.core.services.content.provider.ProjectProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.ui.DefaultElementWrapper;
import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonStatusDialogField;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public abstract class BasicProjectSelectionPage
extends BasicPage {
    protected static final String LABEL_TEXT_SOURCE_FOLDER = ViUiTexts.getString("GenericWsWizardPage.sourceFolder");
    protected static final String LABEL_TEXT_PROJECT = ViUiTexts.getString("GenericWsWizardPage.project");
    protected static final String LABEL_TEXT_PACKAGE = ViUiTexts.getString("GenericWsWizardPage.package");
    private String uniqueProjectSourceFieldLabel = null;
    protected IJavaProject preselectedProject;
    protected String preselectedPackageName;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IPackageFragmentRoot;

    public BasicProjectSelectionPage(String pageName) {
        super(pageName);
    }

    public ProjectProvider getMyProjectListContentProvider() {
        return new AllProjectsProvider();
    }

    public Class[] getMyAcceptedProjectSelectionClasses() {
        return new Class[]{class$org$eclipse$jdt$core$IPackageFragmentRoot == null ? (class$org$eclipse$jdt$core$IPackageFragmentRoot = BasicProjectSelectionPage.class$("org.eclipse.jdt.core.IPackageFragmentRoot")) : class$org$eclipse$jdt$core$IPackageFragmentRoot};
    }

    public String getProjectFromProjectSourceFolderField() {
        String sourceFolderContent = (String)this.getContentByLabelText(this.uniqueProjectSourceFieldLabel);
        if (sourceFolderContent != null) {
            if (sourceFolderContent.indexOf("/") > -1) {
                return sourceFolderContent.substring(0, sourceFolderContent.indexOf("/"));
            }
            if (sourceFolderContent.indexOf("\\") > -1) {
                return sourceFolderContent.substring(0, sourceFolderContent.indexOf("\\"));
            }
        }
        return sourceFolderContent;
    }

    public String getProjectFromProjectSourceFolderField(String projectFieldLabel) {
        String sourceFolderContent = (String)this.getContentByLabelText(this.uniqueProjectSourceFieldLabel);
        if (sourceFolderContent != null) {
            if (sourceFolderContent.indexOf("/") > -1) {
                return sourceFolderContent.substring(0, sourceFolderContent.indexOf("/"));
            }
            if (sourceFolderContent.indexOf("\\") > -1) {
                return sourceFolderContent.substring(0, sourceFolderContent.indexOf("\\"));
            }
        }
        return sourceFolderContent;
    }

    public String getContainerName() {
        if (this.uniqueProjectSourceFieldLabel != null) {
            return (String)this.getContentByLabelText(this.uniqueProjectSourceFieldLabel);
        }
        return null;
    }

    public IPackageFragmentRoot getRootByContainer() {
        if (this.uniqueProjectSourceFieldLabel == null || this.uniqueProjectSourceFieldLabel.length() == 0) {
            return null;
        }
        Object content = this.controlsByLabelTexts.get(this.uniqueProjectSourceFieldLabel);
        if (content == null) {
            return null;
        }
        if (content instanceof StringButtonDialogField) {
            StringButtonDialogField projectSourceFolder = (StringButtonDialogField)content;
            Object fCurrRoot = null;
            String str = projectSourceFolder.getText();
            if (str.length() == 0) {
                return null;
            }
            return this.getRootByContainer(str);
        }
        return null;
    }

    public IPackageFragmentRoot getRootByContainer(String containerName) {
        int resType;
        if (containerName == null) {
            return null;
        }
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(containerName));
        if (res != null && ((resType = res.getType()) == 4 || resType == 2)) {
            IProject proj = res.getProject();
            if (!proj.isOpen()) {
                return null;
            }
            IJavaProject jproject = JavaCore.create((IProject)proj);
            return jproject.getPackageFragmentRoot(res);
        }
        return null;
    }

    private IPackageFragment choosePackage() {
        Object fCurrPackage = null;
        IPackageFragmentRoot froot = this.getRootByContainer();
        Object[] packages = null;
        try {
            if (froot != null && froot.getElementName().length() > 0) {
                packages = froot.getChildren();
            }
        }
        catch (JavaModelException e) {
            WebServiceCorePlugin.logError((Throwable)e, ((Object)((Object)this)).getClass());
        }
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setIgnoreCase(false);
        dialog.setTitle(NewWizardMessages.getString((String)"NewTypeWizardPage.ChoosePackageDialog.title"));
        dialog.setMessage(NewWizardMessages.getString((String)"NewTypeWizardPage.ChoosePackageDialog.description"));
        dialog.setEmptyListMessage(NewWizardMessages.getString((String)"NewTypeWizardPage.ChoosePackageDialog.empty"));
        dialog.setElements(packages);
        if (fCurrPackage != null) {
            dialog.setInitialSelections(new Object[]{fCurrPackage});
        }
        if (dialog.open() == 0) {
            return (IPackageFragment)dialog.getFirstResult();
        }
        return null;
    }

    public String getPackageName() {
        if (this.preselectedPackageName != null) {
            return this.preselectedPackageName;
        }
        return (String)this.getContentByLabelText(LABEL_TEXT_PACKAGE);
    }

    protected ProjectSourceFolderAdapter getProjectSourceFolderAdapter(String labelText) {
        return new ProjectSourceFolderAdapter(labelText, this.getShell(), this, (ILabelProvider)new EndpointProjectLabelProvider());
    }

    public void init(Element selenaSelection) {
        if (selenaSelection != null) {
            this.preselectedProject = JavaCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(selenaSelection.getModel().getUniqueName().getName()));
        }
    }

    public void init(IStructuredSelection selection) {
        if (selection != null) {
            if (selection.getFirstElement() instanceof DefaultElementWrapper) {
                this.init(((DefaultElementWrapper)selection.getFirstElement()).getOriginalElement());
                return;
            }
            this.preselectedProject = (JavaProject)this.getJavaProjectFromSelection((ISelection)selection);
        }
    }

    protected IJavaElement getJavaProjectFromSelection(ISelection selection) {
        IProject project = null;
        if (((IStructuredSelection)selection).getFirstElement() instanceof IResource) {
            if (((IStructuredSelection)selection).getFirstElement() instanceof IProject) {
                project = (IProject)((IStructuredSelection)selection).getFirstElement();
            } else {
                IContainer parent = ((IResource)((IStructuredSelection)selection).getFirstElement()).getParent();
                while (!(parent instanceof IProject)) {
                    parent = parent.getParent();
                }
                project = (IProject)parent;
            }
            return JavaCore.create((IProject)project);
        }
        if (((IStructuredSelection)selection).getFirstElement() instanceof IJavaElement) {
            if (((IStructuredSelection)selection).getFirstElement() instanceof IJavaProject) {
                return (IJavaProject)((IStructuredSelection)selection).getFirstElement();
            }
            IJavaElement parent = ((IJavaElement)((IStructuredSelection)selection).getFirstElement()).getParent();
            while (!(parent instanceof IJavaProject)) {
                parent = parent.getParent();
            }
            return parent;
        }
        return null;
    }

    protected String getPreselectedProjectAndSourceFolderName() {
        String initialProjectName = "";
        if (this.preselectedProject != null) {
            try {
                IClasspathEntry[] clp = this.preselectedProject.getRawClasspath();
                int i = 0;
                while (i < clp.length) {
                    if (clp[i].getEntryKind() == 3 && (!(initialProjectName = clp[i].getPath().toOSString()).startsWith("gen") || clp.length <= 1)) break;
                    ++i;
                }
                if (initialProjectName.startsWith(File.separator)) {
                    initialProjectName = initialProjectName.substring(1);
                }
            }
            catch (Exception ex) {
                WebServiceCorePlugin.logError((Throwable)ex, ((Object)((Object)this)).getClass());
            }
        }
        return initialProjectName;
    }

    protected IStatus packageChanged() {
        StatusInfo status = new StatusInfo();
        IPackageFragment fCurrPackage = null;
        String packName = (String)this.getContentByLabelText(LABEL_TEXT_PACKAGE);
        if (packName != null && packName.length() > 0) {
            IStatus val = JavaConventions.validatePackageName((String)packName);
            if (val.getSeverity() == 4) {
                status.setError(NewWizardMessages.getFormattedString((String)"NewTypeWizardPage.error.InvalidPackageName", (Object)val.getMessage()));
                return status;
            }
            if (val.getSeverity() == 2) {
                status.setWarning(NewWizardMessages.getFormattedString((String)"NewTypeWizardPage.warning.DiscouragedPackageName", (Object)val.getMessage()));
            }
        }
        try {
            Metamodel.getNamingService().checkMainDevelopmentObjectPackage(packName);
        }
        catch (IllegalNamingException e) {
            status.setError(e.getMessage());
            return status;
        }
        IPackageFragmentRoot root = this.getRootByContainer();
        if (root != null) {
            if (root.getJavaProject().exists() && packName != null && packName.length() > 0) {
                try {
                    IPath packagePath;
                    IPath rootPath = root.getPath();
                    IPath outputPath = root.getJavaProject().getOutputLocation();
                    if (rootPath.isPrefixOf(outputPath) && !rootPath.equals((Object)outputPath) && outputPath.isPrefixOf(packagePath = rootPath.append(packName.replace('.', '/')))) {
                        status.setError(NewWizardMessages.getString((String)"NewTypeWizardPage.error.ClashOutputLocation"));
                        return status;
                    }
                }
                catch (JavaModelException e) {
                    WebServiceCorePlugin.logError((Throwable)e, ((Object)((Object)this)).getClass());
                }
            }
            fCurrPackage = root.getPackageFragment(packName);
        } else {
            status.setError("");
        }
        return status;
    }

    protected void createProjectSourceFolderControls(Composite composite, int nColumns) {
        this.createProjectSourceFolderControls(composite, nColumns, this.getPreselectedProjectAndSourceFolderName(), new WizardStatusContributor(){

            public IStatus fieldChanged() {
                return new StatusInfo(0, "");
            }

            public String fieldLabelText() {
                return LABEL_TEXT_SOURCE_FOLDER;
            }
        });
    }

    protected void createProjectControls(Composite composite, int nColumns, String labelText, WizardStatusContributor contributor) {
        this.createProjectSourceFolderControls(composite, nColumns, labelText, BasicPage.BUTTON_TEXT_BROWSE, this.getPreselectedProjectAndSourceFolderName(), true, contributor);
    }

    protected void createProjectControls(Composite composite, int nColumns, final String labelText, String initialValue, final WizardStatusContributor contributor) {
        final ProjectSourceFolderAdapter projectSourceFolderAdapter = this.getProjectSourceFolderAdapter(labelText);
        final StringButtonDialogField projectSourceFolder = new StringButtonDialogField((IStringButtonAdapter)projectSourceFolderAdapter);
        projectSourceFolder.setDialogFieldListener((IDialogFieldListener)projectSourceFolderAdapter);
        projectSourceFolder.setLabelText(labelText);
        projectSourceFolder.setButtonLabel(BasicPage.BUTTON_TEXT_BROWSE);
        if (initialValue != null) {
            projectSourceFolder.setText(initialValue);
        }
        projectSourceFolder.doFillIntoGrid(composite, nColumns);
        LayoutUtil.setWidthHint((Control)projectSourceFolder.getTextControl(null), (int)this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)projectSourceFolder.getTextControl(null));
        this.controlsByLabelTexts.put(labelText, projectSourceFolder);
        this.fieldStatusList.add(new WizardStatusContributor(){

            public IStatus fieldChanged() {
                IStatus status = contributor.fieldChanged();
                if (status == null || status.isOK() && !BasicProjectSelectionPage.this.isUiElementHidden(labelText)) {
                    status = BasicProjectSelectionPage.this.checkProjectAndSourceFolder(projectSourceFolder, true);
                    if (status.isOK()) {
                        return projectSourceFolderAdapter.checkCorrectProjectNature((String)BasicProjectSelectionPage.this.getContentByLabelText(labelText));
                    }
                    return status;
                }
                return status;
            }

            public String fieldLabelText() {
                return labelText;
            }
        });
        if (this.uniqueProjectSourceFieldLabel == null) {
            this.uniqueProjectSourceFieldLabel = labelText;
        }
    }

    protected void createProjectSourceFolderControls(Composite composite, int nColumns, String initialValue, WizardStatusContributor contributor) {
        this.createProjectSourceFolderControls(composite, nColumns, LABEL_TEXT_SOURCE_FOLDER, BasicPage.BUTTON_TEXT_BROWSE, initialValue, false, contributor);
    }

    protected void createProjectSourceFolderControls(Composite composite, int nColumns, String labelText, String buttonText, WizardStatusContributor contributor) {
        this.createProjectSourceFolderControls(composite, nColumns, labelText, buttonText, this.getPreselectedProjectAndSourceFolderName(), false, contributor);
    }

    protected void createProjectSourceFolderControls(Composite composite, int nColumns, final String labelText, String buttonText, String initialValue, final boolean projectOnly, final WizardStatusContributor contributor) {
        final ProjectSourceFolderAdapter projectSourceFolderAdapter = this.getProjectSourceFolderAdapter(labelText);
        final StringButtonDialogField projectSourceFolder = new StringButtonDialogField((IStringButtonAdapter)projectSourceFolderAdapter);
        projectSourceFolder.setDialogFieldListener((IDialogFieldListener)projectSourceFolderAdapter);
        projectSourceFolder.setLabelText(labelText);
        projectSourceFolder.setButtonLabel(buttonText);
        if (initialValue != null) {
            projectSourceFolder.setText(initialValue);
        }
        projectSourceFolder.doFillIntoGrid(composite, nColumns);
        LayoutUtil.setWidthHint((Control)projectSourceFolder.getTextControl(null), (int)this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)projectSourceFolder.getTextControl(null));
        this.controlsByLabelTexts.put(labelText, projectSourceFolder);
        this.fieldStatusList.add(new WizardStatusContributor(){

            public IStatus fieldChanged() {
                IStatus status = contributor.fieldChanged();
                if (status == null || status.isOK()) {
                    status = BasicProjectSelectionPage.this.checkProjectAndSourceFolder(projectSourceFolder, projectOnly);
                    if (status.isOK()) {
                        return projectSourceFolderAdapter.checkCorrectProjectNature(BasicProjectSelectionPage.this.getProjectFromProjectSourceFolderField());
                    }
                    return status;
                }
                return status;
            }

            public String fieldLabelText() {
                return labelText;
            }
        });
        if (this.uniqueProjectSourceFieldLabel == null) {
            this.uniqueProjectSourceFieldLabel = labelText;
        }
    }

    private IResource getResourceByName(String resourceName) {
        if (resourceName.length() > 0) {
            Path path = new Path(resourceName);
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            return res;
        }
        return null;
    }

    private IStatus checkProjectAndSourceFolder(StringButtonDialogField projectSourceFolder, boolean projectOnly) {
        StatusInfo status = new StatusInfo();
        status.setOK();
        IPackageFragmentRoot fCurrRoot = null;
        IWorkspaceRoot lWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String str = projectSourceFolder.getText();
        if (str.length() == 0) {
            status.setError(NewWizardMessages.getString((String)"NewContainerWizardPage.error.EnterContainerName"));
            return status;
        }
        IResource res = this.getResourceByName(str);
        if (res != null) {
            int resType = res.getType();
            if (resType == 4 || resType == 2) {
                IProject proj = res.getProject();
                if (!proj.isAccessible()) {
                    status.setError(NewWizardMessages.getFormattedString((String)"NewContainerWizardPage.error.ProjectClosed", (Object)proj.getFullPath().toString()));
                    return status;
                }
                IJavaProject jproject = JavaCore.create((IProject)proj);
                fCurrRoot = jproject.getPackageFragmentRoot(res);
                if (res.exists() && !projectOnly) {
                    if (!jproject.isOnClasspath((IJavaElement)fCurrRoot)) {
                        status.setError(NewWizardMessages.getFormattedString((String)"NewContainerWizardPage.warning.NotOnClassPath", (Object)str));
                    } else if (fCurrRoot.isArchive()) {
                        status.setError(NewWizardMessages.getFormattedString((String)"NewContainerWizardPage.error.ContainerIsBinary", (Object)str));
                        return status;
                    }
                }
                return status;
            }
            status.setError(NewWizardMessages.getFormattedString((String)"NewContainerWizardPage.error.NotAFolder", (Object)str));
            return status;
        }
        status.setError(NewWizardMessages.getFormattedString((String)"NewContainerWizardPage.error.ContainerDoesNotExist", (Object)str));
        return status;
    }

    protected void createPackageControls(Composite composite, int nColumns) {
        this.createPackageControls(composite, nColumns, false);
    }

    protected void createPackageControls(Composite composite, int nColumns, boolean usePreselectedPackage) {
        WizardButtonStatusAdapter adapter = new WizardButtonStatusAdapter(){

            public IStatus fieldChanged() {
                IPackageFragmentRoot root = BasicProjectSelectionPage.this.getRootByContainer();
                return BasicProjectSelectionPage.this.packageChanged();
            }

            public void changeControlPressed(DialogField field) {
                IPackageFragment pf = BasicProjectSelectionPage.this.choosePackage();
                if (pf != null && pf.getElementName() != null) {
                    this.setText(pf.getElementName());
                }
            }

            public String fieldLabelText() {
                return LABEL_TEXT_PACKAGE;
            }
        };
        final StringButtonStatusDialogField packageField = new StringButtonStatusDialogField((IStringButtonAdapter)adapter);
        adapter.setReferencedObject((StringButtonDialogField)packageField);
        packageField.setLabelText(LABEL_TEXT_PACKAGE);
        packageField.setButtonLabel(BasicPage.BUTTON_TEXT_BROWSE);
        packageField.setStatusWidthHint(NewWizardMessages.getString((String)"NewTypeWizardPage.default"));
        packageField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                StringButtonStatusDialogField sbsdf = (StringButtonStatusDialogField)field;
                if (sbsdf.getText().length() == 0) {
                    sbsdf.setStatus(NewWizardMessages.getString((String)"NewTypeWizardPage.default"));
                } else {
                    sbsdf.setStatus("");
                }
                BasicProjectSelectionPage.this.doStatusUpdate();
            }

            public void setEnabled(boolean enabled) {
                packageField.setEnabled(enabled);
            }

            public void setText(String text) {
                packageField.setText(text);
            }
        });
        if (usePreselectedPackage && this.preselectedPackageName != null) {
            packageField.setText(this.preselectedPackageName);
        }
        packageField.doFillIntoGrid(composite, nColumns);
        LayoutUtil.setWidthHint((Control)packageField.getTextControl(null), (int)this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)packageField.getTextControl(null));
        this.controlsByLabelTexts.put(LABEL_TEXT_PACKAGE, packageField);
        this.fieldStatusList.add(adapter);
    }

    protected boolean checkProjectExists(String name) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkProjectForSourceFolder() {
        IJavaProject elem;
        if (this.preselectedProject.getProject().getName() != null && (elem = JavaCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(this.preselectedProject.getProject().getName()))) instanceof IJavaProject) {
            try {
                IPackageFragmentRoot[] roots = elem.getAllPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    if (roots[i].getKind() == 1 && !roots[i].getResource().getName().equals(elem.getElementName()) && roots[i].getResource() != null) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            catch (JavaModelException e) {
                WebServiceCorePlugin.logError((Throwable)e, ((Object)((Object)this)).getClass());
            }
        }
        return true;
    }

    public String getUniqueProjectSourceFieldLabel() {
        return this.uniqueProjectSourceFieldLabel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

