/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.wizards.generic.pages;

import com.sap.ide.vi.text.ViUiTexts;
import com.sap.ide.vi.wizards.generic.adapter.WizardButtonStatusAdapter;
import com.sap.ide.vi.wizards.generic.adapter.WizardTwoButtonStatusAdapter;
import com.sap.ide.vi.wizards.generic.elements.DescriptionDialogField;
import com.sap.ide.vi.wizards.generic.elements.DialogFieldDescription;
import com.sap.ide.vi.wizards.generic.elements.StringButtonFocusDialogField;
import com.sap.ide.vi.wizards.generic.elements.StringComboDialogField;
import com.sap.ide.vi.wizards.generic.elements.StringDescriptionDialogField;
import com.sap.ide.vi.wizards.generic.elements.StringTwoButtonDialogField;
import com.sap.ide.vi.wizards.generic.pages.IExtendedCheckStateListener;
import com.sap.ide.vi.wizards.generic.pages.WizardCheckTableObjectProvider;
import com.sap.ide.vi.wizards.generic.pages.WizardCheckTableSelectionListener;
import com.sap.ide.vi.wizards.generic.pages.WizardStatusContributor;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class BasicPage
extends NewElementWizardPage {
    protected static String BUTTON_TEXT_BROWSE = ViUiTexts.getString("WizardPageConstructionKit.browse");
    protected Hashtable controlsByLabelTexts = new Hashtable();
    protected Hashtable hiddenUiElementMap = new Hashtable();
    protected Hashtable dependendUiFieldLists = new Hashtable();
    protected ArrayList fieldStatusList = new ArrayList();
    private static final String BOTTOM_STATUS_LINE_TEXT = "btm_status";

    public BasicPage(String pageName) {
        super(pageName);
    }

    public abstract void createControl(Composite var1);

    public void setVisible(boolean visible) {
        super.updateStatus((IStatus)new StatusInfo(0, ""));
        super.setVisible(visible);
        this.doStatusUpdate();
    }

    public void doStatusUpdate() {
        if (this.fieldStatusList.size() > 0) {
            boolean statusToUpdate = true;
            StatusInfo resultStatus = null;
            int i = 0;
            while (i < this.fieldStatusList.size()) {
                IStatus tempStatus = ((WizardStatusContributor)this.fieldStatusList.get(i)).fieldChanged();
                if (tempStatus.getSeverity() == 4) {
                    String fieldLabel = ((WizardStatusContributor)this.fieldStatusList.get(i)).fieldLabelText();
                    if (this.dependendUiFieldLists.containsKey(fieldLabel)) {
                        ArrayList list = (ArrayList)this.dependendUiFieldLists.get(fieldLabel);
                        int j = 0;
                        while (j < list.size()) {
                            Object o = list.get(j);
                            if (o instanceof StringButtonDialogField) {
                                ((StringButtonDialogField)o).setEnabled(false);
                            } else {
                                System.out.println();
                            }
                            ++j;
                        }
                    }
                    resultStatus = tempStatus;
                    this.updateStatus((IStatus)resultStatus);
                    statusToUpdate = false;
                    break;
                }
                if (tempStatus.getSeverity() == 2) {
                    resultStatus = tempStatus;
                }
                ++i;
            }
            if (statusToUpdate) {
                if (resultStatus == null) {
                    resultStatus = new StatusInfo(0, this.getPageDescription());
                }
                this.updateStatus((IStatus)resultStatus);
            }
        }
    }

    protected abstract String getPageDescription();

    public Object getContentByLabelText(String labelText) {
        if (this.controlsByLabelTexts == null || labelText == null) {
            return null;
        }
        Object content = this.controlsByLabelTexts.get(labelText);
        if (content == null) {
            return "";
        }
        if (content instanceof StringDialogField) {
            return ((StringDialogField)content).getText();
        }
        if (content instanceof StringComboDialogField) {
            return ((StringComboDialogField)((Object)content)).getText();
        }
        if (content instanceof SelectionButtonDialogField) {
            return new Boolean(((SelectionButtonDialogField)content).isSelected());
        }
        if (content instanceof DescriptionDialogField) {
            return ((DescriptionDialogField)((Object)content)).getText();
        }
        return "";
    }

    public void setContentByLabelText(String labelText, Object newContent) {
        if (newContent == null) {
            return;
        }
        Object content = this.controlsByLabelTexts.get(labelText);
        if (content != null) {
            if (content instanceof StringDialogField) {
                ((StringDialogField)content).setText((String)newContent);
            } else if (content instanceof StringComboDialogField) {
                ((StringComboDialogField)((Object)content)).setText((String)newContent);
            } else if (content instanceof SelectionButtonDialogField) {
                ((SelectionButtonDialogField)content).setSelection(((Boolean)newContent).booleanValue());
            }
        }
    }

    public void setEnabledByLabelText(String labelText, boolean enabled) {
        Object content = this.controlsByLabelTexts.get(labelText);
        if (content != null) {
            ((DialogField)content).setEnabled(enabled);
        }
    }

    protected void setBottomStatusLineText(String text) {
        if (this.controlsByLabelTexts.containsKey(BOTTOM_STATUS_LINE_TEXT)) {
            ((Label)this.controlsByLabelTexts.get(BOTTOM_STATUS_LINE_TEXT)).setText(text);
        }
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(30);
    }

    protected void createComboBoxControls(Composite composite, int nColumns, String labelText, WizardStatusContributor contributor, String[] items, String initialValue) {
        StringComboDialogField comboField = new StringComboDialogField();
        comboField.setLabelText(labelText);
        comboField.doFillIntoGrid(composite, nColumns);
        comboField.setItems(items);
        LayoutUtil.setWidthHint((Control)comboField.getComboControl(null), (int)this.getMaxFieldWidth());
        Object tempDesc = null;
        comboField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                BasicPage.this.doStatusUpdate();
            }
        });
        if (initialValue != null) {
            comboField.setText(initialValue);
        }
        if (contributor != null) {
            this.fieldStatusList.add(contributor);
        }
        this.controlsByLabelTexts.put(labelText, comboField);
    }

    protected void createSeparator(Composite composite, int nColumns) {
        new Separator(258).doFillIntoGrid(composite, nColumns, this.convertHeightInCharsToPixels(1));
    }

    protected void createDescriptionField(Composite composite, int nColumns, boolean spanAllColumns, boolean verticalScrollbars, final String labelText, int height, DialogFieldDescription dfd) {
        DescriptionDialogField ddf;
        if (spanAllColumns) {
            ddf = new DescriptionDialogField();
        } else {
            ddf = new StringDescriptionDialogField();
            ddf.setLabelText(labelText);
        }
        ddf.doFillIntoGrid(composite, nColumns, height);
        final DialogFieldDescription dfDesc = dfd;
        final DescriptionDialogField finDdf = ddf;
        this.fieldStatusList.add(new WizardStatusContributor(){

            public IStatus fieldChanged() {
                finDdf.setText(dfDesc.getDescription());
                return new StatusInfo();
            }

            public String fieldLabelText() {
                return labelText;
            }
        });
        if (labelText != null) {
            this.controlsByLabelTexts.put(labelText, ddf);
        }
    }

    protected void createNameControls(Composite composite, int nColumns, String labelText, WizardStatusContributor contributor, String initialName, boolean fullWidth) {
        StringDialogField nameField = new StringDialogField();
        nameField.setLabelText(labelText);
        nameField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                BasicPage.this.doStatusUpdate();
            }
        });
        nameField.doFillIntoGrid(composite, nColumns);
        if (initialName != null) {
            nameField.setText(initialName);
        }
        LayoutUtil.setWidthHint((Control)nameField.getTextControl(null), (int)this.getMaxFieldWidth());
        if (fullWidth) {
            LayoutUtil.setHorizontalGrabbing((Control)nameField.getTextControl(null));
        }
        if (contributor != null) {
            this.fieldStatusList.add(contributor);
        }
        this.controlsByLabelTexts.put(labelText, nameField);
    }

    protected void createNameControls(Composite composite, int nColumns, String labelText, WizardStatusContributor contributor, String initialName) {
        this.createNameControls(composite, nColumns, labelText, contributor, initialName, false);
    }

    protected void createCheckBoxControl(Composite composite, int nColumns, String labelText) {
        SelectionButtonDialogField selectionField = new SelectionButtonDialogField(32);
        selectionField.setLabelText(labelText);
        selectionField.doFillIntoGrid(composite, nColumns);
        this.controlsByLabelTexts.put(labelText, selectionField);
    }

    private TextViewer createDescriptionTextArea(Composite composite, int nColumns, int height) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = nColumns;
        gd.verticalSpan = height;
        gd.heightHint = height;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = false;
        int style = 2122;
        if (height > 5) {
            style |= 0x200;
        }
        TextViewer textViewer = new TextViewer(composite, style);
        textViewer.setEditable(false);
        textViewer.getTextWidget().setLayoutData((Object)gd);
        textViewer.getTextWidget().setBackground(composite.getBackground());
        return textViewer;
    }

    public void changeContentProviderForCheckTable(String labelText, WizardCheckTableObjectProvider provider, boolean allCheckBoxesToInitializeWith) {
        Object content = this.controlsByLabelTexts.get(labelText);
        if (content != null && content instanceof CheckboxTableViewer) {
            CheckboxTableViewer ctv = (CheckboxTableViewer)content;
            boolean enabled = ctv.getTable().getEnabled();
            if (ctv.getTable().getItems().length == 0) {
                enabled = true;
            }
            provider.setViewer(ctv);
            ctv.setContentProvider((IContentProvider)provider);
            Object[] objects = provider.getElements(null);
            if (objects != null) {
                if (allCheckBoxesToInitializeWith) {
                    ctv.setCheckedElements(objects);
                }
                if (objects.length == 0) {
                    ctv.getTable().setEnabled(false);
                } else {
                    ctv.getTable().setEnabled(enabled);
                }
            }
            provider.getElements(null);
            ctv.refresh();
        }
    }

    protected void createCheckboxTableControls(Composite composite, int nColumns, String labelText, ILabelProvider labelProvider, WizardCheckTableObjectProvider contentProvider, WizardStatusContributor contributor, IExtendedCheckStateListener checkStateListener, final WizardCheckTableSelectionListener selectionListener, String itemInfoLabelText, boolean allCheckBoxesToInitializeWith, int height) {
        GridData tableData = new GridData();
        tableData.horizontalAlignment = 4;
        tableData.grabExcessHorizontalSpace = true;
        tableData.heightHint = height;
        tableData.widthHint = 220;
        tableData.horizontalSpan = nColumns;
        Label label = new Label(composite, 0);
        label.setText(labelText);
        GridData labelGd = new GridData();
        labelGd.verticalAlignment = 1;
        label.setLayoutData((Object)labelGd);
        final CheckboxTableViewer ctv = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        ctv.addCheckStateListener((ICheckStateListener)checkStateListener);
        ctv.getTable().setLayoutData((Object)tableData);
        ctv.setLabelProvider((IBaseLabelProvider)labelProvider);
        ctv.setContentProvider((IContentProvider)contentProvider);
        ctv.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                BasicPage.this.doStatusUpdate();
                ctv.refresh(event.getElement());
            }
        });
        ctv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object o = ((WizardCheckTableObjectProvider)ctv.getContentProvider()).toElement((String)((IStructuredSelection)event.getSelection()).getFirstElement());
                selectionListener.selectionChanged(o);
            }
        });
        ctv.setInput((Object)"");
        contentProvider.setViewer(ctv);
        Object[] objects = contentProvider.getElements(null);
        if (objects != null) {
            if (allCheckBoxesToInitializeWith) {
                ctv.setCheckedElements(objects);
            }
            if (objects.length == 0) {
                ctv.getTable().setEnabled(false);
            }
        }
        ctv.refresh();
        if (contributor != null) {
            this.fieldStatusList.add(contributor);
        }
        this.controlsByLabelTexts.put(labelText, ctv);
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 2;
        buttonComposite.setLayout((Layout)buttonLayout);
        Button all = new Button(buttonComposite, 0);
        all.setText(ViUiTexts.getString("BasicPage.selectAllButton"));
        all.addMouseListener((MouseListener)new MyCheckMouseListener(true, ctv, checkStateListener));
        Button none = new Button(buttonComposite, 0);
        none.setText(ViUiTexts.getString("BasicPage.deselectAllButton"));
        none.addMouseListener((MouseListener)new MyCheckMouseListener(false, ctv, checkStateListener));
        Label infoLable = new Label(composite, 0);
        infoLable.setText(itemInfoLabelText);
        GridData statusLabelData = new GridData();
        statusLabelData.horizontalAlignment = 4;
        statusLabelData.grabExcessHorizontalSpace = true;
        statusLabelData.widthHint = 220;
        statusLabelData.horizontalSpan = nColumns;
        infoLable.setLayoutData((Object)statusLabelData);
        Label bottomStatusLabel = new Label(composite, 64);
        GridData bottomStatusLabelData = new GridData();
        bottomStatusLabelData.horizontalAlignment = 4;
        bottomStatusLabelData.grabExcessHorizontalSpace = true;
        bottomStatusLabelData.heightHint = 40;
        bottomStatusLabelData.widthHint = 220;
        bottomStatusLabelData.horizontalSpan = nColumns;
        bottomStatusLabel.setLayoutData((Object)bottomStatusLabelData);
        this.controlsByLabelTexts.put(BOTTOM_STATUS_LINE_TEXT, bottomStatusLabel);
        this.controlsByLabelTexts.put(labelText, ctv);
    }

    protected void createReferencedObjectControls(Composite composite, int nColumns, String labelText, String dependsOnField, String buttonText, WizardButtonStatusAdapter adapter, String initialValue, FocusListener focusListener) {
        StringButtonDialogField referencedObjectField;
        if (focusListener == null) {
            referencedObjectField = new StringButtonDialogField((IStringButtonAdapter)adapter);
            adapter.setReferencedObject(referencedObjectField);
            referencedObjectField.setLabelText(labelText);
            referencedObjectField.setButtonLabel(buttonText);
            referencedObjectField.setDialogFieldListener(new IDialogFieldListener(){

                public void dialogFieldChanged(DialogField field) {
                    BasicPage.this.doStatusUpdate();
                }
            });
            if (initialValue != null) {
                referencedObjectField.setText(initialValue);
            }
            referencedObjectField.doFillIntoGrid(composite, nColumns);
            LayoutUtil.setWidthHint((Control)referencedObjectField.getTextControl(null), (int)this.getMaxFieldWidth());
            LayoutUtil.setHorizontalGrabbing((Control)referencedObjectField.getTextControl(null));
            this.controlsByLabelTexts.put(labelText, referencedObjectField);
            this.fieldStatusList.add(adapter);
        } else {
            referencedObjectField = new StringButtonFocusDialogField(adapter, focusListener);
            adapter.setReferencedObject(referencedObjectField);
            referencedObjectField.setLabelText(labelText);
            referencedObjectField.setButtonLabel(buttonText);
            referencedObjectField.setDialogFieldListener(new IDialogFieldListener(){

                public void dialogFieldChanged(DialogField field) {
                    BasicPage.this.doStatusUpdate();
                }
            });
            if (initialValue != null) {
                referencedObjectField.setText(initialValue);
            }
            referencedObjectField.doFillIntoGrid(composite, nColumns);
            LayoutUtil.setWidthHint((Control)referencedObjectField.getTextControl(null), (int)this.getMaxFieldWidth());
            LayoutUtil.setHorizontalGrabbing((Control)referencedObjectField.getTextControl(null));
            this.controlsByLabelTexts.put(labelText, referencedObjectField);
            this.fieldStatusList.add(adapter);
        }
        if (dependsOnField != null && dependsOnField.length() > 1) {
            if (this.dependendUiFieldLists.containsKey(dependsOnField)) {
                ArrayList list = (ArrayList)this.dependendUiFieldLists.get(dependsOnField);
                list.add(referencedObjectField);
            } else {
                ArrayList<StringButtonDialogField> list = new ArrayList<StringButtonDialogField>();
                list.add(referencedObjectField);
                this.dependendUiFieldLists.put(dependsOnField, list);
            }
        }
    }

    protected void createReferencedObjectControls(Composite composite, int nColumns, String labelText, String dependsOnField, WizardButtonStatusAdapter adapter, String initialValue) {
        this.createReferencedObjectControls(composite, nColumns, labelText, dependsOnField, BUTTON_TEXT_BROWSE, adapter, initialValue, null);
    }

    protected void createReferencedObjectControls(Composite composite, int nColumns, String labelText, WizardButtonStatusAdapter adapter, String initialValue) {
        this.createReferencedObjectControls(composite, nColumns, labelText, null, BUTTON_TEXT_BROWSE, adapter, initialValue, null);
    }

    protected void createTwoButtonStringDialogField(Composite composite, int nColumns, String labelText, String firstButtonText, String secondButtonText, WizardTwoButtonStatusAdapter adapter) {
        this.createTwoButtonStringDialogField(composite, nColumns, labelText, firstButtonText, secondButtonText, adapter, null);
    }

    protected void createTwoButtonStringDialogField(Composite composite, int nColumns, String labelText, String firstButtonText, String secondButtonText, WizardTwoButtonStatusAdapter adapter, FocusListener textFocusListener) {
        final StringTwoButtonDialogField referencedObjectField = new StringTwoButtonDialogField(adapter, textFocusListener);
        adapter.setReferencedObject(referencedObjectField);
        referencedObjectField.setLabelText(labelText);
        referencedObjectField.setFirstButtonText(firstButtonText);
        referencedObjectField.setSecondButtonText(secondButtonText);
        referencedObjectField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                BasicPage.this.doStatusUpdate();
            }

            public void setEnabled(boolean enabled) {
                referencedObjectField.setEnabled(enabled);
            }

            public void setText(String text) {
                referencedObjectField.setText(text);
            }
        });
        referencedObjectField.doFillIntoGrid(composite, nColumns);
        LayoutUtil.setHorizontalGrabbing((Control)referencedObjectField.getTextControl(null));
        LayoutUtil.setWidthHint((Control)referencedObjectField.getTextControl(null), (int)this.getMaxFieldWidth());
        this.controlsByLabelTexts.put(labelText, referencedObjectField);
        this.fieldStatusList.add(adapter);
    }

    protected void createReferencedObjectControls(Composite composite, int nColumns, String labelText, String dependsOnField, String buttonText, WizardButtonStatusAdapter adapter) {
        this.createReferencedObjectControls(composite, nColumns, labelText, dependsOnField, buttonText, adapter, null, null);
    }

    protected void hideByLabel(Composite composite, String labelText, boolean hide) {
        Object content = this.controlsByLabelTexts.get(labelText);
        if (content != null && content instanceof StringButtonDialogField) {
            ((StringButtonDialogField)content).getTextControl(composite).setVisible(!hide);
            ((StringButtonDialogField)content).getLabelControl(composite).setVisible(!hide);
            ((StringButtonDialogField)content).getChangeControl(composite).setVisible(!hide);
            if (hide) {
                this.hiddenUiElementMap.put(labelText, content);
            } else {
                this.hiddenUiElementMap.remove(labelText);
            }
        }
    }

    protected boolean isUiElementHidden(String labelText) {
        return this.hiddenUiElementMap.containsKey(labelText);
    }

    public Object[] getCheckedObjectsByLabelText(String labelText) {
        Object content = this.controlsByLabelTexts.get(labelText);
        if (content == null) {
            return null;
        }
        if (content instanceof CheckboxTableViewer) {
            return ((CheckboxTableViewer)content).getCheckedElements();
        }
        return null;
    }

    private class MyCheckMouseListener
    implements MouseListener {
        private boolean check;
        private CheckboxTableViewer ctv;
        private IExtendedCheckStateListener checkStateListener;

        public MyCheckMouseListener(boolean check, CheckboxTableViewer ctv, IExtendedCheckStateListener checkStateListener) {
            this.check = check;
            this.ctv = ctv;
            this.checkStateListener = checkStateListener;
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            if (this.check) {
                ((WizardCheckTableObjectProvider)this.ctv.getContentProvider()).checkAllElements();
                this.checkStateListener.allElementsCheckedInternally();
            } else {
                ((WizardCheckTableObjectProvider)this.ctv.getContentProvider()).uncheckAllElements();
                this.checkStateListener.allElementsUnCheckedInternally();
            }
        }

        public void mouseUp(MouseEvent e) {
        }
    }
}

