/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.wizards.generic.elements;

import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class StringComboDialogField
extends DialogField {
    private String fText;
    private Combo fComboControl;
    private ModifyListener fModifyListener;
    private String[] items;

    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)DialogField.gridDataForLabel((int)1));
        Combo combo = this.getComboControl(parent);
        combo.setLayoutData((Object)StringComboDialogField.gridDataForCombo(nColumns - 1));
        return new Control[]{label, combo};
    }

    public int getNumberOfControls() {
        return 2;
    }

    public boolean setFocus() {
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.setFocus();
        }
        return true;
    }

    protected static GridData gridDataForCombo(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        return gd;
    }

    public Combo getComboControl(Composite parent) {
        if (this.fComboControl == null) {
            this.fModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    StringComboDialogField.this.doModifyText(e);
                }
            };
            this.fComboControl = new Combo(parent, 2060);
            if (this.fText != null) {
                this.fComboControl.setText(this.fText);
            }
            this.fComboControl.setFont(parent.getFont());
            this.fComboControl.addModifyListener(this.fModifyListener);
            this.fComboControl.setEnabled(this.isEnabled());
        }
        return this.fComboControl;
    }

    private void doModifyText(ModifyEvent e) {
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fText = this.fComboControl.getText();
        }
        this.dialogFieldChanged();
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.setEnabled(this.isEnabled());
        }
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.setText(text);
        } else {
            this.dialogFieldChanged();
        }
    }

    public void setTextWithoutUpdate(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.removeModifyListener(this.fModifyListener);
            this.fComboControl.setText(text);
            this.fComboControl.addModifyListener(this.fModifyListener);
        }
    }

    public void setItems(String[] items) {
        this.items = items;
        this.fComboControl.setItems(items);
    }
}

