/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.wizards.generic.elements;

import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DescriptionDialogField
extends DialogField {
    private String fText;
    private TextViewer fTextViewer;

    public Control[] doFillIntoGrid(Composite parent, int nColumns, int height) {
        this.assertEnoughColumns(nColumns);
        Control tViewerControl = this.getTextViewerControl(parent, height);
        tViewerControl.setLayoutData((Object)DescriptionDialogField.gridDataForTextViewer(nColumns, height));
        return new Control[]{tViewerControl};
    }

    public int getNumberOfControls() {
        return 1;
    }

    public boolean setFocus() {
        if (this.isOkToUse((Control)this.fTextViewer.getTextWidget())) {
            this.fTextViewer.getTextWidget().setFocus();
        }
        return true;
    }

    public Control getTextViewerControl(Composite parent, int height) {
        if (this.fTextViewer == null) {
            int style = 2122;
            if (height > 3) {
                style |= 0x200;
            }
            this.fTextViewer = new TextViewer(parent, style);
            this.fTextViewer.setEditable(false);
            if (this.fText != null) {
                this.setText(this.fText);
            }
            this.fTextViewer.getTextWidget().setBackground(parent.getBackground());
        }
        return this.fTextViewer.getTextWidget();
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fTextViewer.getTextWidget())) {
            if (this.fTextViewer.getDocument() == null) {
                this.fTextViewer.setDocument((IDocument)new Document());
            }
            this.fTextViewer.getDocument().set(text);
        } else {
            this.dialogFieldChanged();
        }
    }

    public void setTextWithoutUpdate(String text) {
        this.setText(text);
    }

    protected static GridData gridDataForTextViewer(int span, int height) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        gd.verticalSpan = height;
        gd.heightHint = height;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = false;
        return gd;
    }
}

