/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.wizards.generic;

import com.sap.ide.vi.wizards.generic.CreationFailedException;
import com.sap.ide.vi.wizards.generic.tasks.CreationTaskDescriptor;
import com.tssap.selena.model.elements.Element;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;

public abstract class GenericWizard
extends Wizard {
    private ISelection selection;
    private Element selenaSelection;
    private CreationTaskDescriptor localTaskDescriptor = null;
    protected int taskCounter = 0;
    protected boolean wizardOpensEditor = true;

    public GenericWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void initSelena(Element selenaSelection) {
        this.selenaSelection = selenaSelection;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public Element getSelenaSelection() {
        return this.selenaSelection;
    }

    protected void setSelenaSelection(Element element) {
        this.selenaSelection = element;
    }

    protected void setSelection(ISelection selection) {
        this.selection = selection;
    }

    public int getTotalWorkSteps() {
        return this.getTaskDescriptions().length;
    }

    protected final CreationTaskDescriptor getTaskDescriptor() {
        if (this.localTaskDescriptor == null) {
            this.localTaskDescriptor = new CreationTaskDescriptor(this.getTaskDescriptions(), this.getTotalWorkSteps(), this.wizardOpensEditor);
        }
        return this.localTaskDescriptor;
    }

    protected String[] getTaskDescriptions() {
        return new String[0];
    }

    protected final void nextProgressStep(IProgressMonitor monitor) {
        String taskName = this.getTaskDescriptor().getTaskDescription(this.taskCounter);
        int max = this.getTaskDescriptor().getTotalWork();
        if (this.taskCounter == 0) {
            monitor.beginTask(taskName, max);
        } else if (this.taskCounter < max) {
            monitor.worked(this.getTaskDescriptor().getSingleStepAmount());
            monitor.setTaskName(taskName);
        }
        ++this.taskCounter;
    }

    protected abstract Object createNewDO(IProgressMonitor var1) throws CreationFailedException;

    protected abstract void startEditor(Object[] var1);

    protected abstract Object exists();

    protected abstract void delete(Object var1);
}

