/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.wizards.generic;

import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.vi.text.ViUiTexts;
import com.sap.ide.vi.wizards.generic.CreationFailedException;
import com.sap.ide.vi.wizards.generic.GenericWizard;
import com.sap.ide.vi.wizards.generic.pages.BasicProjectSelectionPage;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.resources.WsRefreshAction;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class GenericProjectWizard
extends GenericWizard {
    protected BasicProjectSelectionPage projectPage;
    static /* synthetic */ Class class$com$sap$ide$vi$wizards$generic$GenericProjectWizard;

    public GenericProjectWizard() {
    }

    public GenericProjectWizard(Element selenaSelection) {
        this.initSelena(selenaSelection);
    }

    public boolean performFinish() {
        this.checkExistenceAndDelete();
        ProgressMonitorDialog dialog1 = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        GenericProjectWizard.this.doFinish(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (CreationFailedException e) {
                        throw new InvocationTargetException(e);
                    }
                    Object var5_2 = null;
                }
                catch (Throwable throwable) {
                    Object var5_3 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
        };
        try {
            dialog1.run(false, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$wizards$generic$GenericProjectWizard == null ? (class$com$sap$ide$vi$wizards$generic$GenericProjectWizard = GenericProjectWizard.class$("com.sap.ide.vi.wizards.generic.GenericProjectWizard")) : class$com$sap$ide$vi$wizards$generic$GenericProjectWizard));
            return false;
        }
        return true;
    }

    public String getProjectName() {
        if (this.projectPage != null && this.projectPage.getProjectFromProjectSourceFolderField() != null) {
            return this.projectPage.getProjectFromProjectSourceFolderField();
        }
        return null;
    }

    protected static SourcePathIdentifier getSourcePathIdentifier(String containerName, String projectName) {
        SourcePathIdentifier spi = null;
        if (containerName != null) {
            Path currentPath = new Path(containerName);
            if (projectName != null && projectName.length() > 0) {
                MetamodelManager mmm = MetamodelManager.getMetamodelManager((String)projectName);
                currentPath = mmm.makePathAbsolute((IPath)currentPath);
                spi = mmm.getSourcePathIdentifier((IPath)currentPath);
            }
        }
        return spi;
    }

    protected String getProjectNameFromUmlTreeElement(Entity element) {
        return element.getModel().getUniqueName().getName();
    }

    protected void checkExistenceAndDelete() {
        Object o = this.exists();
        if (o != null) {
            this.delete(o);
        }
    }

    private void doFinish(IProgressMonitor monitor) throws CoreException, CreationFailedException {
        String tempProjectName;
        this.nextProgressStep(monitor);
        if (this.projectPage instanceof BasicProjectSelectionPage && (tempProjectName = this.getProjectName()) == null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (this.projectPage.getContainerName() != null) {
                IResource resource = root.findMember((IPath)new Path(this.projectPage.getContainerName()));
                if (!resource.exists() || !(resource instanceof IContainer)) {
                    this.throwCoreException(ViUiTexts.getString("GenericWSWizard.container", this.projectPage.getContainerName()));
                }
                IContainer container = (IContainer)resource;
                int secondContainerSlashPos = this.projectPage.getContainerName().indexOf("/", 1);
                String projectName = container.getProject().getName().toString();
            }
        }
        final Object newDO = this.createNewDO(monitor);
        this.nextProgressStep(monitor);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                GenericProjectWizard.this.startEditor(new Object[]{GenericProjectWizard.this.getProjectName(), newDO});
            }
        });
        if (this.getProjectName() != null) {
            new WsRefreshAction().refresh(this.getProjectName());
        }
    }

    private String convertPathSlashes(String path) {
        path = path.indexOf(47) > -1 ? path.replace('/', '\\') : path.replace('\\', '/');
        return path;
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "com.sap.ide.ws", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

