/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.wizards.MethodAdder.pages;

import com.sap.ide.metamodel.vi.EndpointReference;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.vi.check.ViBasics;
import com.sap.ide.vi.endpoints.EndpointAnalyser;
import com.sap.ide.vi.outline.VepOutlineTreeLabelProvider;
import com.sap.ide.vi.text.ViUiTexts;
import com.sap.ide.vi.types.MethodAttributes;
import com.sap.ide.vi.wizards.MethodAdder.MethodAdderWizard;
import com.sap.ide.vi.wizards.generic.pages.IExtendedCheckStateListener;
import com.sap.ide.vi.wizards.generic.pages.WizardCheckTableObjectProvider;
import com.sap.ide.vi.wizards.generic.pages.WizardCheckTableSelectionListener;
import com.sap.ide.vi.wizards.generic.pages.WizardStatusContributor;
import com.sap.ide.vi.wizards.vi.AbstractViWizard;
import com.sap.ide.vi.wizards.vi.pages.AbstractViWizardPage;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MethodAdderPage
extends AbstractViWizardPage {
    private static String LABEL_METHOD_ADDING = ViUiTexts.getString("MethodAdderPage.checkbox.label");
    private VirtualInterface virtualInterface;
    private WizardCheckTableObjectProvider methodProvider;
    private String projectName;
    private MethodAttributes[] mas;

    public MethodAdderPage(VirtualInterface vi, String pN) {
        super(ViUiTexts.getString("MethodAdderPage.grid.title"));
        this.setTitle(ViUiTexts.getString("MethodSelectionPage.title"));
        this.setDescription(ViUiTexts.getString("MethodSelectionPage.description"));
        this.virtualInterface = vi;
        this.projectName = pN;
        this.setPageComplete(false);
    }

    protected String getPageDescription() {
        return ViUiTexts.getString("MethodSelectionPage.description");
    }

    public WizardCheckTableObjectProvider getMethodProvider() {
        String pn = ((AbstractViWizard)this.getWizard()).getEndpointReference().getProjectName();
        if (pn != null) {
            IType type = EndpointAnalyser.getITypeByEndpoint((EndpointReference)this.virtualInterface.getEndpointReference(), (String)pn);
            this.mas = ViBasics.buildUpMethodAttributeList((String)this.virtualInterface.getName(), (String)pn, (IType)type);
            int i = 0;
            while (i < this.mas.length) {
                if (this.virtualInterface.hasFunction(this.mas[i].getNameWithSignature())) {
                    this.mas[i].setToBeContainedOriginally(true);
                } else {
                    this.mas[i].setToBeContainedOriginally(false);
                }
                ++i;
            }
            ((MethodAdderWizard)this.getWizard()).setMethodAttributes(this.mas);
            this.methodProvider = new WizardCheckTableObjectProvider(this.mas, true){

                public Object toString(Object obj) {
                    return ((MethodAttributes)obj).getNameWithSignature();
                }

                public Object toElement(String toStringOfElement) {
                    Object[] elements = this.getElements();
                    int i = 0;
                    while (i < elements.length) {
                        if (((MethodAttributes)elements[i]).getNameWithSignature().equals(toStringOfElement)) {
                            return elements[i];
                        }
                        ++i;
                    }
                    return null;
                }
            };
        }
        return this.methodProvider;
    }

    public void createControl(Composite parent) {
        int nColumns = 4;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.initializeDialogUnits((Control)composite);
        this.createCheckboxTableControls(composite, nColumns, ViUiTexts.getString("MethodAdderPage.methods"), (ILabelProvider)new VepOutlineTreeLabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                return (String)element;
            }
        }, this.methodProvider, new WizardStatusContributor(){

            public IStatus fieldChanged() {
                return new StatusInfo();
            }

            public String fieldLabelText() {
                return ViUiTexts.getString("MethodAdderPage.methods");
            }
        }, new IExtendedCheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                MethodAdderPage.this.checkboxStateChanged(event, MethodAdderPage.this.methodProvider.getViewer());
            }

            public void allElementsCheckedInternally() {
                MethodAdderPage.this.allCheckBoxesChangedState(true);
            }

            public void allElementsUnCheckedInternally() {
                MethodAdderPage.this.allCheckBoxesChangedState(false);
            }
        }, new WizardCheckTableSelectionListener(){

            public void selectionChanged(Object selectedObject) {
            }
        }, "", false, 160);
        this.setControl((Control)composite);
    }

    private void checkboxStateChanged(CheckStateChangedEvent event, CheckboxTableViewer ctv) {
        ((AbstractViWizard)this.getWizard()).clearPages();
        MethodAttributes[] mas = ((MethodAdderWizard)this.getWizard()).getMethodAttributes();
        if (mas != null) {
            int i = 0;
            while (i < mas.length) {
                if (mas[i].getNameWithSignature().equals(event.getElement())) {
                    if (mas[i].isForbidden()) {
                        ctv.setChecked(event.getElement(), false);
                    } else if (mas[i].isToBeContainedOriginally()) {
                        ctv.setChecked(event.getElement(), true);
                    } else {
                        mas[i].setToBeContained(event.getChecked());
                        ctv.setChecked(event.getElement(), event.getChecked());
                        ((AbstractViWizard)this.getWizard()).setCheckRelevancy();
                        ((AbstractViWizard)this.getWizard()).reCheckVi(mas, this.virtualInterface.getTypes());
                        this.getContainer().updateButtons();
                    }
                }
                ++i;
            }
        }
    }

    private void allCheckBoxesChangedState(boolean checked) {
        MethodAttributes[] mas = ((AbstractViWizard)this.getWizard()).getMethodAttributes();
        if (mas != null) {
            int i = 0;
            while (i < mas.length) {
                if (!mas[i].isForbidden()) {
                    mas[i].setToBeContained(checked);
                    ((AbstractViWizard)this.getWizard()).setCheckRelevancy();
                    ((AbstractViWizard)this.getWizard()).reCheckVi(mas);
                    ((AbstractViWizard)this.getWizard()).reCheckVi(mas, this.virtualInterface.getTypes());
                    this.getContainer().updateButtons();
                }
                ++i;
            }
        }
    }

    public String getProjectFromProjectSourceFolderField() {
        return this.projectName;
    }

    public MethodAttributes[] getMethodAttributes() {
        CheckboxTableViewer ctv = this.methodProvider.getViewer();
        int i = 0;
        while (i < this.mas.length) {
            if (ctv.getChecked((Object)this.mas[i].getNameWithSignature())) {
                this.mas[i].setToBeContained(true);
            } else {
                this.mas[i].setToBeContained(false);
            }
            ++i;
        }
        return this.mas;
    }

    public VirtualInterface getVirtualInterface() {
        return this.virtualInterface;
    }
}

