/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.ui.sensitive;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.vi.Function;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.vi.ui.UIProcessing;
import com.sap.ide.vi.ui.sensitive.UiElementCreatedListener;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class SensitiveManager
implements UiElementCreatedListener {
    private Hashtable uiElementsForMetaDataObjects = new Hashtable();

    public void registerControlForSensitivity(UIProcessing control, DevelopmentObject creatingObject) {
        if (creatingObject != null) {
            Vector<UIProcessing> ob = (Vector<UIProcessing>)this.uiElementsForMetaDataObjects.get(creatingObject);
            if (ob == null) {
                ob = new Vector<UIProcessing>(1);
                this.uiElementsForMetaDataObjects.put(creatingObject, ob);
            }
            ob.add(control);
        }
    }

    public void clear() {
        this.uiElementsForMetaDataObjects = new Hashtable();
    }

    public void setSensitive(VirtualInterface virtualInterface) {
        this.setSensitive(virtualInterface, false);
    }

    public void setSensitive(VirtualInterface virtualInterface, boolean readOnly) {
        Function[] functions = virtualInterface.getFunctions();
        int i = 0;
        while (i < functions.length) {
            if (!readOnly) {
                this.setSensitive(functions[i], true);
            } else {
                this.setSensitive(functions[i], false);
            }
            ++i;
        }
        this.setSensitiveByHash(virtualInterface, !readOnly);
    }

    public void setSensitive(Function function, boolean enabled) {
        this.setSensitiveByHash(function, enabled);
        this.setSensitive(function.getIncomingParameters(), enabled);
        this.setSensitive(function.getOutgoingParameters(), enabled);
        this.setSensitive(function.getFaults(), enabled);
    }

    public void setSensitive(Object[] objects, boolean enabled) {
        int i = 0;
        while (i < objects.length) {
            this.setSensitiveByHash(objects[i], enabled);
            ++i;
        }
    }

    public void setSensitiveByHash(Object object, boolean enabled) {
        Vector vector = (Vector)this.uiElementsForMetaDataObjects.get(object);
        if (vector != null) {
            int i = 0;
            while (i < vector.size()) {
                if (vector.elementAt(i) != null) {
                    ((UIProcessing)vector.elementAt(i)).setEnabled(enabled);
                }
                ++i;
            }
        }
    }

    public void clearByHash(Object object) {
        Vector vector = (Vector)this.uiElementsForMetaDataObjects.get(object);
        if (vector != null) {
            int i = 0;
            while (i < vector.size()) {
                Control cont = (Control)vector.elementAt(i);
                if (cont instanceof Button) {
                    ((Button)cont).setSelection(false);
                } else if (cont instanceof Text) {
                    ((Text)cont).setText("");
                }
                ++i;
            }
        }
    }
}

