/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.ui.pane;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.vi.Fault;
import com.sap.ide.metamodel.vi.Function;
import com.sap.ide.metamodel.vi.Parameter;
import com.sap.ide.vi.outline.VepOutlineTreeLabelProvider;
import com.sap.ide.vi.structure.ParametersOrFaults;
import com.sap.ide.vi.ui.pane.PaneCreateListener;
import com.tssap.util.ui.pane.ITabbedPane;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class PaneHandler
implements PaneCreateListener {
    private TabbedPaneHandler currentFunctionHandler = null;
    private TabbedPaneHandler currentInOutHandler = null;
    private TabbedPaneHandler currentParameterHandler = null;
    private Hashtable tabHandlersForMetaDataObjects = new Hashtable();

    public void registerPaneCreated(ITabbedPane tabPane, Object creatingObject) {
        int currentIndex;
        Vector<TabbedPaneHandler> tabbedHandlers = new Vector<TabbedPaneHandler>();
        if (creatingObject instanceof Parameter || creatingObject instanceof Fault) {
            tabbedHandlers.add(this.currentFunctionHandler);
            tabbedHandlers.add(this.currentInOutHandler);
            currentIndex = this.currentParameterHandler == null ? 0 : this.currentParameterHandler.getIndex() + 1;
            this.currentParameterHandler = new TabbedPaneHandler(tabPane, currentIndex, creatingObject);
            tabbedHandlers.add(this.currentParameterHandler);
        }
        if (creatingObject instanceof ParametersOrFaults) {
            tabbedHandlers.add(this.currentFunctionHandler);
            currentIndex = this.currentInOutHandler == null ? 0 : this.currentInOutHandler.getIndex() + 1;
            this.currentInOutHandler = new TabbedPaneHandler(tabPane, currentIndex, creatingObject);
            tabbedHandlers.add(this.currentInOutHandler);
            this.currentParameterHandler = null;
        }
        if (creatingObject instanceof Function) {
            currentIndex = this.currentFunctionHandler == null ? 0 : this.currentFunctionHandler.getIndex() + 1;
            this.currentFunctionHandler = new TabbedPaneHandler(tabPane, currentIndex, creatingObject);
            tabbedHandlers.add(this.currentFunctionHandler);
            this.currentInOutHandler = null;
            this.currentParameterHandler = null;
        }
        this.tabHandlersForMetaDataObjects.put(creatingObject, tabbedHandlers.clone());
    }

    public void updateUI(DevelopmentObject object) {
        int depth = 0;
        if (object instanceof Function) {
            depth = 0;
        } else if (object instanceof Parameter || object instanceof Fault) {
            depth = 2;
        }
        Vector vec = (Vector)this.tabHandlersForMetaDataObjects.get(object);
        ((TabbedPaneHandler)vec.elementAt(depth)).updateTabItem(object);
    }

    public void exchangeFaults(Fault faultOld, Fault faultNew) {
        if (this.tabHandlersForMetaDataObjects.containsKey(faultOld)) {
            Vector vec = (Vector)this.tabHandlersForMetaDataObjects.remove(faultOld);
            this.tabHandlersForMetaDataObjects.put(faultNew, vec);
        }
    }

    private boolean isEqual(Object[] arr1, Object[] arr2) {
        int i = 0;
        while (i < arr1.length) {
            if (arr1[i] != arr2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void bringToTop(Object data) {
        Vector vec = (Vector)this.tabHandlersForMetaDataObjects.get(data);
        if (vec == null && data instanceof ParametersOrFaults) {
            ParametersOrFaults pOf1 = (ParametersOrFaults)data;
            Enumeration enumeration = this.tabHandlersForMetaDataObjects.keys();
            while (enumeration.hasMoreElements()) {
                Object o = enumeration.nextElement();
                if (!(o instanceof ParametersOrFaults)) continue;
                ParametersOrFaults pOf2 = (ParametersOrFaults)o;
                if (!this.isEqual(pOf1.getParts(), pOf2.getParts())) continue;
                vec = (Vector)this.tabHandlersForMetaDataObjects.get(o);
                break;
            }
        }
        if (vec == null) {
            return;
        }
        int i = 0;
        while (i < vec.size()) {
            ((TabbedPaneHandler)vec.elementAt(i)).bringToTop();
            ++i;
        }
    }

    private class TabbedPaneHandler {
        private ITabbedPane tabbedPane;
        private int index;
        private Object metaDataContainer;

        public TabbedPaneHandler(ITabbedPane pane, int i, Object pMetaDataContainer) {
            this.tabbedPane = pane;
            this.index = i;
            this.metaDataContainer = pMetaDataContainer;
            this.updateTabItem(pMetaDataContainer);
        }

        public int getIndex() {
            return this.index;
        }

        public void updateTabItem(Object o) {
            if (o == null) {
                return;
            }
            TabItem item = ((TabFolder)this.tabbedPane.getComposite()).getItem(this.index);
            VepOutlineTreeLabelProvider outlineTreeLabelProvider = new VepOutlineTreeLabelProvider();
            item.setText(outlineTreeLabelProvider.getText(o));
            item.setImage(outlineTreeLabelProvider.getImage(o));
        }

        public void bringToTop() {
            ((TabFolder)this.tabbedPane.getComposite()).setSelection(this.index);
        }
    }
}

