/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.ui;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.vi.Fault;
import com.sap.ide.metamodel.vi.Function;
import com.sap.ide.metamodel.vi.Parameter;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.vi.check.ViBasics;
import com.sap.ide.vi.endpoints.InadmissableTypeException;
import com.sap.ide.vi.text.ViUiTexts;
import com.sap.ide.vi.types.TypeAnalyser;
import com.sap.ide.vi.ui.CheckTextFieldProcessing;
import com.sap.ide.vi.ui.ComboFieldProcessing;
import com.sap.ide.vi.ui.UIProcessing;
import com.sap.ide.vi.ui.ViEditorCommListener;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TypeRenaming
extends ComboFieldProcessing {
    private DevelopmentObject containingObject;
    private VirtualInterface virtualInterface;
    private String projectName;

    public TypeRenaming(DevelopmentObject devObj, String pName, VirtualInterface vi, String projectName, ViEditorCommListener l) {
        this(devObj, pName, vi, projectName, l, null);
    }

    public TypeRenaming(DevelopmentObject devObj, String pName, VirtualInterface vi, String project, ViEditorCommListener l, UIProcessing pr) {
        super(pName, l, pr, (MainDevelopmentObject)vi);
        this.containingObject = devObj;
        this.virtualInterface = vi;
        this.projectName = project;
    }

    public String setName(String name) {
        String oldMappedType = null;
        String originalType = null;
        String newMappedType = null;
        if (this.containingObject instanceof Parameter) {
            oldMappedType = ((Parameter)this.containingObject).getMappedTypeReference().getName();
            originalType = ViBasics.getOriginalTypeforParameter((VirtualInterface)this.virtualInterface, (Parameter)((Parameter)this.containingObject));
        }
        if (this.containingObject instanceof Function) {
            oldMappedType = this.name;
            originalType = this.virtualInterface.getType(oldMappedType).getOriginal().getName();
        }
        if (oldMappedType.equals(newMappedType = name)) {
            return null;
        }
        if (this.containingObject instanceof Parameter && ((Parameter)this.containingObject).hasDefaultValue() && !TypeAnalyser.checkValueForPrimitiveType((String)((Parameter)this.containingObject).getDefaultValue().getName(), (String)newMappedType)) {
            MessageDialog dlg = new MessageDialog(Display.getCurrent().getActiveShell(), ViUiTexts.getString("TypeRenaming.Dialog.FixedInvalid.title"), null, ViUiTexts.getString("TypeRenaming.Dialog.FixedInvalid.description"), 1, new String[]{WsCoreUiTexts.getString((String)"WsCore.Labels.General.yes"), WsCoreUiTexts.getString((String)"WsCore.Labels.General.no")}, 0);
            if (dlg.open() == 0) {
                try {
                    ((Parameter)this.containingObject).getDefaultValue().delete();
                }
                catch (DeleteException e1) {
                    WebServiceCorePlugin.logError((Throwable)e1, this.getClass());
                }
                CheckTextFieldProcessing proc = (CheckTextFieldProcessing)this.uiProcessing;
                proc.modifyText("");
            } else {
                return oldMappedType;
            }
        }
        if (!this.checkMappedTypeName(originalType, newMappedType)) {
            MessageDialog.openInformation((Shell)new Shell(), (String)ViUiTexts.getString("TypeRenaming.Popup.TypeNotAllowed.title"), (String)ViUiTexts.getString("TypeRenaming.Popup.TypeNotAllowed.description", newMappedType));
            return oldMappedType;
        }
        TypeAnalyser analyser = null;
        try {
            analyser = TypeAnalyser.getInstance((String)this.projectName, (String)newMappedType, (int)1);
        }
        catch (InadmissableTypeException e) {
            MessageDialog.openInformation((Shell)new Shell(), (String)ViUiTexts.getString("TypeRenaming.Popup.TypeNotAllowed.title"), (String)ViUiTexts.getString("TypeRenaming.Popup.TypeNotAllowed.description", newMappedType));
            return oldMappedType;
        }
        String tempQualifiedTypeName = newMappedType;
        String tempOriginalTypeName = originalType;
        if (!TypeAnalyser.isConvertableType((String)tempOriginalTypeName)) {
            while (this.virtualInterface.hasType(tempQualifiedTypeName) && !this.virtualInterface.getType(tempQualifiedTypeName).getOriginal().getName().equals(tempOriginalTypeName)) {
                MessageDialog.openInformation((Shell)new Shell(), (String)ViUiTexts.getString("TypeRenaming.Popup.TypeAlreadyExists.title"), (String)ViUiTexts.getString("TypeRenaming.Popup.TypeAlreadyExists.description", tempQualifiedTypeName));
                tempQualifiedTypeName = newMappedType + ViUiTexts.getString("TypeRenaming.for") + tempOriginalTypeName;
                newMappedType = newMappedType + ViUiTexts.getString("TypeRenaming.for") + originalType;
            }
        }
        DevelopmentObject deletedObject = ViBasics.deleteTypeReference((VirtualInterface)this.virtualInterface, (DevelopmentObject)this.containingObject, (String)oldMappedType, (String)originalType);
        DevelopmentObject createdObject = null;
        try {
            createdObject = ViBasics.createTypeReferenceForDO((VirtualInterface)this.virtualInterface, null, (String)newMappedType, (String)originalType, (DevelopmentObject)this.containingObject);
        }
        catch (InadmissableTypeException e) {
            WebServiceCorePlugin.logError((Throwable)e, this.getClass());
        }
        if (this.containingObject instanceof Function) {
            this.communicator.notifyOfExchangeFaults(this, (Fault)deletedObject, (Fault)createdObject);
        }
        if (this.containingObject instanceof Parameter) {
            CheckTextFieldProcessing proc = (CheckTextFieldProcessing)this.uiProcessing;
            boolean b = false;
            if (analyser != null) {
                b = analyser.isDefaultInitialApplicable();
            }
            proc.setButtonEnabled(b);
        }
        return newMappedType;
    }

    public boolean checkMappedTypeName(String oldTypeName, String newTypeName) {
        if (TypeAnalyser.isTableType((String)oldTypeName) && TypeAnalyser.isTableType((String)newTypeName)) {
            return this.checkMappedTypeName(TypeAnalyser.getLineType((String)oldTypeName), TypeAnalyser.getLineType((String)newTypeName));
        }
        if (TypeAnalyser.isTableType((String)oldTypeName) || TypeAnalyser.isTableType((String)newTypeName)) {
            return false;
        }
        if (TypeAnalyser.isConvertableType((String)oldTypeName) != TypeAnalyser.isConvertableType((String)newTypeName)) {
            return false;
        }
        if (TypeAnalyser.isVoidType((String)oldTypeName) != TypeAnalyser.isVoidType((String)newTypeName)) {
            return false;
        }
        if (newTypeName.length() == 0) {
            return false;
        }
        return ViBasics.checkXMLElementName((String)newTypeName, (boolean)true);
    }
}

