/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.ui;

import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.vi.check.ViBasics;
import com.sap.ide.vi.text.ViUiTexts;
import com.sap.ide.vi.ui.UIProcessing;
import com.sap.ide.vi.ui.ViEditorCommListener;
import com.sap.ide.ws.core.editors.ResetPageStateI;
import org.eclipse.core.internal.resources.OS;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class TextFieldProcessing
extends UIProcessing
implements FocusListener {
    protected String name = "";
    public Text thisTextField;

    public TextFieldProcessing(String pName, ViEditorCommListener l, MainDevelopmentObject mdo) {
        this(pName, l, null, mdo);
    }

    public TextFieldProcessing(String pName, ViEditorCommListener l, UIProcessing pr, MainDevelopmentObject mdo) {
        super(l, pr, mdo);
        this.name = pName == null ? "" : pName;
    }

    public String getName() {
        return this.name;
    }

    public void setField(Scrollable textField) {
        this.thisTextField = (Text)textField;
    }

    public abstract String setName(String var1);

    protected String checkCharacters(String name) {
        return this.checkCharacters(name, true);
    }

    protected String checkCharacters(String name, boolean metamodelCheck) {
        if (name == null || name.length() == 0) {
            return this.name;
        }
        if (!ViBasics.checkXMLElementName((String)name, (boolean)metamodelCheck)) {
            MessageDialog.openInformation((Shell)new Shell(), (String)ViUiTexts.getString("MainObjects.virtualInterfaces"), (String)ViUiTexts.getString("ErrorPopup.wrongName.description"));
            return this.name;
        }
        if (!OS.isNameValid((String)name)) {
            MessageDialog.openInformation((Shell)new Shell(), (String)ViUiTexts.getString("MainObjects.virtualInterfaces"), (String)(name + " is a reserved device name on this platform"));
            return this.name;
        }
        return null;
    }

    public void modifyText(String text) {
        this.thisTextField.setText(text);
        this.setName(text);
    }

    public void modifyText(final ModifyEvent e) {
        if (!this.isInResetMode()) {
            if (!this.isChangeAllowed(new ResetPageStateI(){

                public void handleReset() {
                    if (e.getSource() instanceof Text) {
                        ((Text)e.getSource()).setText(TextFieldProcessing.this.name);
                    } else {
                        int i = 0;
                        while (i < ((Combo)e.getSource()).getItemCount()) {
                            if (((Combo)e.getSource()).getItem(i).equals(TextFieldProcessing.this.name)) {
                                ((Combo)e.getSource()).select(i);
                                break;
                            }
                            ++i;
                        }
                    }
                }
            })) {
                return;
            }
            String newName = e.getSource() instanceof Text ? this.setName(((Text)e.getSource()).getText()) : this.setName(((Combo)e.getSource()).getText());
            this.modifyTextDirectly(e, newName);
        }
    }

    public void modifyTextDirectly(ModifyEvent e, String name) {
        if (name != null) {
            this.name = name;
        }
        if (e.getSource() instanceof Text) {
            if (!((Text)e.getSource()).isDisposed()) {
                String text = ((Text)e.getSource()).getText();
                if (name != null && !name.equals(text)) {
                    ((Text)e.getSource()).setText(name);
                }
            }
        } else if (!((Combo)e.getSource()).isDisposed()) {
            String text = ((Combo)e.getSource()).getText();
            if (name != null && !name.equals(text)) {
                ((Combo)e.getSource()).setText(name);
            }
        }
        this.firePropertyChange();
    }

    public void setEnabled(boolean enabled) {
        if (this.thisTextField != null && !this.thisTextField.isDisposed()) {
            this.thisTextField.setEnabled(enabled);
        }
    }

    public void setEditable(boolean editable) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }
}

