/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.outline;

import com.sap.ide.metamodel.vi.Fault;
import com.sap.ide.metamodel.vi.Function;
import com.sap.ide.metamodel.vi.Parameter;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.vi.check.ViBasics;
import com.sap.ide.vi.structure.Faults;
import com.sap.ide.vi.structure.InputParameters;
import com.sap.ide.vi.structure.OutputParameters;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ViOutlineTreeModel {
    private VirtualInterface virtualInterface;

    public ViOutlineTreeModel(VirtualInterface vi) {
        this.virtualInterface = vi;
    }

    public DefaultTreeModel getTreeModelForOutline() {
        boolean index = false;
        DefaultMutableTreeNode classNode = new DefaultMutableTreeNode(this.virtualInterface);
        DefaultTreeModel viOutlineTreeModel = new DefaultTreeModel(classNode);
        Function[] lFunctions = this.virtualInterface.getFunctions();
        int i = 0;
        while (i < this.virtualInterface.getFunctionCount()) {
            Object[] faults;
            Object[] outParameters;
            Function currentFunction = lFunctions[i];
            DefaultMutableTreeNode methodNode = this.insertMethodNode(classNode, currentFunction, viOutlineTreeModel);
            Object[] inParameters = currentFunction.getIncomingParameters();
            if (ViBasics.isToShow((VirtualInterface)this.virtualInterface, (Object[])inParameters)) {
                DefaultMutableTreeNode inParNode = new DefaultMutableTreeNode(new InputParameters(currentFunction));
                viOutlineTreeModel.insertNodeInto(inParNode, methodNode, methodNode.getChildCount());
                int j = 0;
                while (j < currentFunction.getIncomingParameterCount()) {
                    if (ViBasics.isToShow((VirtualInterface)this.virtualInterface, (Parameter)inParameters[j])) {
                        this.insertInParameterNode(inParNode, (Parameter)inParameters[j], viOutlineTreeModel);
                    }
                    ++j;
                }
            }
            if (ViBasics.isToShow((VirtualInterface)this.virtualInterface, (Object[])(outParameters = currentFunction.getOutgoingParameters()))) {
                DefaultMutableTreeNode outParNode = new DefaultMutableTreeNode(new OutputParameters(currentFunction));
                viOutlineTreeModel.insertNodeInto(outParNode, methodNode, methodNode.getChildCount());
                int j = 0;
                while (j < currentFunction.getOutgoingParameterCount()) {
                    if (ViBasics.isToShow((VirtualInterface)this.virtualInterface, (Parameter)outParameters[j])) {
                        this.insertOutParameterNode(outParNode, (Parameter)outParameters[j], viOutlineTreeModel);
                    }
                    ++j;
                }
            }
            if (ViBasics.isToShow((VirtualInterface)this.virtualInterface, (Object[])(faults = currentFunction.getFaults()))) {
                DefaultMutableTreeNode faultNode = new DefaultMutableTreeNode(new Faults(currentFunction));
                viOutlineTreeModel.insertNodeInto(faultNode, methodNode, methodNode.getChildCount());
                int j = 0;
                while (j < currentFunction.getFaultCount()) {
                    if (ViBasics.isToShow((Fault)faults[j])) {
                        this.insertFaultNode(faultNode, (Fault)faults[j], viOutlineTreeModel);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return viOutlineTreeModel;
    }

    private DefaultMutableTreeNode insertMethodNode(DefaultMutableTreeNode classNode, Function function, DefaultTreeModel model) {
        DefaultMutableTreeNode methodNode = new DefaultMutableTreeNode(function);
        model.insertNodeInto(methodNode, classNode, classNode.getChildCount());
        return methodNode;
    }

    private void insertInParameterNode(DefaultMutableTreeNode inNode, Parameter parameter, DefaultTreeModel model) {
        DefaultMutableTreeNode parameterNode = new DefaultMutableTreeNode(parameter);
        model.insertNodeInto(parameterNode, inNode, inNode.getChildCount());
    }

    private void insertOutParameterNode(DefaultMutableTreeNode outNode, Parameter parameter, DefaultTreeModel model) {
        DefaultMutableTreeNode parameterNode = new DefaultMutableTreeNode(parameter);
        model.insertNodeInto(parameterNode, outNode, outNode.getChildCount());
    }

    private void insertFaultNode(DefaultMutableTreeNode faultsNode, Fault fault, DefaultTreeModel model) {
        DefaultMutableTreeNode faultNode = new DefaultMutableTreeNode(fault);
        model.insertNodeInto(faultNode, faultsNode, faultsNode.getChildCount());
    }
}

