/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.endpoints;

import com.sap.ide.vi.dialogs.WsInfoLabelProvider;
import com.sap.ide.vi.text.ViUiTexts;
import com.sap.ide.vi.wizards.vi.pages.BeanTypeInfo;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.filter.WebServiceFilterFactory;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.model.ejb.ISessionBean;
import com.tssap.j2ee.model.ejbjar.dd.IEnterpriseBean;
import com.tssap.j2ee.model.ejbjar.dd.IEnterpriseBeans;
import com.tssap.j2ee.ui.UIPlugin;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class EndpointBrower {
    private static EndpointBrower mInstance;
    static /* synthetic */ Class class$com$sap$ide$vi$endpoints$EndpointBrower;

    private EndpointBrower() {
    }

    public static String browseEndpoints(String projectName, IPackageFragmentRoot root, IRunnableContext context) {
        IProject project;
        if (mInstance == null) {
            mInstance = new EndpointBrower();
        }
        if (WebServiceFilterFactory.isEjbModuleOrEjbModuleDcProject((IProject)(project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)))) {
            return mInstance.browseEjbEndpoints(projectName);
        }
        if (WebServiceFilterFactory.isPortalProject((IProject)project)) {
            return mInstance.browsePortalEndpoints(root, context);
        }
        return mInstance.browseJavaEndpoints(root, context);
    }

    public static String browseEndpoints(String projectName, IPackageFragmentRoot root, IRunnableContext context, boolean flag) {
        IProject project;
        if (mInstance == null) {
            mInstance = new EndpointBrower();
        }
        if (WebServiceFilterFactory.isEjbModuleOrEjbModuleDcProject((IProject)(project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)))) {
            return mInstance.browseEjbReferences(projectName);
        }
        return mInstance.browseJavaEndpoints(root, context);
    }

    private String browseEjbReferences(String projectName) {
        IEnterpriseBeans beans = J2eeProjectManager.getEjbModule((String)projectName).getDescriptor().getEnterpriseBeans();
        Vector refList = new Vector();
        refList.addAll(this.getEjbReferences((IEnterpriseBean[])beans.getSessions(), "sessionBean"));
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new EjbReferenceLabelProvider());
        dialog.setTitle(ViUiTexts.getString("EndpointBrowser.ejbRefSelectionDialogTitle"));
        dialog.setMessage(ViUiTexts.getString("EndpointBrowser.ejbRefSelectionDialogBtn"));
        dialog.setElements(refList.toArray());
        if (dialog.open() == 0) {
            return ((EjbReferenceObject)dialog.getFirstResult()).getName();
        }
        return null;
    }

    private Vector getEjbReferences(IEnterpriseBean[] beans, String type) {
        Vector<EjbReferenceObject> refList = new Vector<EjbReferenceObject>();
        int i = 0;
        while (i < beans.length) {
            refList.add(new EjbReferenceObject(beans[i].getEjbName().getValue(), type));
            ++i;
        }
        return refList;
    }

    private String browseEjbEndpoints(String projectName) {
        ArrayList<BeanTypeInfo> typeList = new ArrayList<BeanTypeInfo>();
        IEnterpriseJavaBean[] beans = J2eeProjectManager.getEjbModule((String)projectName).getEnterpriseBeans();
        int i = 0;
        while (i < beans.length) {
            if (beans[i] instanceof ISessionBean) {
                IType beanType = beans[i].getBeanClass();
                IPackageFragment parentFragment = beanType.getPackageFragment();
                while (!(parentFragment instanceof IPackageFragmentRoot)) {
                    parentFragment = parentFragment.getParent();
                }
                String pack = "";
                String name = beanType.getFullyQualifiedName();
                if (name.indexOf(".") > -1) {
                    pack = name.substring(0, name.lastIndexOf("."));
                    name = name.substring(name.lastIndexOf(".") + 1);
                }
                typeList.add(new BeanTypeInfo(pack, name, beanType.getPath().toString(), (IPackageFragmentRoot)parentFragment));
            }
            ++i;
        }
        TwoPaneElementSelector dialog = new TwoPaneElementSelector(Display.getCurrent().getActiveShell(), (ILabelProvider)new VIWizardLabelProvider(16), (ILabelProvider)new VIWizardLabelProvider(40));
        dialog.setUpperListLabel(ViUiTexts.getString("NewVIWizardPage.endpoint.ejbs.title"));
        dialog.setLowerListLabel(ViUiTexts.getString("NewVIWizardPage.endpoint.packages.title"));
        dialog.setTitle(NewWizardMessages.getString((String)"NewTypeWizardPage.SuperClassDialog.title"));
        dialog.setMessage(NewWizardMessages.getString((String)"NewTypeWizardPage.SuperClassDialog.message"));
        dialog.setElements((Object[])typeList.toArray(new TypeInfo[typeList.size()]));
        if (dialog.open() == 0) {
            return ((TypeInfo)dialog.getFirstResult()).getFullyQualifiedName();
        }
        return null;
    }

    private String browsePortalEndpoints(IPackageFragmentRoot packRoot, IRunnableContext context) {
        if (packRoot == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{};
        try {
            elements = packRoot.getJavaProject().getAllPackageFragmentRoots();
        }
        catch (JavaModelException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$endpoints$EndpointBrower == null ? (class$com$sap$ide$vi$endpoints$EndpointBrower = EndpointBrower.class$("com.sap.ide.vi.endpoints.EndpointBrower")) : class$com$sap$ide$vi$endpoints$EndpointBrower));
        }
        ArrayList<IJavaElement> list = new ArrayList<IJavaElement>();
        int i = 0;
        while (i < elements.length) {
            if (!(elements[i] instanceof JarPackageFragmentRoot)) {
                list.add(elements[i]);
            }
            ++i;
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])list.toArray(new IJavaElement[list.size()]));
        TypeSelectionDialog tdialog = new TypeSelectionDialog(Display.getCurrent().getActiveShell(), context, 6, scope);
        tdialog.setFilter("*");
        tdialog.setTitle(ViUiTexts.getString("NewVIWizardPage.endpoint.class.title"));
        tdialog.setMessage(NewWizardMessages.getString((String)"NewTypeWizardPage.SuperClassDialog.message"));
        if (tdialog.open() == 0) {
            return ((IType)tdialog.getFirstResult()).getFullyQualifiedName();
        }
        return null;
    }

    private String browseJavaEndpoints(IPackageFragmentRoot packRoot, IRunnableContext context) {
        if (packRoot == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{};
        try {
            elements = packRoot.getJavaProject().getAllPackageFragmentRoots();
        }
        catch (JavaModelException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$endpoints$EndpointBrower == null ? (class$com$sap$ide$vi$endpoints$EndpointBrower = EndpointBrower.class$("com.sap.ide.vi.endpoints.EndpointBrower")) : class$com$sap$ide$vi$endpoints$EndpointBrower));
        }
        ArrayList<IJavaElement> list = new ArrayList<IJavaElement>();
        int i = 0;
        while (i < elements.length) {
            if (!(elements[i] instanceof JarPackageFragmentRoot)) {
                list.add(elements[i]);
            }
            ++i;
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])list.toArray(new IJavaElement[list.size()]));
        TypeSelectionDialog tdialog = new TypeSelectionDialog(Display.getCurrent().getActiveShell(), context, 5, scope);
        tdialog.setFilter("*");
        tdialog.setTitle(ViUiTexts.getString("NewVIWizardPage.endpoint.class.title"));
        tdialog.setMessage(NewWizardMessages.getString((String)"NewTypeWizardPage.SuperClassDialog.message"));
        if (tdialog.open() == 0) {
            return ((IType)tdialog.getFirstResult()).getFullyQualifiedName();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class EjbReferenceObject {
        private String ejbType;
        private String name;

        public EjbReferenceObject(String name, String type) {
            this.name = name;
            this.ejbType = type;
        }

        public String getType() {
            return this.ejbType;
        }

        public String getName() {
            return this.name;
        }
    }

    private class EjbReferenceLabelProvider
    extends LabelProvider {
        private EjbReferenceLabelProvider() {
        }

        public Image getImage(Object element) {
            return UIPlugin.getDefault().getImageRegistry().get(((EjbReferenceObject)element).getType());
        }

        public String getText(Object element) {
            return ((EjbReferenceObject)element).getName();
        }
    }

    public class VIWizardLabelProvider
    extends WsInfoLabelProvider {
        private final Image BEAN_ICON = UIPlugin.getImage((String)"sessionBean");

        public VIWizardLabelProvider(int flag) {
            super(flag);
        }

        public Image getImage(Object element) {
            if (!(element instanceof TypeInfo)) {
                return super.getImage(element);
            }
            if (this.isSet(32)) {
                TypeInfo typeRef = (TypeInfo)element;
                if (typeRef.getPackageName().equals(typeRef.getTypeContainerName())) {
                    return WsInfoLabelProvider.PKG_ICON;
                }
                return this.BEAN_ICON;
            }
            return this.BEAN_ICON;
        }
    }
}

