/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.editors.ts.reusable;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.vi.Fault;
import com.sap.ide.metamodel.vi.Field;
import com.sap.ide.metamodel.vi.Function;
import com.sap.ide.metamodel.vi.Parameter;
import com.sap.ide.metamodel.vi.Structure;
import com.sap.ide.metamodel.vi.Type;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.vi.editors.ts.pages.IVINoticeable;
import com.sap.ide.vi.editors.ts.pages.mapping.enums.EnumNode;
import com.sap.ide.vi.editors.ts.pages.mapping.enums.ViEnumTreeSelector;
import com.sap.ide.vi.endpoints.InadmissableTypeException;
import com.sap.ide.vi.types.TypeAnalyser;
import com.sap.ide.vi.ui.CheckBoxProcessing;
import com.sap.ide.vi.ui.CheckTextFieldProcessing;
import com.sap.ide.vi.ui.ComboFieldProcessing;
import com.sap.ide.vi.ui.TextFieldProcessing;
import com.sap.ide.vi.ui.UIProcessing;
import com.sap.ide.vi.ui.ViEditorCommListener;
import com.sap.ide.vi.ui.ViEditorCommunicator;
import com.sap.ide.vi.ui.sensitive.SensitiveManager;
import com.sap.ide.vi.ui.sensitive.UiElementCreatedEvent;
import com.sap.ide.vi.ui.sensitive.UiElementCreatedListener;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import com.tssap.util.ui.reuse.IReuseable;
import java.util.Vector;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Text;

public abstract class GenericPaneBuilder
implements IReuseable {
    protected VirtualInterface virtualInterface;
    protected String projectName;
    protected ViEditorCommListener editorCommListener;
    protected ViEditorCommunicator communicator = new ViEditorCommunicator();
    protected static String REPLACEMENT_PREFIX = "CopyOf";
    protected UiElementCreateAnnouncer sensAnnouncer = new UiElementCreateAnnouncer();
    private static SensitiveManager sensitivityManager = new SensitiveManager();

    public GenericPaneBuilder() {
    }

    public GenericPaneBuilder(VirtualInterface vi, ViEditorCommListener listener, String pN) {
        this.virtualInterface = vi;
        this.projectName = pN;
        this.sensAnnouncer.addViSensitivityListener(this.getSensitiveManager());
        this.editorCommListener = listener;
        this.communicator.addViEditorCommunicatorListener(this.editorCommListener);
    }

    protected SensitiveManager getSensitiveManager() {
        return sensitivityManager;
    }

    public void clearSensitivityManager() {
        this.getSensitiveManager().clear();
    }

    protected DevelopmentObject getAccordingDevelopmentObject(EnumNode object) {
        int j;
        Function[] functions = this.virtualInterface.getFunctions();
        int i = 0;
        while (i < functions.length) {
            Parameter[] parametersI = functions[i].getIncomingParameters();
            Parameter[] parametersO = functions[i].getOutgoingParameters();
            Parameter[] parameters = new Parameter[parametersI.length + parametersO.length];
            System.arraycopy(parametersI, 0, parameters, 0, parametersI.length);
            System.arraycopy(parametersO, 0, parameters, parametersI.length, parametersO.length);
            j = 0;
            if (j < parameters.length) {
                return parameters[j];
            }
            ++i;
        }
        Type[] types = this.virtualInterface.getTypes();
        int i2 = 0;
        while (i2 < types.length) {
            if (types[i2] instanceof Structure) {
                Field[] fields = ((Structure)types[i2]).getFields();
                j = 0;
                if (j < fields.length) {
                    return fields[j];
                }
            }
            ++i2;
        }
        return null;
    }

    protected void addEnumTreeSelector(DevelopmentObject dob, IGridLayoutPane mainPane) {
        String typeName = null;
        if (dob instanceof Field) {
            typeName = ((Field)dob).getTypeReference().getName();
        } else if (dob instanceof Parameter) {
            typeName = ((Parameter)dob).getMappedTypeReference().getName();
        }
        TypeAnalyser ana = null;
        try {
            ana = TypeAnalyser.getInstance((String)this.projectName, (String)typeName, (int)1);
        }
        catch (InadmissableTypeException e) {
            WebServiceCorePlugin.logError((Throwable)e, this.getClass());
        }
        if (ana != null && ana.isJavaPrimitiveType()) {
            ViEnumTreeSelector selector = new ViEnumTreeSelector(new IVINoticeable(){

                public void setDirtyFlag(boolean isDirty) {
                }
            }, this.virtualInterface, dob);
            selector.createControls(mainPane);
            selector.decorateControls();
        }
    }

    protected Function getAccordingFunction(DevelopmentObject object) {
        block10: {
            block9: {
                if (object instanceof Function) {
                    return (Function)object;
                }
                if (!(object instanceof Fault)) break block9;
                Fault fault = (Fault)object;
                Function[] functions = this.virtualInterface.getFunctions();
                int i = 0;
                while (i < functions.length) {
                    Fault[] faults = functions[i].getFaults();
                    int j = 0;
                    while (j < faults.length) {
                        if (fault == faults[j]) {
                            return functions[i];
                        }
                        ++j;
                    }
                    ++i;
                }
                break block10;
            }
            if (!(object instanceof Parameter)) break block10;
            Parameter parameter = (Parameter)object;
            Function[] functions = this.virtualInterface.getFunctions();
            int i = 0;
            while (i < functions.length) {
                Parameter[] parameters = functions[i].getIncomingParameters();
                int j = 0;
                while (j < parameters.length) {
                    if (parameter == parameters[j]) {
                        return functions[i];
                    }
                    ++j;
                }
                parameters = functions[i].getOutgoingParameters();
                int j2 = 0;
                while (j2 < parameters.length) {
                    if (parameter == parameters[j2]) {
                        return functions[i];
                    }
                    ++j2;
                }
                ++i;
            }
        }
        return null;
    }

    public static void refreshSensitivity(VirtualInterface vi) {
        sensitivityManager.setSensitive(vi);
    }

    protected void createCheckBox(DevelopmentObject creatingMetaDataObject, IGridLayoutPane parent, String label, UIProcessing boxData, boolean sensitive, int numberOfColumns) {
        boolean sel = false;
        if (boxData instanceof CheckBoxProcessing) {
            sel = ((CheckBoxProcessing)boxData).isSelected();
        }
        if (boxData instanceof CheckTextFieldProcessing) {
            sel = ((CheckTextFieldProcessing)boxData).isSelected();
        }
        Button box = parent.addCheckBox(label, sel, parent.createGridLayoutData(1, 2, numberOfColumns, 1));
        if (boxData != null) {
            box.addSelectionListener((SelectionListener)boxData);
            if (boxData instanceof CheckBoxProcessing) {
                ((CheckBoxProcessing)boxData).setButton(box);
                ((CheckBoxProcessing)boxData).setEnabled(sensitive);
            }
            if (boxData instanceof CheckTextFieldProcessing) {
                ((CheckTextFieldProcessing)boxData).setButton(box);
                ((CheckTextFieldProcessing)boxData).setButtonEnabled(sensitive);
            }
        }
        this.sensAnnouncer.notifyUiElementCreated(this, boxData, creatingMetaDataObject);
    }

    protected void createTextField(DevelopmentObject creatingMetaDataObject, IGridLayoutPane parent, String label, TextFieldProcessing textData, boolean readOnly) {
        parent.addTextLabel(label, parent.createGridLayoutData(1, 2, 1, 1));
        Text textField = parent.addTextField(textData.getName(), readOnly, parent.createGridLayoutData(4, 2, true, false, 2, 1));
        if (textData != null) {
            textField.addModifyListener((ModifyListener)textData);
            textField.addFocusListener((FocusListener)textData);
            if (textData instanceof TextFieldProcessing) {
                textData.setField((Scrollable)textField);
            }
            if (textData instanceof CheckTextFieldProcessing) {
                ((CheckTextFieldProcessing)textData).setField((Scrollable)textField);
            }
        }
        this.sensAnnouncer.notifyUiElementCreated(this, textData, creatingMetaDataObject);
    }

    protected abstract void addPaneData(IGridLayoutPane var1, Composite var2);

    public final Control createPartControl(Composite parent) {
        this.clearSensitivityManager();
        IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)parent, (int)1);
        this.addPaneData(mainPane, parent);
        this.getSensitiveManager().setSensitive(this.virtualInterface);
        return mainPane.getComposite();
    }

    protected void createComboOrTextField(DevelopmentObject creatingMetaDataObject, IGridLayoutPane parent, String label, TextFieldProcessing textData, boolean readOnly, String[] values) {
        if (values == null || values.length == 0) {
            this.createTextField(creatingMetaDataObject, parent, label, textData, readOnly);
        } else {
            readOnly = true;
            parent.addTextLabel(label, parent.createGridLayoutData(1, 2, 1, 1));
            Combo comboField = parent.addComboBox(values, TypeAnalyser.getPrimitiveTypeForQualifiedType((String)textData.getName()), readOnly, parent.createGridLayoutData(4, 2, true, false, 2, 1));
            if (textData != null) {
                comboField.addModifyListener((ModifyListener)textData);
                if (textData instanceof ComboFieldProcessing) {
                    ((ComboFieldProcessing)textData).setField((Scrollable)comboField);
                }
            }
            this.sensAnnouncer.notifyUiElementCreated(this, textData, creatingMetaDataObject);
        }
    }

    public abstract boolean isEnabled();

    public abstract void setEnabled(boolean var1);

    private class UiElementCreateAnnouncer {
        private Vector listeners = new Vector();

        private UiElementCreateAnnouncer() {
        }

        public synchronized void addViSensitivityListener(UiElementCreatedListener l) {
            this.listeners.addElement(l);
        }

        public synchronized void removeViSensitivityListener(UiElementCreatedListener l) {
            this.listeners.removeElement(l);
        }

        public void notifyUiElementCreated(Object source, UIProcessing pControl, DevelopmentObject pCreatingObject) {
            Vector l;
            UiElementCreatedEvent event = new UiElementCreatedEvent(source);
            UiElementCreateAnnouncer uiElementCreateAnnouncer = this;
            synchronized (uiElementCreateAnnouncer) {
                l = (Vector)this.listeners.clone();
            }
            int i = 0;
            while (i < l.size()) {
                try {
                    UiElementCreatedListener uiecl = (UiElementCreatedListener)this.listeners.elementAt(i);
                    uiecl.registerControlForSensitivity(pControl, pCreatingObject);
                }
                catch (Exception ex) {
                    WebServiceCorePlugin.logError((Throwable)ex, this.getClass());
                }
                ++i;
            }
        }
    }
}

