/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.editors.ts.pages.types;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.vi.Type;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.vi.check.ViBasics;
import com.sap.ide.vi.editors.ts.pages.types.SoapExtTypeRuntimeClass;
import com.sap.ide.vi.editors.ts.pages.types.SoapExtTypeRuntimeClasses;
import com.sap.ide.vi.editors.ts.pages.types.ViTypesReusableManager;
import com.sap.ide.vi.editors.ts.types.reusable.SoapExtTypeRuntimeClassPane;
import com.sap.ide.vi.ui.ViEditorCommListener;
import com.sap.ide.vi.wizards.rtClass.NewRuntimeClassWizard;
import com.sap.ide.ws.core.editors.HandleReadOnlyStateI;
import com.sap.ide.ws.core.editors.MdoReadOnlyStateHandler;
import com.tssap.util.ui.reuse.IReuseable;
import com.tssap.util.ui.reuse.tree.ITreeSelectorCallback;
import java.util.Vector;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.internal.WorkbenchPlugin;

public abstract class ViTypesAddRemoveCallback
implements ITreeSelectorCallback {
    private String projectName;
    private ViEditorCommListener vecListener;
    private VirtualInterface virtualInterface;
    private ViTypesReusableManager reuseManager;
    private Vector removableTypes = new Vector();
    private HandleReadOnlyStateI readStateHandler;

    public ViTypesAddRemoveCallback(VirtualInterface vi, String pN, ViEditorCommListener listener, ViTypesReusableManager rm) {
        this.virtualInterface = vi;
        this.vecListener = listener;
        this.projectName = pN;
        this.reuseManager = rm;
        this.readStateHandler = new MdoReadOnlyStateHandler((MainDevelopmentObject)this.virtualInterface);
        this.reloadRemovableTypes();
    }

    public boolean canAddElement(Object currentSelection) {
        return currentSelection instanceof SoapExtTypeRuntimeClasses && !this.virtualInterface.isReadOnly();
    }

    public Object addElement(Object currentSelection) {
        Type type = ((SoapExtTypeRuntimeClasses)currentSelection).getType();
        NewRuntimeClassWizard wizard = new NewRuntimeClassWizard(this.virtualInterface, this.projectName, type);
        wizard.setForcePreviousAndNextButtons(false);
        WizardDialog dialog = new WizardDialog(WorkbenchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        int res = dialog.open();
        if (res == 0) {
            this.vecListener.fireEditorChanged();
            this.refresh();
            return new SoapExtTypeRuntimeClass(new SoapExtTypeRuntimeClasses(type), this.virtualInterface.getType(wizard.getRTClassName()));
        }
        return null;
    }

    public void reloadRemovableTypes() {
        this.removableTypes.clear();
        int i = 0;
        while (i < this.virtualInterface.getTypeCount()) {
            Type currentType = this.virtualInterface.getTypes()[i];
            if (ViBasics.isMappedTypeDeletable((VirtualInterface)this.virtualInterface, (DevelopmentObject)currentType, (String)currentType.getName(), (String)currentType.getOriginal().getName())) {
                this.removableTypes.add(currentType.getName());
            }
            ++i;
        }
        boolean change = true;
        while (change) {
            change = false;
            int i2 = 0;
            while (i2 < this.virtualInterface.getTypeCount()) {
                Type currentType = this.virtualInterface.getTypes()[i2];
                if (!this.removableTypes.contains(currentType.getName()) && this.removableTypes.contains(currentType.getParentTypeName())) {
                    this.removableTypes.remove(currentType.getParentTypeName());
                    change = true;
                }
                ++i2;
            }
        }
    }

    public boolean canRemoveElement(Object currentSelection) {
        return currentSelection instanceof SoapExtTypeRuntimeClass && !this.virtualInterface.isReadOnly() && this.removableTypes.contains(((SoapExtTypeRuntimeClass)currentSelection).getSoapExtRuntimeClass().getName());
    }

    public boolean removeElement(Object currentSelection) {
        if (currentSelection instanceof SoapExtTypeRuntimeClass) {
            SoapExtTypeRuntimeClass cls = (SoapExtTypeRuntimeClass)currentSelection;
            String typeName = cls.getSoapExtRuntimeClass().getName();
            SoapExtTypeRuntimeClass orgType = cls;
            while (orgType.getSoapExtTypeRuntimeClasses() == null) {
                orgType = orgType.getParentSoapExtTypeRuntimeClass();
            }
            ViBasics.deleteTypeFromTypeHierarchy((VirtualInterface)this.virtualInterface, (DevelopmentObject)orgType.getSoapExtTypeRuntimeClasses().getType(), (String)typeName, null);
            this.vecListener.fireEditorChanged();
            this.refresh();
            return true;
        }
        return false;
    }

    public boolean isChangeAllowed() {
        return !this.readStateHandler.isReadOnly() || !(this.readStateHandler.isDtrRelevant() ? !this.readStateHandler.checkOutFromDtr() : !this.readStateHandler.changeFileReadOnlyFlag());
    }

    public abstract void refresh();

    public void selectionAboutToChange(Object currentSelection, IReuseable currentUIComponent) {
        if (currentSelection != null && currentSelection instanceof SoapExtTypeRuntimeClasses && currentUIComponent != null && currentUIComponent instanceof SoapExtTypeRuntimeClassPane) {
            this.reuseManager.setRuntimeClassDeleted();
        }
    }

    public void selectionChanged(Object currentSelection, IReuseable currentUIComponent) {
        boolean bl = true;
    }

    public String okToChangeSelection(IReuseable currentUIComponent) {
        return null;
    }
}

