/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.editors.ts.pages;

import com.sap.ide.vi.editors.ts.pages.IVINoticeable;
import com.sap.ide.vi.editors.ts.pages.ViEditorPage;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.tree.TreeSelector;
import com.tssap.util.ui.reuse.tree.TreeSelectorEditorComponent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class ViEditorPageWithTreeSelector
extends ViEditorPage
implements IModifiedCallback {
    private TreeSelectorEditorComponent treeSelectorEditorComponent;
    private boolean addRemoveButtons;
    private int myIndex;

    public ViEditorPageWithTreeSelector(IVINoticeable noticeable, boolean addRemove) {
        super(noticeable);
        this.addRemoveButtons = addRemove;
    }

    public void refresh() {
        this.getTreeSelectorEditorComponent().getTreeSelector().refreshTree();
        this.getTreeSelectorEditorComponent().getTreeSelector().getTreeViewer().refresh();
    }

    public void setPageIndex(int index) {
        this.myIndex = index;
    }

    public int getPageIndex() {
        return this.myIndex;
    }

    public void initControls() {
        if (this.getTreeSelectorEditorComponent() != null) {
            this.getTreeSelectorEditorComponent().getTreeSelector().getTreeViewer().expandToLevel(3);
        }
    }

    public Control createControls(IGridLayoutPane glp) {
        TreeSelector treeSelector = new TreeSelector(this.addRemoveButtons);
        this.treeSelectorEditorComponent = new TreeSelectorEditorComponent(treeSelector);
        Control ret = treeSelector.createPartControl(glp);
        return ret;
    }

    public void decorateControls() {
        this.getTreeSelectorEditorComponent().setModifiedCallback((IModifiedCallback)this);
        this.getTreeSelectorEditorComponent().getTreeSelector().getTreeViewer().expandToLevel(3);
    }

    public void dataModified(boolean modified) {
        TreeViewer treeViewer = this.getTreeSelectorEditorComponent().getTreeSelector().getTreeViewer();
        Tree tree = treeViewer.getTree();
        TreeItem[] selection = tree.getSelection();
        int i = 0;
        while (i < selection.length) {
            Object selectionData = selection[i].getData();
            treeViewer.refresh(selectionData, true);
            ++i;
        }
    }

    public TreeSelectorEditorComponent getTreeSelectorEditorComponent() {
        return this.treeSelectorEditorComponent;
    }
}

