/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.editors.ts.mapping.reusable;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.vi.Function;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.vi.editors.ts.mapping.reusable.FunctionPane;
import com.sap.ide.vi.editors.ts.pages.mapping.SoapExtFunction;
import com.sap.ide.vi.text.ViUiTexts;
import com.sap.ide.vi.ui.TextFieldProcessing;
import com.sap.ide.vi.ui.ViEditorCommListener;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class SoapExtFunctionPane
extends FunctionPane {
    public SoapExtFunctionPane(VirtualInterface vi, ViEditorCommListener listener, String pN, SoapExtFunction sFun) {
        super(vi, listener, pN, sFun.getFunction());
    }

    protected void addPaneData(IGridLayoutPane mainPane, Composite parent) {
        super.addPaneData(mainPane, parent);
        IGridLayoutData localData = mainPane.createGridLayoutData(4, 4, false, false, 1, 1);
        IGridLayoutPane groupGrid = mainPane.addGridLayoutPane(ViUiTexts.getString("SoapExtFunctionPane.grid.title"), 3, false, localData);
        if (!this.function.hasSoapExtensionFunction()) {
            if (!this.virtualInterface.isReadOnly()) {
                try {
                    this.function.createSoapExtensionFunction();
                }
                catch (CreateException e) {
                    WebServiceCorePlugin.logError((Throwable)e, this.getClass());
                }
            } else {
                return;
            }
        }
        this.createTextField((DevelopmentObject)this.function, groupGrid, ViUiTexts.getString("SoapExtFunctionPane.namespace"), new TextFieldProcessing(this.function.getSoapExtensionFunction().getNamespace(), this.editorCommListener, (MainDevelopmentObject)this.virtualInterface){

            public String setName(String name) {
                String s = this.checkCharacters(name, false);
                if (s != null) {
                    return s;
                }
                SoapExtFunctionPane.this.function.getSoapExtensionFunction().setNamespace(name);
                return name;
            }
        }, false);
        this.createTextField((DevelopmentObject)this.function, groupGrid, ViUiTexts.getString("SoapExtFunctionPane.request"), new TextFieldProcessing(this.function.getSoapExtensionFunction().getSOAPRequestName(), this.editorCommListener, (MainDevelopmentObject)this.virtualInterface){

            public String setName(String name) {
                String s = this.checkCharacters(name);
                if (s != null) {
                    return s;
                }
                if (!SoapExtFunctionPane.this.isNameUniqueInVi(name, SoapExtFunctionPane.this.function, true)) {
                    return this.name;
                }
                SoapExtFunctionPane.this.function.getSoapExtensionFunction().setSOAPRequestName(name);
                return name;
            }
        }, false);
        this.createTextField((DevelopmentObject)this.function, groupGrid, ViUiTexts.getString("SoapExtFunctionPane.response"), new TextFieldProcessing(this.function.getSoapExtensionFunction().getSOAPResponseName(), this.editorCommListener, (MainDevelopmentObject)this.virtualInterface){

            public String setName(String name) {
                String s = this.checkCharacters(name);
                if (s != null) {
                    return s;
                }
                if (!SoapExtFunctionPane.this.isNameUniqueInVi(name, SoapExtFunctionPane.this.function, false)) {
                    return this.name;
                }
                SoapExtFunctionPane.this.function.getSoapExtensionFunction().setSOAPResponseName(name);
                return name;
            }
        }, false);
    }

    private boolean isNameUniqueInVi(String name, Function function, boolean request) {
        Function[] functions = this.virtualInterface.getFunctions();
        int i = 0;
        while (i < functions.length) {
            if (!functions[i].equals(function)) {
                String soapRespName;
                String soapReqName;
                if (!(functions[i].getNameMappedTo().equals(function.getNameMappedTo()) && request || !(soapReqName = functions[i].getSoapExtensionFunction().getSOAPRequestName()).equals(name))) {
                    MessageDialog.openInformation((Shell)new Shell(), (String)ViUiTexts.getString("MainObjects.virtualInterfaces"), (String)ViUiTexts.getString("SoapExtFunctionPane.nameUsedAsRequestName", functions[i].getName()));
                    return false;
                }
                if ((!functions[i].getNameMappedTo().equals(function.getNameMappedTo()) || request) && (soapRespName = functions[i].getSoapExtensionFunction().getSOAPResponseName()).equals(name)) {
                    MessageDialog.openInformation((Shell)new Shell(), (String)ViUiTexts.getString("MainObjects.virtualInterfaces"), (String)ViUiTexts.getString("SoapExtFunctionPane.nameUsedAsResponseName", functions[i].getName()));
                    return false;
                }
            }
            ++i;
        }
        return true;
    }
}

