/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.editors.ts.mapping.reusable;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.vi.Function;
import com.sap.ide.metamodel.vi.Parameter;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.vi.editors.ts.mapping.reusable.PaneBuilder;
import com.sap.ide.vi.editors.ts.reusable.GenericPaneBuilder;
import com.sap.ide.vi.text.ViUiTexts;
import com.sap.ide.vi.ui.CheckBoxProcessing;
import com.sap.ide.vi.ui.TextFieldProcessing;
import com.sap.ide.vi.ui.ViEditorCommListener;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FunctionPane
extends PaneBuilder {
    protected Function function;

    public FunctionPane(VirtualInterface vi, ViEditorCommListener listener, String pN, Parameter par) {
        super(vi, listener, pN);
        this.function = this.getAccordingFunction((DevelopmentObject)par);
    }

    public FunctionPane(VirtualInterface vi, ViEditorCommListener listener, String pN, Function fun) {
        super(vi, listener, pN);
        this.function = fun;
    }

    protected void addPaneData(IGridLayoutPane mainPane, Composite parent) {
        IGridLayoutData localData = mainPane.createGridLayoutData(4, 4, true, false, 1, 1);
        IGridLayoutPane groupGrid = mainPane.addGridLayoutPane(ViUiTexts.getString("FunctionPane.grid.title"), 3, false, localData);
        if (this.function.isDeleted()) {
            return;
        }
        this.createCheckBox((DevelopmentObject)this.virtualInterface, groupGrid, ViUiTexts.getString("FunctionPane.exposed"), new CheckBoxProcessing(this.function.getIsExposed(), this.editorCommListener, (MainDevelopmentObject)this.virtualInterface){

            public void setSelection(Button button) {
                if (button == this.thisButton) {
                    FunctionPane.this.function.setIsExposed(button.getSelection());
                    FunctionPane.super.getSensitiveManager().setSensitive(FunctionPane.this.function, button.getSelection());
                    this.communicator.notifyOfUIToBeUpdated(this, (DevelopmentObject)FunctionPane.this.function);
                }
            }
        }, true, 3);
        this.createTextField((DevelopmentObject)this.function, groupGrid, ViUiTexts.getString("FunctionPane.originalName"), new TextFieldProcessing(this.function.getOriginalName(), this.editorCommListener, (MainDevelopmentObject)this.virtualInterface){

            public String setName(String name) {
                return null;
            }
        }, true);
        this.createTextField((DevelopmentObject)this.function, groupGrid, ViUiTexts.getString("FunctionPane.newName"), new TextFieldProcessing(this.function.getNameMappedTo(), this.editorCommListener, (MainDevelopmentObject)this.virtualInterface){

            public String setName(String name) {
                if (FunctionPane.this.function.isDeleted()) {
                    return name;
                }
                String s = this.checkCharacters(name);
                if (s != null) {
                    return s;
                }
                FunctionPane.this.function.setNameMappedTo(name);
                FunctionPane.this.function.getSoapExtensionFunction().setSOAPRequestName(name);
                FunctionPane.this.function.getSoapExtensionFunction().setSOAPResponseName(name + "Response");
                this.communicator.notifyOfUIToBeUpdated(this, (DevelopmentObject)FunctionPane.this.function);
                return name;
            }

            public void focusLost(FocusEvent e) {
                String name;
                if (e.getSource() instanceof Text && !FunctionPane.this.methodNameAvailable(name = ((Text)e.getSource()).getText())) {
                    MessageDialog.openInformation((Shell)new Shell(), (String)ViUiTexts.getString("FunctionPane.ErrorPopup.wrongName.title"), (String)ViUiTexts.getString("FunctionPane.ErrorPopup.wrongName.description", name));
                    name = FunctionPane.access$201() + name;
                    while (!FunctionPane.this.methodNameAvailable(name)) {
                        name = FunctionPane.access$301() + name;
                    }
                    this.modifyText(name);
                }
            }
        }, false);
    }

    public void setEnabled(boolean enabled) {
    }

    public boolean isEnabled() {
        return false;
    }

    private boolean methodNameAvailable(String methodName) {
        Function[] functions = this.virtualInterface.getFunctions();
        int i = 0;
        while (i < functions.length) {
            if (functions[i] != this.function && functions[i].getNameMappedTo() != null && functions[i].getNameMappedTo().equals(methodName)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static /* synthetic */ String access$201() {
        return GenericPaneBuilder.REPLACEMENT_PREFIX;
    }

    static /* synthetic */ String access$301() {
        return GenericPaneBuilder.REPLACEMENT_PREFIX;
    }
}

