/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.editors.ts;

import com.sap.ide.eclipse.dii.component.IAskForSaveEditor;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.editor.IDevelopmentObjectEditor;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.CommitResult;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.exception.SaveException;
import com.sap.ide.metamodel.vi.Fault;
import com.sap.ide.metamodel.vi.Function;
import com.sap.ide.metamodel.vi.VIRoot;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.metamodel.vi.plugin.VIRootManager;
import com.sap.ide.vi.builder.modules.ViEndpointCheckModule;
import com.sap.ide.vi.decorator.ViDecoratorFlagProvider;
import com.sap.ide.vi.editors.EditVIInput;
import com.sap.ide.vi.editors.ts.outline.ViLeanOutlineTreeModel;
import com.sap.ide.vi.editors.ts.pages.IVINoticeable;
import com.sap.ide.vi.editors.ts.pages.ViEditorPageWithTreeSelector;
import com.sap.ide.vi.editors.ts.pages.documentation.ViDocumentationPage;
import com.sap.ide.vi.editors.ts.pages.mapping.ViMappingPage;
import com.sap.ide.vi.editors.ts.pages.types.ViTypesPage;
import com.sap.ide.vi.editors.ts.reusable.GenericPaneBuilder;
import com.sap.ide.vi.outline.VepOutlinePage;
import com.sap.ide.vi.text.ViUiTexts;
import com.sap.ide.vi.types.TypeAnalyser;
import com.sap.ide.vi.ui.ViEditorCommListener;
import com.sap.ide.vi.ui.pane.PaneHandler;
import com.sap.ide.vi.uploadclient.ViUploadClient;
import com.sap.ide.ws.core.decorators.WsLabelDecorator;
import com.sap.ide.ws.core.editors.GenericWsEditorActionContributor;
import com.sap.ide.ws.core.editors.ShellFocusChangedHandler;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.resources.EclipseFilePathService;
import com.sap.ide.ws.core.services.resources.WsRefreshAction;
import com.sap.ide.ws.core.services.upload.UsernamePasswordHandler;
import com.sap.ide.ws.core.ui.preferences.WebServicePreferences;
import com.tssap.j2ee.core.providers.vi.ui.WsUIPlugin;
import com.tssap.util.help.ContextHelp;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class ViMultiPageEditor
extends MultiPageEditorPart
implements ViEditorCommListener,
IDevelopmentObjectEditor,
IAskForSaveEditor {
    private VirtualInterface virtualInterface = null;
    private String projectName = null;
    private ViMappingPage mappingPage;
    private ViTypesPage typesPage;
    private ViDocumentationPage documentationPage;
    private static final String TYPES_PAGE_NAME = ViUiTexts.getString("ViMultiPageEditor.page.title.types");
    private static final String MAPPING_PAGE_NAME = ViUiTexts.getString("ViMultiPageEditor.page.title.mapping");
    private static final String DOCUMENTATION_PAGE_NAME = ViUiTexts.getString("ViMultiPageEditor.page.title.documentation");
    private VepOutlinePage outlinePage = null;
    private PaneHandler paneHandler = new PaneHandler();
    private boolean dirty = false;
    private boolean readOnly = false;
    private ShellFocusChangedHandler focusChangedHandler;
    static /* synthetic */ Class class$org$eclipse$ui$views$contentoutline$IContentOutlinePage;

    public ViMultiPageEditor() {
        TypeAnalyser.clearAnalysedTypes();
    }

    public void refreshAllPages() {
        this.mappingPage.refresh();
        this.typesPage.refresh();
        this.documentationPage.refresh();
    }

    protected void createPages() {
        this.getContainer().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                ContextHelp.show((String)"com.sap.devmanual.doc.user", (String)"WSVI");
            }
        });
        this.mappingPage = new ViMappingPage(new IVINoticeable(){

            public void setDirtyFlag(boolean isDirty) {
            }
        }, this.virtualInterface, this.projectName, this);
        this.createPage(this.mappingPage, MAPPING_PAGE_NAME);
        this.typesPage = new ViTypesPage(new IVINoticeable(){

            public void setDirtyFlag(boolean isDirty) {
            }
        }, this.virtualInterface, this.projectName, this);
        this.createPage(this.typesPage, TYPES_PAGE_NAME);
        this.documentationPage = new ViDocumentationPage(new IVINoticeable(){

            public void setDirtyFlag(boolean isDirty) {
            }
        }, this.virtualInterface, this.projectName, this);
        this.createPage(this.documentationPage, DOCUMENTATION_PAGE_NAME);
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex == 1) {
            this.typesPage.reloadTypes();
        }
    }

    public DevelopmentObject getDevelopmentObject() {
        return this.virtualInterface;
    }

    public void updateUI() {
        Image image = WsUIPlugin.getImage((String)"web_services/virtual_interface/VirtualInterface.gif");
        this.setTitleImage(WsLabelDecorator.getInstance().decorateImage(image, (Object)new ViDecoratorFlagProvider(this.virtualInterface)));
    }

    private void createPage(ViEditorPageWithTreeSelector page, String pageTitle) {
        this.setTitle(this.virtualInterface.getName());
        this.updateUI();
        Composite composite = new Composite(this.getContainer(), 0);
        composite.setLayout((Layout)new FillLayout());
        int index = this.addPage((Control)composite);
        this.setPageText(index, pageTitle);
        page.createPartControl(composite);
        page.setPageIndex(index);
    }

    public void dispose() {
        super.dispose();
        Metamodel metaModel = MetamodelManager.getMetamodel((String)this.projectName);
        if (metaModel != null && this.virtualInterface != null && this.dirty) {
            try {
                this.virtualInterface.rollbackChanges();
            }
            catch (Exception e) {
                WebServiceCorePlugin.logError((Throwable)e, this.getClass());
            }
        }
        this.getSite().getShell().removeShellListener((ShellListener)this.focusChangedHandler);
    }

    public VirtualInterface getVirtualInterface() {
        return this.virtualInterface;
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.virtualInterface.isReadOnly()) {
            try {
                CommitResult result = this.virtualInterface.commitChanges();
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                dialog.open();
                IProgressMonitor progressMonitor = dialog.getProgressMonitor();
                MetamodelManager.getMetamodelManager((String)this.projectName).processDeletedFiles(result, progressMonitor);
                dialog.close();
            }
            catch (SaveException e2) {
                WebServiceCorePlugin.logError((Throwable)e2, this.getClass());
            }
            catch (DeleteException e2) {
                WebServiceCorePlugin.logError((Throwable)e2, this.getClass());
            }
            ViEndpointCheckModule.setViToBeChecked(this.projectName, this.virtualInterface);
            try {
                this.handleAutoUpload();
            }
            catch (Exception e1) {
                WebServiceCorePlugin.logMessage((String)"Auto upload could not be executed as no usernam/password was specified", (String)"doSave()", this.getClass());
            }
            try {
                new WsRefreshAction().refresh(this.projectName);
            }
            catch (Exception e) {
                try {
                    this.virtualInterface.rollbackChanges();
                }
                catch (LoadException le) {
                    WebServiceCorePlugin.logError((Throwable)le, this.getClass());
                }
                WebServiceCorePlugin.logError((Throwable)e, this.getClass());
            }
        } else {
            try {
                this.virtualInterface.rollbackChanges();
            }
            catch (LoadException le) {
                WebServiceCorePlugin.logError((Throwable)le, this.getClass());
            }
        }
        this.dirty = false;
        this.firePropertyChange(257);
    }

    public synchronized void handleAutoUpload() {
        ViUploadClient uploadClient = new ViUploadClient();
        if (WebServicePreferences.isAutoUploadEnabled()) {
            try {
                String userName = UsernamePasswordHandler.getUsername();
                String password = UsernamePasswordHandler.getPassword();
                if (uploadClient.mdoExistsOnServer((MainDevelopmentObject)this.virtualInterface, userName, password)) {
                    uploadClient.uploadMdo((MainDevelopmentObject)this.virtualInterface, userName, password);
                }
            }
            catch (Exception e) {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)ViUiTexts.getString("ViMultiPageEditor.dtrpopup.dtrfailed.title "), (String)ViUiTexts.getString("ViMultiPageEditor.dtrpopup.dtrfailed.description"));
                WebServiceCorePlugin.logWarning((Throwable)e, this.getClass());
            }
        }
    }

    public void doSaveAs() {
        this.dirty = false;
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(this.documentationPage.getPageIndex());
    }

    private EditVIInput getVIInputByFileEditorInput(FileEditorInput fileInput) {
        IFile file = fileInput.getFile();
        String projectName = file.getProject().getName();
        VIRoot root = VIRootManager.getVIRoot((String)projectName);
        try {
            VirtualInterface[] viArray = root.getVirtualInterfaces();
            int i = 0;
            if (i < viArray.length) {
                if (viArray[i].getAbsolutePath().replace('\\', '/').endsWith(file.getFullPath().toString().replace('\\', '/'))) {
                    // empty if block
                }
                return new EditVIInput(projectName, viArray[i]);
            }
        }
        catch (Exception e) {
            WebServiceCorePlugin.logError((Throwable)e, this.getClass());
        }
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.setInput(input);
        this.setSite((IWorkbenchPartSite)site);
        this.focusChangedHandler = new ShellFocusChangedHandler((IWorkbenchPart)this);
        site.getWorkbenchWindow().getShell().addShellListener((ShellListener)this.focusChangedHandler);
        if (input instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)input).getFile();
            this.projectName = file.getProject().getName();
            Metamodel metamodel = MetamodelManager.getMetamodel((String)this.projectName);
            String name = file.getName().substring(0, file.getName().indexOf(46));
            String packAndSrc = EclipseFilePathService.removeFileNameFromPath((String)file.getProjectRelativePath().toOSString());
            String pack = EclipseFilePathService.removeSrcFolderPartFromPath((String)packAndSrc, (String)this.projectName);
            VIRoot root = VIRootManager.getVIRoot((Metamodel)metamodel);
            if (root == null) {
                root = VIRootManager.getVIRoot((Metamodel)metamodel);
            }
            try {
                this.virtualInterface = root.getVirtualInterface(EclipseFilePathService.convertSlashesToDots((String)pack), name);
                this.readOnly = this.virtualInterface == null ? true : this.virtualInterface.isReadOnly();
            }
            catch (LoadException e) {
                WebServiceCorePlugin.logError((Throwable)e, this.getClass());
            }
        }
        TypeAnalyser.clearAnalysedTypes();
    }

    public void fireEditorChanged() {
        this.dirty = true;
        this.firePropertyChange(257);
        this.refreshAllPages();
    }

    public void exchangeFaults(Fault faultOld, Fault faultNew) {
        this.paneHandler.exchangeFaults(faultOld, faultNew);
        if (this.outlinePage != null) {
            this.outlinePage.exchangeFaults(faultOld, faultNew);
        }
        this.updateUI((DevelopmentObject)faultNew);
    }

    public void updateUI(DevelopmentObject object) {
        if (this.outlinePage != null) {
            this.outlinePage.updateTreeViewer();
        }
        this.typesPage.getTreeSelectorEditorComponent().refreshTree();
        this.typesPage.getTreeSelectorEditorComponent().getTreeSelector().getTreeViewer().refresh();
        this.typesPage.getTreeSelectorEditorComponent().getTreeSelector().getTreeViewer().expandToLevel(3);
        this.mappingPage.getTreeSelectorEditorComponent().refreshTree();
        this.mappingPage.getTreeSelectorEditorComponent().getTreeSelector().getTreeViewer().refresh();
        this.mappingPage.getTreeSelectorEditorComponent().getTreeSelector().getTreeViewer().expandToLevel(2);
        this.updateUI();
    }

    public void deleteMethod(Function function) {
        if (this.outlinePage != null) {
            this.outlinePage.deleteMethod(function);
        }
    }

    public void addMethod(Function function) {
        if (this.outlinePage != null) {
            this.outlinePage.addMethod(function);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        if (this.virtualInterface == null) {
            return;
        }
        if (this.readOnly != this.virtualInterface.isReadOnly()) {
            this.readOnly = !this.readOnly;
            GenericPaneBuilder.refreshSensitivity(this.virtualInterface);
            this.typesPage.getTreeSelectorEditorComponent().getTreeSelector().updateButtonState();
        }
        this.updateUI(null);
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof GenericWsEditorActionContributor) {
            if (this.virtualInterface.isReadOnly()) {
                ((GenericWsEditorActionContributor)contributor).setReadOnlyText("Read Only");
            } else {
                ((GenericWsEditorActionContributor)contributor).setReadOnlyText("Writable");
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = ViMultiPageEditor.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage)) {
            this.outlinePage = new VepOutlinePage((IWorkbenchPart)this, new ViLeanOutlineTreeModel(this.virtualInterface).getTreeModelForOutline());
            this.outlinePage.addSelectionChangedListener(new SelectionChangedListener());
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }

    private void doSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        Iterator iter = ((IStructuredSelection)selection).iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
            Object data = node.getUserObject();
            if (!(data instanceof DevelopmentObject)) continue;
            this.mappingPage.selectionChanged((DevelopmentObject)data);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SelectionChangedListener
    implements ISelectionChangedListener {
        private SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ViMultiPageEditor.this.doSelectionChanged(event);
        }
    }
}

