/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.dialogs;

import com.sap.ide.ws.core.typeinfo.AbstractTypeInfo;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public abstract class WsInfoLabelProvider
extends LabelProvider {
    protected static final Image PKG_ICON = JavaPluginImages.get((String)"org.eclipse.jdt.ui.package_obj.gif");
    public static final int SHOW_TYPE_NAME_ONLY = 16;
    public static final int SHOW_TYPE_CONTAINER_ONLY = 32;
    public static final int SHOW_ROOT_POSTFIX = 8;
    private int fFlag;

    public WsInfoLabelProvider(int flag) {
        this.fFlag = flag;
    }

    public String getText(Object element) {
        if (element instanceof TypeInfo) {
            TypeInfo typeRef = (TypeInfo)element;
            StringBuffer buf = new StringBuffer();
            if (this.isSet(16)) {
                buf.append(typeRef.getTypeName());
            } else if (this.isSet(32)) {
                String containerName = typeRef.getTypeContainerName();
                buf.append(this.getPackageName(containerName));
            }
            if (this.isSet(8)) {
                buf.append(JavaUIMessages.getString((String)"TypeInfoLabelProvider.dash"));
                buf.append(typeRef.getPackageFragmentRootPath().toString());
            }
            return buf.toString();
        }
        if (element instanceof AbstractTypeInfo) {
            AbstractTypeInfo typeRef = (AbstractTypeInfo)element;
            StringBuffer buf = new StringBuffer();
            if (this.isSet(16)) {
                buf.append(typeRef.getTypeName());
            } else if (this.isSet(32)) {
                String packName = typeRef.getTypePackageName();
                if (packName == null || packName.length() < 1) {
                    packName = "( default package )";
                }
                buf.append(packName);
            }
            if (this.isSet(8)) {
                buf.append(JavaUIMessages.getString((String)"TypeInfoLabelProvider.dash"));
                buf.append(typeRef.getPackageFragmentRootPath().toString());
            }
            return buf.toString();
        }
        return super.getText(element);
    }

    private String getPackageName(String packName) {
        if (packName.length() == 0) {
            return JavaUIMessages.getString((String)"TypeInfoLabelProvider.default_package");
        }
        return packName;
    }

    public Image getImage(Object element) {
        return super.getImage(element);
    }

    protected boolean isSet(int flag) {
        return (this.fFlag & flag) != 0;
    }
}

