/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.builder.modules;

import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.vi.EndpointReference;
import com.sap.ide.metamodel.vi.Type;
import com.sap.ide.metamodel.vi.VIRoot;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.metamodel.vi.plugin.VIRootManager;
import com.sap.ide.vi.check.ViCheck;
import com.sap.ide.vi.check.result.TaskManager;
import com.sap.ide.vi.endpoints.EndpointAnalyser;
import com.sap.ide.vi.types.TypeAnalyser;
import com.sap.ide.ws.core.builder.ModularBuilderModuleI;
import com.sap.ide.ws.core.builder.result.BuildResult;
import com.sap.ide.ws.core.services.filter.WebServiceFilterFactory;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;

public class ViEndpointCheckModule
implements ModularBuilderModuleI {
    private static ViEndpointCheckModule mInstance;
    public static final String BUILDER_ID_VI = "com.sap.ide.vi.viCheck";
    private static Hashtable visToBeChecked;

    private ViEndpointCheckModule() {
    }

    public static ViEndpointCheckModule getInstance() {
        if (mInstance == null) {
            mInstance = new ViEndpointCheckModule();
        }
        return mInstance;
    }

    public void check(int kind, IProject project, IResourceDelta delta, BuildResult result) {
        if (project == null || !project.exists() || !project.isOpen()) {
            return;
        }
        VirtualInterface[] vis = null;
        vis = kind == 6 ? this.getAllVisInProject(project.getName()) : (kind == 9 ? this.getRelevantVisInProject(delta, project) : ViEndpointCheckModule.getVisToBeCheckedInProject(project.getName()));
        int i = 0;
        while (i < vis.length) {
            TaskManager.deleteMarkers((VirtualInterface)vis[i]);
            ++i;
        }
        this.checkVis(project.getName(), vis);
        ViEndpointCheckModule.deleteVisToBeCheckedInProject(project.getName());
    }

    private VirtualInterface[] getAllVisInProject(String projectName) {
        VIRoot root = VIRootManager.getVIRoot((String)projectName);
        VirtualInterface[] vis = null;
        try {
            vis = root.getVirtualInterfaces();
        }
        catch (LoadException e) {
            // empty catch block
        }
        return vis;
    }

    public void checkVis(String projectName, VirtualInterface[] vis) {
        TypeAnalyser.clearAnalysedTypes();
        ViCheck check = new ViCheck();
        int i = 0;
        while (i < vis.length) {
            check.checkVi(projectName, vis[i], EndpointAnalyser.getITypeByEndpoint((EndpointReference)vis[i].getEndpointReference(), (String)projectName));
            ++i;
        }
    }

    public void applyCheckResult(BuildResult checkResult) {
    }

    public String getModuleId() {
        return BUILDER_ID_VI;
    }

    public boolean isProjectRelevant(IProject project) {
        return WebServiceFilterFactory.isJavaDcOrEjbModuleDcProject((IProject)project) || WebServiceFilterFactory.isJavaOrEjbModuleProject((IProject)project);
    }

    public void updateOpenEditorIcons(BuildResult result, IProject project) {
    }

    public static void setViToBeChecked(String projectName, VirtualInterface vi) {
        Vector<VirtualInterface> viVector = (Vector<VirtualInterface>)visToBeChecked.get(projectName);
        if (viVector == null) {
            viVector = new Vector<VirtualInterface>();
            visToBeChecked.put(projectName, viVector);
        }
        if (!viVector.contains(vi)) {
            viVector.add(vi);
        }
    }

    private VirtualInterface[] getRelevantVisInProject(IResourceDelta delta, IProject project) {
        Vector<VirtualInterface> results = new Vector<VirtualInterface>();
        if (delta == null) {
            return new VirtualInterface[0];
        }
        Vector javaDeltaFiles = this.getAllDeltaJavaFiles(delta);
        VirtualInterface[] vis = this.getAllVisInProject(project.getName());
        if (javaDeltaFiles.size() == 0) {
            return vis;
        }
        int i = 0;
        while (i < vis.length) {
            String endPointName = EndpointAnalyser.getEndPointName((EndpointReference)vis[i].getEndpointReference());
            Type[] types = vis[i].getTypes();
            int j = 0;
            while (j < javaDeltaFiles.size()) {
                String javaDeltaFile = (String)javaDeltaFiles.elementAt(j);
                boolean add = false;
                if (endPointName != null && endPointName.endsWith(javaDeltaFile)) {
                    add = true;
                } else {
                    int k = 0;
                    while (!add && k < types.length) {
                        if (types[k].getName().endsWith(javaDeltaFile)) {
                            add = true;
                        }
                        ++k;
                    }
                }
                if (add) {
                    results.add(vis[i]);
                }
                ++j;
            }
            ++i;
        }
        return results.toArray(new VirtualInterface[results.size()]);
    }

    private Vector getAllDeltaJavaFiles(IResourceDelta delta) {
        Vector<String> results = new Vector<String>();
        if (delta == null) {
            return results;
        }
        IPath fp = delta.getFullPath();
        String ext = delta.getFullPath().getFileExtension();
        if (ext != null && ext.equals("java")) {
            results.add(delta.getFullPath().removeFileExtension().lastSegment().toString());
        }
        IResourceDelta[] subDeltas = delta.getAffectedChildren();
        int i = 0;
        while (i < subDeltas.length) {
            results.addAll(this.getAllDeltaJavaFiles(subDeltas[i]));
            ++i;
        }
        return results;
    }

    private static VirtualInterface[] getVisToBeCheckedInProject(String projectName) {
        Vector tempVector = (Vector)visToBeChecked.get(projectName);
        if (tempVector == null) {
            return new VirtualInterface[0];
        }
        return tempVector.toArray(new VirtualInterface[tempVector.size()]);
    }

    private static void deleteVisToBeCheckedInProject(String projectName) {
        visToBeChecked.remove(projectName);
    }

    static {
        visToBeChecked = new Hashtable();
    }
}

