/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi;

import com.sap.ide.vi.endpoints.ClassITypeGetter;
import com.sap.ide.vi.endpoints.EjbITypeGetter;
import com.sap.ide.vi.endpoints.EndpointAnalyser;
import com.sap.ide.vi.endpoints.EndpointReference;
import com.sap.ide.vi.endpoints.ITypeGetter;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class VIPlugin
extends AbstractUIPlugin
implements ISelectionChangedListener {
    private static VIPlugin pluginInstance;
    private ResourceBundle resourceBundle;

    public VIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        pluginInstance = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("com.sap.ide.eclipse.webservices.WebservicesPluginResources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
            WebServiceCorePlugin.logErrorSimulated((Throwable)x);
        }
    }

    public static VIPlugin getDefault() {
        return pluginInstance;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        System.out.println("Selection changed");
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = VIPlugin.getInstance().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static VIPlugin getInstance() {
        return pluginInstance;
    }

    public static void setInstance(VIPlugin instance) {
        pluginInstance = instance;
    }

    public void startup() throws CoreException {
        super.startup();
        EndpointAnalyser.registerEndPointType((String)EndpointReference.EJB_TYPE, (ITypeGetter)new EjbITypeGetter());
        EndpointAnalyser.registerEndPointType((String)EndpointReference.CLASS_TYPE, (ITypeGetter)new ClassITypeGetter());
        EndpointAnalyser.registerEndPointType((String)EndpointReference.PAR_TYPE, (ITypeGetter)new ClassITypeGetter());
    }
}

