/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards;

import com.sap.ide.webdynpro.controllereditor.IDisplayErrorListener;
import com.sap.ide.webdynpro.controllereditor.helpers.ExtractMethodParameterModel;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import com.tssap.util.ui.reuse.table.impl.TableContentProvider;
import com.tssap.util.ui.reuse.table.impl.TableLabelProvider;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TypeResolvingPage
extends WizardPage
implements IDisplayErrorListener {
    private IGridLayoutPane m_glp;
    private Table table;
    private TableViewer tableViewer;
    private Map resolveTypes;
    private Map inputMap;
    private ExtractMethodParameterModel[] inputModel;

    public TypeResolvingPage(String pageName, Map input) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription("Resolve the Data types listed");
        this.inputMap = input;
    }

    public TypeResolvingPage(String pageName, ExtractMethodParameterModel[] inputModel) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription("Resolve the Data types listed");
        this.inputModel = inputModel;
    }

    public void createControl(Composite parent) {
        this.m_glp = PaneFactory.createGridLayoutPane((Composite)parent, (int)0);
        GridLayout layout = new GridLayout(1, false);
        this.m_glp.getComposite().setLayout((Layout)layout);
        this.tableViewer = this.m_glp.addTableViewer(false);
        this.table = this.tableViewer.getTable();
        GridData gridData = new GridData(1808);
        gridData.heightHint = 153;
        gridData.widthHint = 100;
        this.table.setLayoutData((Object)gridData);
        this.tableViewer.setContentProvider((IContentProvider)new TypeResolvingContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TypeResolvingLableProvider());
        this.createColumns();
        this.setUpCellEditors();
        this.tableViewer.setCellModifier((ICellModifier)new TypeResolvingCellModifier(this.tableViewer, this.table));
        this.tableViewer.setColumnProperties(new String[]{"TYPE NAME", "RESOLVE AS"});
        this.tableViewer.setInput((Object)this.inputModel);
        this.setControl((Control)this.m_glp.getComposite());
    }

    private void createColumns() {
        this.table.setHeaderVisible(true);
        this.table.removeAll();
        TableColumn typeName = new TableColumn(this.table, 0, 0);
        typeName.setResizable(true);
        typeName.setText("TYPE NAME");
        typeName.setWidth(175);
        TableColumn resolveAs = new TableColumn(this.table, 0, 1);
        resolveAs.setResizable(true);
        resolveAs.setText("RESOLVE AS");
        resolveAs.setWidth(175);
    }

    private void setUpCellEditors() {
        CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)this.table), new ComboBoxCellEditor((Composite)this.table, new String[0])};
        this.tableViewer.setCellEditors(editors);
    }

    public Map getResolvedTypes() {
        HashMap<String, String> typesAfterResolution = new HashMap<String, String>();
        TableItem[] tableElements = this.table.getItems();
        if (tableElements != null) {
            ExtractMethodParameterModel modelElement = null;
            int i = 0;
            while (i < tableElements.length) {
                modelElement = (ExtractMethodParameterModel)tableElements[i].getData();
                if (modelElement.getDeclaredType() == null) {
                    modelElement.setDeclaredType(0);
                }
                typesAfterResolution.put(modelElement.getParamDisplayName(), modelElement.getDeclaredType());
                ++i;
            }
        }
        return typesAfterResolution;
    }

    public class TypeResolvingCellModifier
    implements ICellModifier {
        private TableViewer tableViewer;
        private Table table;

        public TypeResolvingCellModifier(TableViewer tViewer, Table table) {
            this.tableViewer = tViewer;
            this.table = table;
        }

        public boolean canModify(Object element, String tableHeader) {
            if (tableHeader.equals("RESOLVE AS")) {
                CellEditor[] editors = this.tableViewer.getCellEditors();
                if (editors[1] instanceof ComboBoxCellEditor) {
                    ExtractMethodParameterModel model = (ExtractMethodParameterModel)element;
                    ComboBoxCellEditor comboBox = (ComboBoxCellEditor)editors[1];
                    comboBox.setItems(model.getResolvedTypes());
                    editors[1] = comboBox;
                    this.tableViewer.setCellEditors(editors);
                    this.tableViewer.refresh();
                } else {
                    System.out.println("The cell editor is " + editors[1].toString());
                }
                return true;
            }
            return false;
        }

        public Object getValue(Object element, String tableHeader) {
            ExtractMethodParameterModel model = (ExtractMethodParameterModel)element;
            return model.getValue(tableHeader);
        }

        public void modify(Object element, String tableHeader, Object newValue) {
            TableItem item = (TableItem)element;
            ExtractMethodParameterModel model = (ExtractMethodParameterModel)item.getData();
            if (tableHeader.equals("RESOLVE AS")) {
                int index = (Integer)newValue;
                model.setDeclaredType(index);
            }
            this.tableViewer.refresh();
        }
    }

    public class TypeResolvingLableProvider
    extends TableLabelProvider {
        public String getColumnText(Object element, int col) {
            ExtractMethodParameterModel data = (ExtractMethodParameterModel)element;
            if (data != null) {
                switch (col) {
                    case 0: {
                        return data.getParamDisplayName();
                    }
                    case 1: {
                        if (data.getDeclaredType() == null) {
                            return data.getResolvedTypes()[0];
                        }
                        return data.getDeclaredType();
                    }
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int col) {
            return super.getImage(element);
        }
    }

    public class TypeResolvingContentProvider
    extends TableContentProvider {
        public Object[] getElements(Object input) {
            Object[] tabData = (ExtractMethodParameterModel[])input;
            return tabData;
        }
    }
}

