/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards;

import com.sap.ide.webdynpro.controllereditor.IDisplayErrorListener;
import com.sap.ide.webdynpro.controllereditor.helpers.ExtractMethodModel;
import com.sap.ide.webdynpro.controllereditor.helpers.ExtractMethodParameterModel;
import com.sap.ide.webdynpro.controllereditor.wizards.MethodExtractCellModifier;
import com.sap.ide.webdynpro.controllereditor.wizards.MethodExtractTableContentProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.MethodExtractTableLabelProvider;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class MethodExtractionPage
extends WizardPage
implements IDisplayErrorListener {
    private IGridLayoutPane m_glp;
    private Table table;
    private TableViewer tableViewer;
    private Button btSelectAll;
    private Button btDeSelectAll;
    private Button btResolve;
    private ExtractMethodModel[] extractModel;
    private Map extractionDetails;
    private Map FQNamesMap;
    public static final String STATUS = "Status";
    public static final String METHOD_NAME = "Method Name";
    public static final String EXTRACT_TYPE = "Extract As ";
    public static final String RESOLVE = "Resolve";

    public MethodExtractionPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription("Select the methods to be extracted");
    }

    public MethodExtractionPage(String pageName, Map methods) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription("Select the methods to be extracted");
        this.initializeModel(methods);
    }

    public MethodExtractionPage(String pageName, Map methods, String editorContents) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription("Select the methods to be extracted");
        this.initializeModel(methods, editorContents);
    }

    private void initializeModel(Map methods) {
        if (methods != null) {
            ArrayList<ExtractMethodModel> modelList = new ArrayList<ExtractMethodModel>();
            Set keys = methods.keySet();
            Iterator it = keys.iterator();
            IDOMMethod method = null;
            String methodName = null;
            boolean count = false;
            boolean hasParams = false;
            boolean hasRetType = false;
            Object resolveTypes = null;
            ExtractMethodModel tmpModel = null;
            while (it.hasNext()) {
                methodName = (String)it.next();
                method = (IDOMMethod)methods.get(methodName);
                if (!Flags.isPublic((int)method.getFlags()) || Flags.isStatic((int)method.getFlags()) || Flags.isFinal((int)method.getFlags())) continue;
                HashMap<String, String> parameters = new HashMap<String, String>();
                String[] paramNames = method.getParameterNames();
                String[] paramTypes = method.getParameterTypes();
                if (paramTypes != null) {
                    int i = 0;
                    while (i < paramTypes.length) {
                        parameters.put(paramNames[i], paramTypes[i]);
                        ++i;
                    }
                }
                tmpModel = new ExtractMethodModel(method.getName(), method.getReturnType(), parameters);
                modelList.add(tmpModel);
            }
            this.extractModel = new ExtractMethodModel[modelList.size()];
            this.extractModel = modelList.toArray(this.extractModel);
            System.out.println("Numbre of methods int he table " + this.extractModel.length);
        }
    }

    private void initializeModel(Map methods, String editorContents) {
        if (methods != null) {
            this.extractModel = new ExtractMethodModel[methods.size()];
            Set keys = methods.keySet();
            Iterator it = keys.iterator();
            IDOMMethod method = null;
            String methodName = null;
            int count = 0;
            boolean hasParams = false;
            boolean hasRetType = false;
            Object resolveTypes = null;
            while (it.hasNext()) {
                methodName = (String)it.next();
                method = (IDOMMethod)methods.get(methodName);
                HashMap<String, String> parameters = new HashMap<String, String>();
                String[] paramNames = method.getParameterNames();
                String[] paramTypes = method.getParameterTypes();
                if (paramTypes != null) {
                    int i = 0;
                    while (i < paramTypes.length) {
                        parameters.put(paramNames[i], paramTypes[i]);
                        ++i;
                    }
                }
                this.extractModel[count++] = new ExtractMethodModel(method.getName(), method.getReturnType(), parameters);
            }
        }
    }

    public void createControl(Composite parent) {
        this.m_glp = PaneFactory.createGridLayoutPane((Composite)parent, (int)0);
        GridLayout layout = new GridLayout(1, false);
        this.m_glp.getComposite().setLayout((Layout)layout);
        this.tableViewer = this.m_glp.addTableViewer(false);
        this.table = this.tableViewer.getTable();
        GridData gridData = new GridData(1808);
        gridData.heightHint = 153;
        gridData.widthHint = 100;
        this.table.setLayoutData((Object)gridData);
        this.tableViewer.setContentProvider((IContentProvider)new MethodExtractTableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MethodExtractTableLabelProvider(this.tableViewer));
        this.createColumns();
        this.setUpCellEditors();
        this.tableViewer.setCellModifier((ICellModifier)new MethodExtractCellModifier(this.tableViewer, this.table, this));
        this.tableViewer.setColumnProperties(new String[]{STATUS, METHOD_NAME, EXTRACT_TYPE});
        this.tableViewer.setInput((Object)this.extractModel);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItems = MethodExtractionPage.this.table.getSelection();
                if (tableItems != null && tableItems.length > 0) {
                    ExtractMethodModel extractMethodModel = (ExtractMethodModel)tableItems[0].getData();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        IGridLayoutPane gPane = this.m_glp.addGridLayoutPane(0);
        gPane.getComposite().setLayout((Layout)new GridLayout(3, false));
        this.btSelectAll = gPane.addPushButton("Select All");
        this.btDeSelectAll = gPane.addPushButton("DeSelect All");
        this.btSelectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableElements = MethodExtractionPage.this.table.getItems();
                if (tableElements != null) {
                    ExtractMethodModel modelElement = null;
                    int i = 0;
                    while (i < tableElements.length) {
                        modelElement = (ExtractMethodModel)tableElements[i].getData();
                        modelElement.setSelected(true);
                        ++i;
                    }
                }
                MethodExtractionPage.this.checkForErrors();
                MethodExtractionPage.this.tableViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btDeSelectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableElements = MethodExtractionPage.this.table.getItems();
                if (tableElements != null) {
                    ExtractMethodModel modelElement = null;
                    int i = 0;
                    while (i < tableElements.length) {
                        modelElement = (ExtractMethodModel)tableElements[i].getData();
                        modelElement.setSelected(false);
                        ++i;
                    }
                }
                MethodExtractionPage.this.checkForErrors();
                MethodExtractionPage.this.tableViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl((Control)this.m_glp.getComposite());
    }

    private boolean checkForTypeResolution() {
        TableItem[] tableElements = this.table.getItems();
        if (tableElements != null) {
            ExtractMethodModel method = null;
            int i = 0;
            while (i < tableElements.length) {
                method = (ExtractMethodModel)tableElements[i].getData();
                if (!method.isResolved() && method.canTypesBeResolved()) {
                    this.setErrorMessage("The types for the method \"" + method.getMethodName() + "\" should be resolved");
                    return true;
                }
                ++i;
            }
        }
        this.setErrorMessage(null);
        return false;
    }

    private boolean checkForErrors() {
        TableItem[] tableElements = this.table.getItems();
        if (tableElements != null) {
            ExtractMethodModel method = null;
            int i = 0;
            while (i < tableElements.length) {
                method = (ExtractMethodModel)tableElements[i].getData();
                if (method != null && method.isSelected() && method.hasReturnType() && method.getExtractionType().equals("Event Handler")) {
                    this.setErrorMessage("The return type for the method \"" + method.getMethodName() + "\" should be `void` to extract it as an Event Handler");
                    return true;
                }
                ++i;
            }
        }
        this.setErrorMessage(null);
        return false;
    }

    protected void createColumns() {
        this.table.setHeaderVisible(true);
        this.table.removeAll();
        TableColumn statusColumn = new TableColumn(this.table, 0, 0);
        statusColumn.setResizable(true);
        statusColumn.setText(STATUS);
        statusColumn.setWidth(60);
        TableColumn nameColumn = new TableColumn(this.table, 0, 1);
        nameColumn.setResizable(true);
        nameColumn.setText(METHOD_NAME);
        nameColumn.setWidth(175);
        TableColumn typeColumn = new TableColumn(this.table, 0, 2);
        typeColumn.setResizable(true);
        typeColumn.setText(EXTRACT_TYPE);
        typeColumn.setWidth(175);
    }

    private void setUpCellEditors() {
        CellEditor[] editors = new CellEditor[4];
        editors[0] = new CheckboxCellEditor((Composite)this.table);
        editors[1] = new TextCellEditor((Composite)this.table);
        editors[2] = new ComboBoxCellEditor((Composite)this.table, ExtractMethodModel.extractionTypes, 8);
        this.tableViewer.setCellEditors(editors);
    }

    public String[] getMethods() {
        TableItem[] tableElements = this.table.getItems();
        ArrayList<String> methodNameList = new ArrayList<String>();
        String[] methodNames = null;
        this.extractionDetails = new HashMap();
        this.FQNamesMap = new HashMap();
        if (tableElements != null) {
            ExtractMethodModel modelElement = null;
            HashMap<String, String> typesMap = null;
            ExtractMethodParameterModel[] params = null;
            int i = 0;
            while (i < tableElements.length) {
                typesMap = new HashMap<String, String>();
                modelElement = (ExtractMethodModel)tableElements[i].getData();
                if (modelElement.isSelected()) {
                    methodNameList.add(modelElement.getMethodName());
                    this.extractionDetails.put(modelElement.getMethodName(), modelElement.getExtractionType());
                    if (modelElement.hasReturnType()) {
                        typesMap.put(modelElement.getReturnType().getParamDisplayName(), modelElement.getReturnType().getDeclaredType());
                    }
                    if ((params = modelElement.getParameters()) != null) {
                        int j = 0;
                        while (j < params.length) {
                            typesMap.put(params[j].getParamDisplayName(), params[j].getDeclaredType());
                            ++j;
                        }
                    }
                    this.FQNamesMap.put(modelElement.getMethodName(), typesMap);
                }
                ++i;
            }
        }
        if (methodNameList.size() > 0) {
            methodNames = new String[methodNameList.size()];
            methodNames = methodNameList.toArray(methodNames);
        }
        return methodNames;
    }

    public Map getExtractionDetails() {
        return this.extractionDetails;
    }

    public Map getFullyQualifiedNames() {
        return this.FQNamesMap;
    }

    public void setErrorMessage(String errorMessage) {
        this.setPageComplete(errorMessage == null);
        super.setErrorMessage(errorMessage);
    }
}

