/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards;

import com.sap.ide.webdynpro.controllereditor.helpers.ExtractMethodModel;
import com.sap.ide.webdynpro.controllereditor.wizards.MethodExtractionPage;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class MethodExtractCellModifier
implements ICellModifier {
    private TableViewer tableViewer;
    private Table table;
    private WizardPage wizardPage;

    public MethodExtractCellModifier(TableViewer tViewer, Table table, MethodExtractionPage page) {
        this.tableViewer = tViewer;
        this.table = table;
        this.wizardPage = page;
    }

    public boolean canModify(Object element, String tableHeader) {
        return tableHeader.equals("Status") || tableHeader.equals("Extract As ");
    }

    public Object getValue(Object element, String tableHeader) {
        ExtractMethodModel model = (ExtractMethodModel)element;
        return model.getValue(tableHeader);
    }

    public void modify(Object element, String tableHeader, Object newValue) {
        TableItem item = (TableItem)element;
        ExtractMethodModel method = (ExtractMethodModel)item.getData();
        if (tableHeader.equals("Status")) {
            method.setSelected((Boolean)newValue == false);
            this.checkForErrors();
        } else if (tableHeader.equals("Extract As ")) {
            int index = (Integer)newValue;
            String extType = ExtractMethodModel.extractionTypes[index];
            if (method.hasReturnType() && extType.equals("Event Handler")) {
                this.wizardPage.setErrorMessage("The return type for the method \"" + method.getMethodName() + "\" should be `void` to extract it as an Event Handler");
            }
            method.setExtractType(index);
        }
        this.checkForErrors();
        this.tableViewer.refresh();
    }

    private boolean checkForErrors() {
        TableItem[] tableElements = this.table.getItems();
        if (tableElements != null) {
            ExtractMethodModel method = null;
            int i = 0;
            while (i < tableElements.length) {
                method = (ExtractMethodModel)tableElements[i].getData();
                if (method != null && method.isSelected() && method.hasReturnType() && method.getExtractionType().equals("Event Handler")) {
                    this.wizardPage.setErrorMessage("The return type for the method \"" + method.getMethodName() + "\" should be `void` to extract it as an Event Handler");
                    return true;
                }
                ++i;
            }
        }
        this.wizardPage.setErrorMessage(null);
        return false;
    }
}

