/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.services;

import com.sap.ide.webdynpro.controllereditor.Plugin;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMImport;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.AllTypesCache;
import org.eclipse.jdt.internal.corext.util.TypeInfo;

public class TypeResolver {
    private static Map dataTypes;
    private static String editorContents;
    private static IDOMCompilationUnit DOMUnit;
    private static Map importMap;
    static /* synthetic */ Class class$com$sap$ide$webdynpro$controllereditor$services$TypeResolver;

    public TypeResolver(Map types, String contents) {
        dataTypes = types;
        editorContents = contents;
    }

    public static Map resolveTypesForMethods(String[] selectedMethods, Map freeCodingMethods, String contents) {
        HashMap<String, Map> resolvedTypesForMethods = null;
        if (selectedMethods != null && freeCodingMethods != null && contents != null) {
            editorContents = contents;
            resolvedTypesForMethods = new HashMap<String, Map>();
            Object methodName = null;
            IDOMMethod method = null;
            Map typesMap = null;
            int i = 0;
            while (i < selectedMethods.length) {
                method = (IDOMMethod)freeCodingMethods.get(selectedMethods[i]);
                typesMap = TypeResolver.getTypesForMethod(method);
                typesMap = TypeResolver.resolveDataTypes(typesMap);
                resolvedTypesForMethods.put(selectedMethods[i], typesMap);
                ++i;
            }
        }
        return resolvedTypesForMethods;
    }

    private static Map getTypesForMethod(IDOMMethod method) {
        HashMap<String, String> typesMap = null;
        if (method != null) {
            typesMap = new HashMap<String, String>();
            String[] paramNames = method.getParameterNames();
            String[] paramTypes = method.getParameterTypes();
            if (paramTypes != null) {
                int i = 0;
                while (i < paramTypes.length) {
                    typesMap.put(paramNames[i], paramTypes[i]);
                    ++i;
                }
            }
            typesMap.put(method.getReturnType(), method.getReturnType());
        }
        return typesMap;
    }

    private static Map resolveDataTypes(Map types) {
        HashMap<String, String> resolvedTypes = null;
        if (types != null) {
            System.out.println("The input for TypeResolver " + types);
            resolvedTypes = new HashMap<String, String>();
            dataTypes = types;
            TypeResolver.getDOMCompilationUnit();
            String[] importStmts = TypeResolver.getAllImportStmts();
            Set keys = types.keySet();
            Iterator it = keys.iterator();
            String typeName = null;
            String dataType = null;
            String[] resolvedValues = null;
            String fullyQualifiedName = null;
            while (it.hasNext()) {
                typeName = (String)it.next();
                dataType = TypeResolver.getOnlyType(typeName = (String)types.get(typeName));
                resolvedValues = TypeResolver.getFullyQualifiedNames(dataType);
                fullyQualifiedName = resolvedValues != null && resolvedValues.length == 1 ? resolvedValues[0] : TypeResolver.resolveFQN(resolvedValues, importStmts);
                if (fullyQualifiedName == null) {
                    fullyQualifiedName = dataType;
                }
                resolvedTypes.put(dataType, fullyQualifiedName);
                System.out.println("Resolved type " + dataType + " as " + fullyQualifiedName);
            }
        }
        return resolvedTypes;
    }

    private static void getDOMCompilationUnit() {
        DOMFactory factory = new DOMFactory();
        DOMUnit = editorContents != null ? factory.createCompilationUnit(editorContents, "SampleCode") : factory.createCompilationUnit();
    }

    private static String[] getAllImportStmts() {
        ArrayList<String> impList = new ArrayList<String>();
        String[] imports = null;
        importMap = new HashMap();
        if (DOMUnit != null) {
            Enumeration children = DOMUnit.getChildren();
            IDOMNode importNode = null;
            String importName = null;
            while (children.hasMoreElements()) {
                importNode = (IDOMNode)children.nextElement();
                if (importNode.getNodeType() != 3) continue;
                importName = ((IDOMImport)importNode).getName();
                importMap.put(importName, importNode);
                impList.add(importName);
            }
            if (impList.size() > 0) {
                imports = new String[impList.size()];
                imports = impList.toArray(imports);
            }
        }
        return imports;
    }

    private static String getOnlyType(String name) {
        String type = null;
        type = name != null && name.indexOf("[]") != -1 ? name.substring(0, name.indexOf("[]")) : name;
        return type;
    }

    private static String[] getFullyQualifiedNames(String typeName) {
        TypeInfo[] typeInfo = null;
        String[] FQNames = null;
        try {
            IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
            typeInfo = AllTypesCache.getTypesForName((String)typeName, (IJavaSearchScope)scope, null);
            if (typeInfo != null && typeInfo.length > 0) {
                FQNames = new String[typeInfo.length];
                int i = 0;
                while (i < typeInfo.length) {
                    FQNames[i] = typeInfo[i].getFullyQualifiedName();
                    ++i;
                }
            } else {
                FQNames = new String[]{typeName};
            }
        }
        catch (JavaModelException e) {
            Plugin.internalError((Class)(class$com$sap$ide$webdynpro$controllereditor$services$TypeResolver == null ? (class$com$sap$ide$webdynpro$controllereditor$services$TypeResolver = TypeResolver.class$("com.sap.ide.webdynpro.controllereditor.services.TypeResolver")) : class$com$sap$ide$webdynpro$controllereditor$services$TypeResolver), (String)"getFullyQualifiedNames(String typeName)", (String)e.getMessage(), (Throwable)e, (boolean)true);
        }
        if (FQNames != null) {
            int i = 0;
            while (i < FQNames.length) {
                System.out.println("FQNames " + i + " " + FQNames[i]);
                ++i;
            }
        } else {
            System.out.println("FQNames is null");
        }
        return FQNames;
    }

    private static String resolveFQN(String[] resolvedValues, String[] importStmts) {
        if (resolvedValues != null && importStmts != null) {
            IDOMImport importNode = null;
            String FQName = null;
            int i = 0;
            while (i < resolvedValues.length) {
                int j = 0;
                while (j < importStmts.length) {
                    if (resolvedValues[i].equals(importStmts[j])) {
                        return resolvedValues[i];
                    }
                    ++j;
                }
                FQName = resolvedValues[i].substring(0, resolvedValues[i].lastIndexOf(46));
                int n = 0;
                while (n < importStmts.length) {
                    importNode = (IDOMImport)importMap.get(importStmts[n]);
                    if (importNode.isOnDemand() && importNode.getName().indexOf(FQName) != -1) {
                        return resolvedValues[i];
                    }
                    ++n;
                }
                ++i;
            }
        } else {
            System.out.println("No processing in resolveFQN");
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DOMUnit = null;
    }
}

