/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.services;

import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.EventHandler;
import com.sap.ide.metamodel.webdynpro.base.Method;
import com.sap.ide.metamodel.webdynpro.base.ParameterizedFeature;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.enum.VisibilityEnum;
import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.controllereditor.exceptions.MethodExtractionException;
import com.sap.ide.webdynpro.controllereditor.services.DataTypeProvider;
import com.sap.ide.webdynpro.generation.eclipse.GenerationEclipse;
import com.sap.ide.webdynpro.generation.naming.NamingService;
import com.sap.ide.webdynpro.service.controllereditor.method.MethodService;
import com.sap.ide.webdynpro.service.controllereditor.parameter.ParameterService;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;

public class RefactoringService {
    private static String[] DOMMethodNames;
    private static final String UCA_BEGIN_MARKER = "//@@begin";
    private static final String UCA_END_MARKER = "//@@end";
    private static String comment;
    static /* synthetic */ Class class$com$sap$ide$webdynpro$controllereditor$services$RefactoringService;

    private static IDOMCompilationUnit getDOMCompilationUnit(String contents) {
        IDOMCompilationUnit DOMUnit = null;
        DOMFactory factory = new DOMFactory();
        DOMUnit = contents != null ? factory.createCompilationUnit(contents, "SampleCode") : factory.createCompilationUnit();
        return DOMUnit;
    }

    private static Map getMethodsFromImplementation(IDOMCompilationUnit DOMUnit) throws MethodExtractionException {
        HashMap<String, IDOMMethod> methodsMap = new HashMap<String, IDOMMethod>();
        ArrayList<String> methodList = new ArrayList<String>();
        if (DOMUnit != null) {
            int type = 0;
            Enumeration children = DOMUnit.getChildren();
            IDOMNode node = null;
            while (children.hasMoreElements()) {
                node = (IDOMNode)children.nextElement();
                if (node.getNodeType() != 4) continue;
                Enumeration enumeration = node.getChildren();
                IDOMNode methodNode = null;
                while (enumeration.hasMoreElements()) {
                    methodNode = (IDOMNode)enumeration.nextElement();
                    type = methodNode.getNodeType();
                    if (type != 6) continue;
                    if (methodsMap.containsKey(methodNode.getName())) {
                        throw new MethodExtractionException("Method \"" + methodNode.getName() + "\" is overloaded. \n" + "Overloaded methods are not supported.");
                    }
                    methodsMap.put(methodNode.getName(), (IDOMMethod)methodNode);
                    methodList.add(methodNode.getName());
                    if (!Flags.isPublic((int)((IDOMMethod)methodNode).getFlags())) continue;
                }
            }
        }
        DOMMethodNames = new String[methodList.size()];
        DOMMethodNames = methodList.toArray(DOMMethodNames);
        return methodsMap;
    }

    public static String[] getDOMMethodNames() {
        return DOMMethodNames;
    }

    public static Map findMethodsForRefactoring(String contents) throws MethodExtractionException {
        Map methods = new HashMap();
        if (contents != null && (contents = RefactoringService.parseContentsForMethods(contents)) != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("public class GenerateMethods { \n");
            buffer.append(contents);
            buffer.append("\n }");
            methods = RefactoringService.getMethodsFromImplementation(RefactoringService.getDOMCompilationUnit(buffer.toString()));
        }
        return methods;
    }

    private static String parseContentsForMethods(String contents) throws MethodExtractionException {
        StringBuffer buffer = new StringBuffer();
        if (contents != null && contents.length() > 0) {
            String match = "//@@begin others";
            int index = contents.indexOf(match);
            contents = contents.substring(index);
            int pairCount = 0;
            try {
                BufferedReader in = new BufferedReader(new StringReader(contents));
                String line = null;
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).startsWith(UCA_BEGIN_MARKER)) {
                        ++pairCount;
                        continue;
                    }
                    if (line.startsWith(UCA_END_MARKER)) {
                        if (--pairCount != 0) continue;
                        break;
                    }
                    buffer.append(line).append("\r\n\t");
                }
            }
            catch (IOException e) {
                Plugin.internalError((Class)(class$com$sap$ide$webdynpro$controllereditor$services$RefactoringService == null ? (class$com$sap$ide$webdynpro$controllereditor$services$RefactoringService = RefactoringService.class$("com.sap.ide.webdynpro.controllereditor.services.RefactoringService")) : class$com$sap$ide$webdynpro$controllereditor$services$RefactoringService), (String)"parseContentsForMethods(String contents)", (String)e.getMessage(), (Throwable)e, (boolean)true);
                throw new MethodExtractionException(e.getLocalizedMessage());
            }
        }
        return buffer.toString();
    }

    public static Map getSelectedMethods(String[] selectedMethods, Map diffMethods) {
        HashMap deltaMethods = new HashMap();
        if (selectedMethods != null && diffMethods != null) {
            int i = 0;
            while (i < selectedMethods.length) {
                if (selectedMethods[i] != null && diffMethods.get(selectedMethods[i]) != null) {
                    deltaMethods.put(selectedMethods[i], diffMethods.get(selectedMethods[i]));
                }
                ++i;
            }
        }
        return deltaMethods;
    }

    public static Map removeMethods(Map methodsMap, String[] methodNames) {
        HashMap<String, IDOMMethod> removedMethods = new HashMap<String, IDOMMethod>();
        if (methodsMap != null && methodNames != null) {
            IDOMMethod method = null;
            String methodName = null;
            int i = 0;
            while (i < methodNames.length) {
                methodName = methodNames[i];
                if (methodName != null && (method = (IDOMMethod)methodsMap.get(methodName)) != null) {
                    removedMethods.put(methodName, method);
                    method.remove();
                }
                ++i;
            }
        }
        return removedMethods;
    }

    private static int getEndIndex(String contents) {
        int index = 0;
        if (contents != null && contents.length() > 0) {
            String match = "//@@begin others";
            index = contents.indexOf(match);
            contents = contents.substring(index);
            int pairCount = 0;
            try {
                BufferedReader in = new BufferedReader(new StringReader(contents));
                String line = null;
                index = 0;
                while ((line = in.readLine()) != null) {
                    index += line.length();
                    if ((line = line.trim()).startsWith(UCA_BEGIN_MARKER)) {
                        ++pairCount;
                        continue;
                    }
                    if (!line.startsWith(UCA_END_MARKER) || --pairCount != 0) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                Plugin.internalError((Class)(class$com$sap$ide$webdynpro$controllereditor$services$RefactoringService == null ? (class$com$sap$ide$webdynpro$controllereditor$services$RefactoringService = RefactoringService.class$("com.sap.ide.webdynpro.controllereditor.services.RefactoringService")) : class$com$sap$ide$webdynpro$controllereditor$services$RefactoringService), (String)"getEndIndex(String contents)", (String)e.getMessage(), (Throwable)e, (boolean)true);
                return -1;
            }
        }
        return index;
    }

    private static Map getMethodsFromImplementation(IDOMCompilationUnit DOMUnit, Map removalMethods) throws MethodExtractionException {
        HashMap<String, IDOMMethod> methodsMap = new HashMap<String, IDOMMethod>();
        ArrayList<String> methodList = new ArrayList<String>();
        if (DOMUnit != null && removalMethods != null) {
            int type = 0;
            Enumeration children = DOMUnit.getChildren();
            IDOMNode node = null;
            while (children.hasMoreElements()) {
                node = (IDOMNode)children.nextElement();
                if (node.getNodeType() != 4) continue;
                Enumeration enumeration = node.getChildren();
                IDOMNode methodNode = null;
                while (enumeration.hasMoreElements()) {
                    methodNode = (IDOMNode)enumeration.nextElement();
                    type = methodNode.getNodeType();
                    if (type != 6) continue;
                    if (methodsMap.containsKey(methodNode.getName()) && removalMethods.containsKey(methodNode.getName())) {
                        throw new MethodExtractionException("Method \"" + methodNode.getName() + "\" is overloaded. \n" + "Overloaded methods are not supported.");
                    }
                    methodsMap.put(methodNode.getName(), (IDOMMethod)methodNode);
                    methodList.add(methodNode.getName());
                }
            }
        }
        DOMMethodNames = new String[methodList.size()];
        DOMMethodNames = methodList.toArray(DOMMethodNames);
        return methodsMap;
    }

    public static String removeMethodsFromImplementation(String contents, Map methods, String[] freeSpaceMethods) throws MethodExtractionException {
        String updatedCodeBody = null;
        if (contents != null && methods != null && freeSpaceMethods != null) {
            IDOMCompilationUnit DOMUnit = RefactoringService.getDOMCompilationUnit(contents);
            Map DOMMethods = RefactoringService.getMethodsFromImplementation(DOMUnit, methods);
            String freeCodingSection = RefactoringService.parseContentsForMethods(contents);
            StringBuffer buffer = new StringBuffer();
            buffer.append("public class GenerateMethods { \n\r\t");
            buffer.append(freeCodingSection);
            buffer.append("\n }");
            IDOMCompilationUnit unit = RefactoringService.getDOMCompilationUnit(buffer.toString());
            Enumeration children = unit.getChildren();
            IDOMNode classNode = null;
            while (children.hasMoreElements()) {
                classNode = (IDOMNode)children.nextElement();
                if (classNode.getNodeType() != 4) continue;
            }
            Set keys = methods.keySet();
            Iterator it = keys.iterator();
            IDOMNode node = null;
            String methodName = null;
            while (it.hasNext()) {
                methodName = (String)it.next();
                node = classNode.getChild(methodName);
                if (node == null) continue;
                node.remove();
            }
            String newContents = unit.getContents();
            String filterContents = null;
            if (newContents.indexOf(123) == -1 || newContents.lastIndexOf(125) == -1) {
                throw new MethodExtractionException("Unknown error occurred while source extraction");
            }
            filterContents = newContents.substring(newContents.indexOf(123) + 1, newContents.lastIndexOf(125));
            String newFreeCodingSection = "//@@begin others" + filterContents + "\r\n\t//@@end";
            int index = contents.indexOf("//@@begin others");
            int endIndex = RefactoringService.getEndIndex(contents);
            String beforeFreeCodingSection = contents.substring(0, index);
            String afterFreeCodingSection = contents.substring(index + endIndex);
            updatedCodeBody = beforeFreeCodingSection + newFreeCodingSection + afterFreeCodingSection;
        }
        return updatedCodeBody;
    }

    private static String[] updateArray(String[] freeSpaceMethods, int position) {
        if (freeSpaceMethods != null) {
            String[] temp = new String[freeSpaceMethods.length - 1];
            int count = 0;
            int j = 0;
            while (j < freeSpaceMethods.length) {
                if (position != j) {
                    temp[count++] = freeSpaceMethods[j];
                }
                ++j;
            }
            freeSpaceMethods = temp;
        }
        return freeSpaceMethods;
    }

    private static int getPosition(String[] freeSpaceMethods, String methodName) {
        if (methodName != null && freeSpaceMethods != null) {
            int i = 0;
            while (i < freeSpaceMethods.length) {
                if (freeSpaceMethods[i] != null && methodName.equals(freeSpaceMethods[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static void updateModelWithMethods(Controller controller, Map methods, Map extractionDetails, Map FQNamesMap) throws MethodExtractionException {
        if (controller != null && methods != null && extractionDetails != null && FQNamesMap != null) {
            Set keys = methods.keySet();
            Iterator it = keys.iterator();
            IDOMMethod method = null;
            String methodName = null;
            String extractType = null;
            Map FQNamesForTypes = null;
            while (it.hasNext()) {
                methodName = (String)it.next();
                method = (IDOMMethod)methods.get(methodName);
                extractType = (String)extractionDetails.get(methodName);
                FQNamesForTypes = (Map)FQNamesMap.get(methodName);
                if (extractType != null && extractType.equals("Method")) {
                    RefactoringService.createMethod(controller, method, FQNamesForTypes);
                    Method conMethod = controller.getMethod(methodName);
                    if (conMethod == null) continue;
                    conMethod.setCodeBody(method.getBody());
                    continue;
                }
                if (extractType == null || !extractType.equals("Event Handler")) continue;
                RefactoringService.createEventHandler(controller, method, FQNamesForTypes);
            }
        }
    }

    private static void createMethod(Controller controller, IDOMMethod method, Map FQNamesForTypes) throws MethodExtractionException {
        if (method != null && FQNamesForTypes != null) {
            DataTypeProvider provider = new DataTypeProvider(controller);
            Object visibility = null;
            DtSimpleType retType = null;
            MetamodelServices.CompoundType compoundType = null;
            String typeName = null;
            String fullyQualifiedName = null;
            String dimensionStr = null;
            int dimension = 0;
            typeName = method.getReturnType();
            dimension = RefactoringService.getDimensionForType(typeName);
            if (dimension > 0) {
                dimensionStr = typeName.substring(typeName.indexOf("[]"));
                typeName = typeName.substring(0, typeName.indexOf("[]"));
            } else {
                dimensionStr = "";
            }
            fullyQualifiedName = (String)FQNamesForTypes.get(typeName);
            if (fullyQualifiedName == null) {
                retType = null;
                compoundType = null;
            } else if (provider.isDDicSimpleType(fullyQualifiedName)) {
                retType = provider.getDtSimpleType(fullyQualifiedName);
                compoundType = new MetamodelServices.CompoundType((DevelopmentObject)retType);
            } else {
                compoundType = new MetamodelServices.CompoundType(fullyQualifiedName);
                retType = null;
            }
            String error = MethodService.createMethod((Controller)controller, (String)method.getName(), (VisibilityEnum)VisibilityEnum.NONE, (DevelopmentObject)retType, (MetamodelServices.CompoundType)compoundType, (int)dimension);
            if (error == null) {
                String[] paramNames = method.getParameterNames();
                String[] paramTypes = method.getParameterTypes();
                Method mObject = controller.getMethod(method.getName());
                Object classObj = null;
                if (paramNames != null) {
                    int i = 0;
                    while (i < paramTypes.length) {
                        typeName = paramTypes[i];
                        dimension = RefactoringService.getDimensionForType(typeName);
                        if (dimension > 0) {
                            dimensionStr = typeName.substring(typeName.indexOf("[]"));
                            typeName = typeName.substring(0, typeName.indexOf("[]"));
                        } else {
                            dimensionStr = "";
                        }
                        fullyQualifiedName = (String)FQNamesForTypes.get(typeName);
                        if (provider.isDDicSimpleType(fullyQualifiedName)) {
                            retType = provider.getDtSimpleType(fullyQualifiedName);
                            compoundType = new MetamodelServices.CompoundType((DevelopmentObject)retType);
                        } else {
                            compoundType = new MetamodelServices.CompoundType(fullyQualifiedName);
                            retType = null;
                        }
                        error = ParameterService.createParameter((ParameterizedFeature)mObject, (String)paramNames[i], (DevelopmentObject)retType, (MetamodelServices.CompoundType)compoundType, (boolean)true, (int)dimension);
                        if (error != null) {
                            throw new MethodExtractionException(error);
                        }
                        ++i;
                    }
                }
            } else {
                throw new MethodExtractionException(error);
            }
        }
    }

    private static int getDimensionForType(String typeName) {
        int dimension = 0;
        int index = -1;
        while (typeName != null) {
            index = typeName.indexOf("[]");
            if (index == -1) break;
            ++dimension;
            typeName = typeName.substring(index + 1);
        }
        return dimension;
    }

    private static void createEventHandler(Controller controller, IDOMMethod method, Map FQNamesForTypes) throws MethodExtractionException {
        if (controller != null && method != null) {
            String error = MethodService.createEventHandler((Controller)controller, (String)method.getName(), (VisibilityEnum)VisibilityEnum.PUBLIC, null, null, null, (boolean)false, null);
            if (error == null) {
                String[] paramNames = method.getParameterNames();
                String[] paramTypes = method.getParameterTypes();
                EventHandler eventHandler = controller.getEventHandler(method.getName());
                if (paramNames != null) {
                    DataTypeProvider provider = new DataTypeProvider(controller);
                    Object visibility = null;
                    DtSimpleType retType = null;
                    MetamodelServices.CompoundType compoundType = null;
                    String typeName = null;
                    String fullyQualifiedName = null;
                    String dimensionStr = null;
                    int dimension = 0;
                    int i = 0;
                    if (paramTypes[0].equals("com.sap.tc.webdynpro.progmodel.api.IWDCustomEvent") || paramTypes[0].equals("IWDCustomEvent")) {
                        ++i;
                    }
                    while (i < paramTypes.length) {
                        typeName = paramTypes[i];
                        dimension = RefactoringService.getDimensionForType(typeName);
                        if (dimension > 0) {
                            dimensionStr = typeName.substring(typeName.indexOf("[]"));
                            typeName = typeName.substring(0, typeName.indexOf("[]"));
                        } else {
                            dimensionStr = "";
                        }
                        fullyQualifiedName = (String)FQNamesForTypes.get(typeName) + dimensionStr;
                        if (provider.isDDicSimpleType(typeName)) {
                            retType = provider.getDtSimpleType(fullyQualifiedName);
                            compoundType = new MetamodelServices.CompoundType((DevelopmentObject)retType);
                        } else {
                            compoundType = new MetamodelServices.CompoundType(fullyQualifiedName);
                            retType = null;
                        }
                        error = ParameterService.createParameter((ParameterizedFeature)eventHandler, (String)paramNames[i], (DevelopmentObject)retType, (MetamodelServices.CompoundType)compoundType, (boolean)true, (int)dimension);
                        if (error != null) {
                            throw new MethodExtractionException(error);
                        }
                        ++i;
                    }
                }
            } else {
                throw new MethodExtractionException(error);
            }
        }
    }

    public static String updateCompilationUnit(String contents, Map methods, Map extractionDetails) throws MethodExtractionException {
        String updatedCodeBody = null;
        if (contents != null && methods != null && extractionDetails != null) {
            IDOMCompilationUnit DOMUnit = RefactoringService.getDOMCompilationUnit(contents);
            Map tempMethods = RefactoringService.getMethodsFromImplementation(DOMUnit, methods);
            Set keys = methods.keySet();
            Iterator it = keys.iterator();
            String methodName = null;
            String extType = null;
            IDOMMethod method = null;
            IDOMMethod tempMethod = null;
            while (it.hasNext()) {
                methodName = (String)it.next();
                extType = (String)extractionDetails.get(methodName);
                method = (IDOMMethod)methods.get(methodName);
                tempMethod = (IDOMMethod)tempMethods.get(methodName);
                tempMethod.setBody(RefactoringService.modifyContent(method.getBody(), methodName, (String)extractionDetails.get(methodName)));
            }
            updatedCodeBody = DOMUnit.getContents();
        }
        return updatedCodeBody;
    }

    private static String modifyContent(String content, String methodName, String extType) {
        if (content != null && methodName != null && extType != null) {
            String methodCallFn = "()";
            String eventCallFn = "(ServerEvent)";
            int index = content.indexOf(123);
            if (index != -1 && (index = (content = content.substring(index + 1)).lastIndexOf(125)) != -1 && (content = content.substring(0, index).trim()).length() > 0) {
                String starting = "//@@begin " + methodName + "()";
                String ending = UCA_END_MARKER;
                if (extType.equals("Method")) {
                    starting = "//@@begin " + methodName + methodCallFn;
                } else if (extType.equals("Event Handler")) {
                    starting = "//@@begin " + methodName + eventCallFn;
                }
                index = content.indexOf(starting);
                if (index != -1) {
                    content = content.substring(0, index) + content.substring(index + starting.length());
                }
                if ((index = content.lastIndexOf(ending)) != -1) {
                    content = content.substring(0, index) + content.substring(index + ending.length());
                }
                StringBuffer buffer = new StringBuffer();
                if (extType.equals("Method")) {
                    starting = "{\n//@@begin " + methodName + methodCallFn + "\r\n\t";
                } else if (extType.equals("Event Handler")) {
                    starting = "{\n//@@begin " + methodName + eventCallFn + "\r\n\t";
                }
                ending = "\n//@@end\n}";
                buffer.append(starting);
                buffer.append(content.trim());
                buffer.append(ending);
                return buffer.toString();
            }
        }
        return "";
    }

    public static boolean isCompilationUnitErrorFree(Controller controller) {
        try {
            IProject project = ServicesEclipse.getEclipseProject((DevelopmentObject)controller);
            project.build(10, null);
            NamingService namingService = new NamingService(project.getLocation().toFile().getAbsolutePath() + GenerationEclipse.getGenerationOutputPathInfix());
            Path path = new Path(namingService.getControllerEditableNaming(controller).getAbsoluteFilePath());
            IFile javaSourceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            IMarker[] markers = javaSourceFile.findMarkers("org.eclipse.jdt.core.problem", true, 2);
            return markers == null || markers.length <= 0;
        }
        catch (CoreException e) {
            Plugin.internalError((Class)(class$com$sap$ide$webdynpro$controllereditor$services$RefactoringService == null ? (class$com$sap$ide$webdynpro$controllereditor$services$RefactoringService = RefactoringService.class$("com.sap.ide.webdynpro.controllereditor.services.RefactoringService")) : class$com$sap$ide$webdynpro$controllereditor$services$RefactoringService), (String)"isCompilationUnitErrorFree(Controller controller)", (String)e.getMessage(), (Throwable)e, (boolean)true);
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        comment = "\t/*\r\n\t* The following coding section can be used for any Java coding that has\r\n\t* not to be visible to other controllers/views or that contains constructs\r\n\t* currently not supported directly by Web Dynpro (such as inner classes or\r\n\t* member variables etc.). </p>\r\n\t*\r\n\t* Note: The content of this section is in no way managed/controlled\r\n\t* neither by the Web Dynpro Designtime nor the Web Dynpro Runtime.\r\n\t*/\r\n\t//@@begin others\r\n";
    }
}

