/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.services;

import com.sap.dictionary.designtime.DdMapping;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.plugin.DictionaryRootManager;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.service.core.MetamodelServices;

public class DataTypeProvider {
    private DtSimpleType[] dataTypes = null;

    public DataTypeProvider(Controller controller) {
        DtDictionaryRoot DDicRoot = DictionaryRootManager.getDictionaryRoot((Metamodel)controller.getRoot().getMetamodel());
        try {
            this.dataTypes = DDicRoot.getSimpleTypes();
        }
        catch (LoadException e) {
            Plugin.internalError(this.getClass(), (String)"DataTypeProvider(Controller controller)", (String)e.getMessage(), (Throwable)e, (boolean)true);
        }
    }

    public boolean isSimpleType(String typeName) {
        String ddicTypeName;
        if (typeName != null && (ddicTypeName = DdMapping.getDdicTypeFromJavaType((String)typeName)) != null) {
            int i = 0;
            while (i < this.dataTypes.length) {
                if (this.dataTypes[i].getName().equals(ddicTypeName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isDDicSimpleType(String typeName) {
        return typeName != null && DdMapping.getDdicTypeFromJavaType((String)typeName) != null;
    }

    public boolean isJavaNativeType(String typeName) {
        return typeName != null && DdMapping.getDdicTypeFromJavaType((String)typeName) == null;
    }

    public DtSimpleType getBuiltInScalarType(String javaType) {
        if (javaType != null) {
            String ddicTypeName = DdMapping.getDdicTypeFromJavaType((String)javaType);
            Object dtSimpleType = null;
            if (ddicTypeName != null) {
                int i = 0;
                while (i < this.dataTypes.length) {
                    if (this.dataTypes[i].getName().equals(ddicTypeName)) {
                        return this.dataTypes[i];
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public DtSimpleType getDtSimpleType(String javaType) {
        if (javaType != null) {
            String ddicTypeName = DdMapping.getDdicTypeFromJavaType((String)javaType);
            Object dtSimpleType = null;
            if (ddicTypeName != null) {
                int i = 0;
                while (i < this.dataTypes.length) {
                    if (this.dataTypes[i].getName().equals(ddicTypeName)) {
                        return this.dataTypes[i];
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public MetamodelServices.CompoundType getCompoundType(String qualifiedJavaType) {
        if (qualifiedJavaType != null) {
            return new MetamodelServices.CompoundType(qualifiedJavaType);
        }
        return null;
    }
}

