/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.helpers;

import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.controllereditor.helpers.ExtractMethodModel;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.AllTypesCache;
import org.eclipse.jdt.internal.corext.util.TypeInfo;

public class ExtractMethodParameterModel {
    public static final String TYPE_NAME = "TYPE NAME";
    public static final String RESOLVE_AS = "RESOLVE AS";
    private ExtractMethodModel parent;
    private String paramName;
    private String paramType;
    private boolean isArray;
    private String paramDisplayName;
    private String[] resolvedTypes;
    private String declaredType;

    public ExtractMethodParameterModel(ExtractMethodModel method, String paramName, String paramType) {
        this.parent = method;
        this.paramName = paramName;
        this.paramType = paramType;
        this.getGUIDisplayName();
        this.resolveTypes();
    }

    public boolean isArray() {
        return this.isArray;
    }

    public String getParamDisplayName() {
        return this.paramDisplayName;
    }

    public String[] getResolvedTypes() {
        return this.resolvedTypes;
    }

    public ExtractMethodModel getParent() {
        return this.parent;
    }

    public void setParent(ExtractMethodModel model) {
        this.parent = model;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String string) {
        this.paramName = string;
    }

    public String getParamType() {
        return this.paramType;
    }

    public void setParamType(String string) {
        this.paramType = string;
    }

    public String getDeclaredType() {
        return this.declaredType;
    }

    public void setDeclaredType(String string) {
        this.declaredType = string;
    }

    public void setDeclaredType(int i) {
        if (i < this.resolvedTypes.length) {
            this.declaredType = this.resolvedTypes[i];
        }
    }

    public boolean isResolved() {
        return this.declaredType != null;
    }

    public boolean canBeResolved() {
        return this.resolvedTypes != null && this.resolvedTypes.length > 1;
    }

    private void getGUIDisplayName() {
        this.paramDisplayName = this.paramType != null && this.paramType.indexOf("[]") != -1 ? this.paramType.substring(0, this.paramType.indexOf("[]")) : this.paramType;
    }

    private void resolveTypes() {
        if (this.paramType != null) {
            IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
            TypeInfo[] typeInfo = null;
            try {
                typeInfo = AllTypesCache.getTypesForName((String)this.paramDisplayName, (IJavaSearchScope)scope, null);
                if (typeInfo != null && typeInfo.length == 1) {
                    this.resolvedTypes = new String[1];
                    this.resolvedTypes[0] = typeInfo[0].getFullyQualifiedName();
                    this.declaredType = this.resolvedTypes[0];
                } else if (typeInfo != null && typeInfo.length > 1) {
                    this.resolvedTypes = new String[typeInfo.length];
                    int i = 0;
                    while (i < typeInfo.length) {
                        this.resolvedTypes[i] = typeInfo[i].getFullyQualifiedName();
                        ++i;
                    }
                }
            }
            catch (JavaModelException e) {
                Plugin.internalError(this.getClass(), (String)"resolveTypes()", (String)e.getMessage(), (Throwable)e, (boolean)true);
            }
            if (this.resolvedTypes == null || this.resolvedTypes.length == 0) {
                this.resolvedTypes = new String[1];
                this.resolvedTypes[0] = this.paramType;
                this.declaredType = this.paramType;
            }
        }
    }

    public Object getValue(String property) {
        if (property.equals(RESOLVE_AS)) {
            return new Integer(this.getDeclaredTypeIndex());
        }
        return null;
    }

    private int getDeclaredTypeIndex() {
        if (this.declaredType != null) {
            int i = 0;
            while (i < this.resolvedTypes.length) {
                if (this.resolvedTypes[i].equals(this.declaredType)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }
}

