/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.helpers;

import com.sap.ide.webdynpro.controllereditor.helpers.ExtractMethodParameterModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ExtractMethodModel {
    public static final String EXT_TYPE_METHOD = "Method";
    public static final String EXT_TYPE_EVTHANDLER = "Event Handler";
    public static String[] extractionTypes = new String[]{"Method", "Event Handler"};
    private String methodName;
    private boolean isSelected;
    private String extractionType;
    private ExtractMethodParameterModel returnType;
    private ExtractMethodParameterModel[] parameters;
    private boolean isResolved;

    public ExtractMethodModel(String name, String retType, Map paramsMap) {
        this.methodName = name;
        this.isSelected = true;
        this.extractionType = EXT_TYPE_METHOD;
        if (retType != null && !retType.equals("void")) {
            this.returnType = new ExtractMethodParameterModel(this, retType, retType);
        }
        if (paramsMap != null && !paramsMap.isEmpty()) {
            this.parameters = new ExtractMethodParameterModel[paramsMap.size()];
            Set keys = paramsMap.keySet();
            Iterator it = keys.iterator();
            String paramName = null;
            String paramType = null;
            int count = 0;
            while (it.hasNext()) {
                paramName = (String)it.next();
                paramType = (String)paramsMap.get(paramName);
                this.parameters[count++] = new ExtractMethodParameterModel(this, paramName, paramType);
            }
        }
    }

    public static String[] getExtractionTypes() {
        return extractionTypes;
    }

    public boolean isResolved() {
        if (this.returnType == null && this.parameters == null) {
            return true;
        }
        boolean status = false;
        if (this.returnType != null && !this.returnType.isResolved()) {
            return false;
        }
        if (this.parameters != null) {
            int i = 0;
            while (i < this.parameters.length) {
                if (!this.parameters[i].isResolved()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public void setResolved(boolean status) {
        this.isResolved = status;
    }

    public boolean canTypesBeResolved() {
        Object types = null;
        HashMap typesMap = new HashMap();
        if (this.returnType != null && this.returnType.canBeResolved()) {
            return true;
        }
        if (this.parameters != null) {
            int i = 0;
            while (i < this.parameters.length) {
                if (this.parameters[i].canBeResolved()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean hasReturnType() {
        return this.returnType != null;
    }

    public String getExtractionType() {
        return this.extractionType;
    }

    public void setExtractionType(String string) {
        this.extractionType = string;
    }

    public void setExtractType(int i) {
        if (i < extractionTypes.length) {
            this.extractionType = extractionTypes[i];
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean b) {
        this.isSelected = b;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String string) {
        this.methodName = string;
    }

    public ExtractMethodParameterModel[] getParameters() {
        return this.parameters;
    }

    public void setParameters(ExtractMethodParameterModel[] models) {
        this.parameters = models;
    }

    public ExtractMethodParameterModel getReturnType() {
        return this.returnType;
    }

    public void setReturnType(ExtractMethodParameterModel model) {
        this.returnType = model;
    }

    public ExtractMethodParameterModel[] getTypesForResolution() {
        ExtractMethodParameterModel[] types = null;
        HashMap<String, ExtractMethodParameterModel> typesMap = new HashMap<String, ExtractMethodParameterModel>();
        if (this.returnType != null && !this.returnType.isResolved()) {
            typesMap.put(this.returnType.getParamType(), this.returnType);
        }
        if (this.parameters != null) {
            int i = 0;
            while (i < this.parameters.length) {
                if (!this.parameters[i].isResolved()) {
                    typesMap.put(this.parameters[i].getParamType(), this.parameters[i]);
                }
                ++i;
            }
        }
        types = new ExtractMethodParameterModel[typesMap.size()];
        Set keys = typesMap.keySet();
        Iterator it = keys.iterator();
        String paramType = null;
        int count = 0;
        while (it.hasNext()) {
            paramType = (String)it.next();
            types[count++] = (ExtractMethodParameterModel)typesMap.get(paramType);
        }
        return types;
    }

    public ExtractMethodParameterModel[] getTypesForReResolution() {
        ExtractMethodParameterModel[] types = null;
        HashMap<String, ExtractMethodParameterModel> typesMap = new HashMap<String, ExtractMethodParameterModel>();
        if (this.returnType != null && this.returnType.canBeResolved()) {
            typesMap.put(this.returnType.getParamType(), this.returnType);
        }
        if (this.parameters != null) {
            int i = 0;
            while (i < this.parameters.length) {
                if (this.parameters[i].getResolvedTypes() != null && this.parameters[i].getResolvedTypes().length > 1) {
                    typesMap.put(this.parameters[i].getParamType(), this.parameters[i]);
                }
                ++i;
            }
        }
        System.out.println("getTypesForResolution          " + typesMap);
        types = new ExtractMethodParameterModel[typesMap.size()];
        Set keys = typesMap.keySet();
        Iterator it = keys.iterator();
        String paramType = null;
        int count = 0;
        while (it.hasNext()) {
            paramType = (String)it.next();
            types[count++] = (ExtractMethodParameterModel)typesMap.get(paramType);
        }
        return types;
    }

    public Object getValue(String property) {
        if (property.equals("Status")) {
            this.isSelected = !this.isSelected;
            return new Boolean(this.isSelected);
        }
        if (property.equals("Method Name")) {
            return this.methodName;
        }
        if (property.equals("Extract As ")) {
            return new Integer(this.getExtractionTypeIndex());
        }
        return null;
    }

    private int getExtractionTypeIndex() {
        if (this.extractionType != null) {
            int i = 0;
            while (i < extractionTypes.length) {
                if (extractionTypes[i].equals(this.extractionType)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }
}

