/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.actions;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.repository.ControllerRepositoryManager;
import com.sap.ide.webdynpro.controllereditor.ControllerEditorPart;
import com.sap.ide.webdynpro.controllereditor.exceptions.MethodExtractionException;
import com.sap.ide.webdynpro.controllereditor.implementation.JavaImplementationEditor;
import com.sap.ide.webdynpro.controllereditor.services.RefactoringService;
import com.sap.ide.webdynpro.controllereditor.services.TypeResolver;
import com.sap.ide.webdynpro.controllereditor.wizards.SourceExtractionWizardDialog;
import com.sap.ide.webdynpro.service.controllereditor.ControllerEditorInput;
import com.sap.ide.webdynpro.service.controllereditor.implementation.IJavaImplementationEditor;
import com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class ModelRefactoringAction
extends Action
implements IEditorActionDelegate {
    private IJavaImplementationEditor mEditor;
    private Controller mController;
    private IEditorInput editorInput;
    private String originalContents;
    private boolean isExtractionPossible;
    private boolean moreMethods;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor == null) {
            return;
        }
        if (targetEditor instanceof ControllerEditorPart) {
            this.mEditor = ((ControllerEditorPart)targetEditor).getImplementationEditor();
            this.editorInput = targetEditor.getEditorInput();
            this.mController = ((ControllerEditorInput)targetEditor.getEditorInput()).getController();
            this.originalContents = this.mEditor.getEditorContent();
            if (action != null) {
                action.setEnabled(true);
            }
            JavaImplementationEditor javaImplementationEditor = new JavaImplementationEditor();
        } else if (targetEditor instanceof JavaImplementationEditor) {
            this.mEditor = (JavaImplementationEditor)targetEditor;
            if (action != null) {
                action.setEnabled(true);
            }
        } else {
            this.mEditor = null;
            this.mController = null;
            if (action != null) {
                action.setEnabled(false);
            }
        }
    }

    public void run(IAction action) {
        if (this.mController != null && this.checkWritability()) {
            boolean status;
            boolean isErrorFree = RefactoringService.isCompilationUnitErrorFree(this.mController);
            if (!isErrorFree && !(status = MessageDialog.openQuestion((Shell)new Shell(), (String)"Warning!", (String)"There are few compilation errors/warnings. \nDo you still want to continue?"))) {
                return;
            }
            this.performAction();
        } else {
            System.out.println("Cannot process on non-writable objects");
        }
    }

    private boolean checkWritability() {
        MMRepositoryObject[] repositoryObjects = new MMRepositoryObject[]{ControllerRepositoryManager.getRepositioryObject((Controller)this.mController, (boolean)false)};
        return RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects);
    }

    private boolean performExtraction(String[] freeSpaceMethods, String[] selectedMethods, Map refactorMethods, Map extractionDetails, Map FQNamesMap) {
        ImplementationService service = null;
        try {
            Map removeMethods = RefactoringService.getSelectedMethods(selectedMethods, refactorMethods);
            String updatedCodeBody = null;
            Map declareMethods = null;
            if (!removeMethods.isEmpty()) {
                declareMethods = RefactoringService.removeMethods(removeMethods, selectedMethods);
                updatedCodeBody = RefactoringService.removeMethodsFromImplementation(this.mEditor.getEditorContent(), declareMethods, freeSpaceMethods);
                if (updatedCodeBody != null) {
                    this.mController.setCodeBody(updatedCodeBody);
                }
                RefactoringService.updateModelWithMethods(this.mController, declareMethods, extractionDetails, FQNamesMap);
                service = new ImplementationService(this.mController, new Shell());
                service.setJavaEditor(this.mEditor);
                service.updateImplementationFromXML();
                updatedCodeBody = RefactoringService.updateCompilationUnit(this.mEditor.getEditorContent(), declareMethods, extractionDetails);
                if (updatedCodeBody != null) {
                    this.mController.setCodeBody(updatedCodeBody);
                }
                service.updateImplementationFromXML();
            }
            return true;
        }
        catch (MethodExtractionException e) {
            System.out.println("Error Occurred while extraction: " + e.getMessage());
            MessageDialog.openInformation((Shell)new Shell(), (String)"Error Occurred!", (String)e.getLocalizedMessage());
            if (service != null) {
                this.mController.setCodeBody(this.originalContents);
                service.updateImplementationFromXML();
            }
            return false;
        }
    }

    private boolean performAction() {
        ImplementationService service = null;
        this.isExtractionPossible = false;
        this.moreMethods = false;
        try {
            Map refactorMethods = RefactoringService.findMethodsForRefactoring(this.mEditor.getEditorContent());
            String[] freeSpaceMethods = RefactoringService.getDOMMethodNames();
            this.isMethodExtractionPossible(refactorMethods);
            if (!refactorMethods.isEmpty()) {
                if (this.isExtractionPossible) {
                    if (this.moreMethods) {
                        MessageDialog.openInformation((Shell)new Shell(), (String)"Method Extraction", (String)"There are few private/protected/static/final methods \nwhich cannot be extracted into the model. \nOnly the eligible methods will be listed for extraction.");
                    }
                    SourceExtractionWizardDialog dialog = new SourceExtractionWizardDialog(refactorMethods);
                    dialog.open();
                    dialog.close();
                    String[] selectedMethods = dialog.getMethods();
                    Map extractionDetails = dialog.getExtractionDetails();
                    Map FQNamesMap = TypeResolver.resolveTypesForMethods(selectedMethods, refactorMethods, this.mEditor.getEditorContent());
                    Map removeMethods = RefactoringService.getSelectedMethods(selectedMethods, refactorMethods);
                    String updatedCodeBody = null;
                    Map declareMethods = null;
                    if (!removeMethods.isEmpty()) {
                        declareMethods = RefactoringService.removeMethods(removeMethods, selectedMethods);
                        updatedCodeBody = RefactoringService.removeMethodsFromImplementation(this.mEditor.getEditorContent(), declareMethods, freeSpaceMethods);
                        if (updatedCodeBody != null) {
                            this.mController.setCodeBody(updatedCodeBody);
                        }
                        RefactoringService.updateModelWithMethods(this.mController, declareMethods, extractionDetails, FQNamesMap);
                        service = new ImplementationService(this.mController, new Shell());
                        service.setJavaEditor(this.mEditor);
                        service.updateImplementationFromXML();
                        updatedCodeBody = RefactoringService.updateCompilationUnit(this.mEditor.getEditorContent(), declareMethods, extractionDetails);
                        if (updatedCodeBody != null) {
                            this.mController.setCodeBody(updatedCodeBody);
                        }
                        service.updateImplementationFromXML();
                    }
                } else {
                    MessageDialog.openInformation((Shell)new Shell(), (String)"Method Extraction", (String)"Operation unavailable. \nFound only private/protected/static/final methods \nwhich cannot be extracted into the model.");
                }
            } else {
                MessageDialog.openInformation((Shell)new Shell(), (String)"Method Extraction", (String)"Operation unavailable. \nNo methods defined for extraction");
            }
            return true;
        }
        catch (MethodExtractionException e) {
            System.out.println("Error Occurred while extraction: " + e.getMessage());
            MessageDialog.openInformation((Shell)new Shell(), (String)"Error Occurred!", (String)e.getLocalizedMessage());
            if (service != null) {
                this.mController.setCodeBody(this.originalContents);
                service.updateImplementationFromXML();
            }
            return false;
        }
    }

    private void isMethodExtractionPossible(Map extractMethods) {
        if (extractMethods != null && !extractMethods.isEmpty()) {
            Set keys = extractMethods.keySet();
            Iterator it = keys.iterator();
            IDOMMethod method = null;
            String methodName = null;
            while (it.hasNext()) {
                methodName = (String)it.next();
                method = (IDOMMethod)extractMethods.get(methodName);
                if (Flags.isPublic((int)method.getFlags()) && !Flags.isStatic((int)method.getFlags()) && !Flags.isFinal((int)method.getFlags())) {
                    this.isExtractionPossible = true;
                    continue;
                }
                this.moreMethods = true;
            }
        }
    }

    public void selectionChanged(IAction arg0, ISelection arg1) {
    }
}

