/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.techdev.webdynpro;

import com.sap.tc.buildplugin.api.BuildActionResult;
import com.sap.tc.buildplugin.api.BuildActionSeverity;
import com.sap.tc.buildplugin.api.IBuildAction;
import com.sap.tc.buildplugin.api.IBuildInfo;
import com.sap.tc.buildplugin.api.IDevelopmentComponentInfo;
import com.sap.tc.buildplugin.pputil.CreateEntityXML;
import com.sap.tc.buildplugin.pputil.PPCollector;
import com.sap.tc.buildplugin.techdev.ant.util.BuildManifest;
import com.sap.tc.buildplugin.techdev.ant.util.DirsAndFiles;
import com.sap.tc.buildplugin.techdev.ant.util.FileCreator;
import com.sap.tc.buildplugin.techdev.webdynpro.CIData;
import com.sap.tc.buildplugin.techdev.webdynpro.CompData;
import com.sap.tc.buildplugin.techdev.webdynpro.ModelData;
import com.sap.tc.buildplugin.techdev.webdynpro.STData;
import com.sap.tc.buildplugin.techdev.webdynpro.StructureData;
import com.sap.tc.buildplugin.util.CheckManifest;
import com.sap.tc.buildplugin.util.ComponentDependencies;
import com.sap.tc.buildtool.BuildToolException;
import com.sap.tc.buildtool.LogFile;
import com.sap.tc.complib.ComponentType;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CreateBuildFileAction
implements IBuildAction {
    BuildActionResult result;
    BuildActionSeverity severity;
    DirsAndFiles daf;
    String buildFileName;
    File pluginRoot;
    FileCreator fCreator;
    int currentStep;
    public static final String PACKAGE_DIR = "packages";
    public static final int LENGTH_PACKAGES = "packages".length() + 1;
    ArrayList components = new ArrayList();
    ArrayList simpletypes = new ArrayList();
    ArrayList models = new ArrayList();
    ArrayList compInterfaces = new ArrayList();
    ArrayList allDep = new ArrayList();
    ArrayList structures = new ArrayList();
    HashSet packageSimpleTypes = new HashSet();
    HashSet packageStructures = new HashSet();
    int br = 0;
    String errMsg = "";
    Location loc = Location.getLocation((Class)(class$com$sap$tc$buildplugin$techdev$webdynpro$CreateBuildFileAction == null ? (class$com$sap$tc$buildplugin$techdev$webdynpro$CreateBuildFileAction = CreateBuildFileAction.class$("com.sap.tc.buildplugin.techdev.webdynpro.CreateBuildFileAction")) : class$com$sap$tc$buildplugin$techdev$webdynpro$CreateBuildFileAction));
    private IBuildInfo buildInfo;
    static /* synthetic */ Class class$com$sap$tc$buildplugin$techdev$webdynpro$CreateBuildFileAction;

    CreateBuildFileAction(FileCreator fc, int step, IBuildInfo buildInfo) {
        this.fCreator = fc;
        this.daf = fc.getDaf();
        this.currentStep = step;
        this.buildInfo = buildInfo;
        this.result = new BuildActionResult();
        this.severity = new BuildActionSeverity();
        this.severity.setStopOnError();
    }

    public BuildActionResult execute() {
        this.loc.infoT("WebdynproPluginstarts creating the build file");
        IDevelopmentComponentInfo componentInfo = this.buildInfo.getDevelopmentComponentInfo();
        switch (this.currentStep) {
            case 1: {
                this.daf.setBuildFile("prebuild.xml");
                this.fCreator.setMacroName("prebuild.vm");
                break;
            }
            case 2: {
                this.daf.setBuildFile("build.xml");
                this.fCreator.setMacroName("build.vm");
                break;
            }
            case 3: {
                this.daf.setBuildFile("postbuild.xml");
                this.fCreator.setMacroName("postbuild.vm");
                break;
            }
            default: {
                this.daf.setBuildFile("build.xml");
                this.fCreator.setMacroName("build.vm");
            }
        }
        String prebuildDir = this.daf.getTempDir() + File.separator + "pre";
        this.fCreator.setStrContext("dc_prebuild_Dir", prebuildDir);
        File prebuildDirF = new File(prebuildDir);
        if (prebuildDirF.exists()) {
            this.fCreator.setStrContext("dc_prebuild_Dir_exist", "true");
        }
        File srcDirPackage = new File(this.daf.getSrcDirPackage());
        this.findAllComp(srcDirPackage);
        this.findAllModels(srcDirPackage);
        this.findAllCompInterface(srcDirPackage);
        this.findAllSTPackages(srcDirPackage);
        this.fillSTData();
        this.findAllStructPackages(srcDirPackage);
        this.fillStructData();
        this.fCreator.setListContext("dc_properties", this.daf.getDCProperties());
        this.fCreator.setStrContext("dc_src_Dir", this.daf.getSrcDir());
        this.fCreator.setStrContext("dc_src_packageDir", this.daf.getSrcDirPackage());
        this.fCreator.setStrContext("dc_root_Dir", this.daf.getRootDir());
        this.fCreator.setStrContext("dc_gen_classesDir", this.daf.getClassesDir());
        this.fCreator.setStrContext("dc_gen_tempDir", this.daf.getTempDir());
        this.fCreator.setStrContext("dc_deploy_Dir", this.daf.getGenDirDeploy());
        this.fCreator.setStrContext("dc_gen_publicDir", this.daf.getGenDirPublic());
        List packageDirs = this.daf.getPackageDirs();
        this.fCreator.setListContext("dc_packageDirs", packageDirs);
        this.fCreator.setStrContext("wd_package_File", this.daf.getDcFile());
        this.fCreator.setStrContext("wd_deploy_File", this.daf.getDcFile());
        this.fCreator.setStrContext("dc_deployFile", this.daf.getDcFile());
        this.fCreator.setStrContext("dc_jarSAP_vendor", this.daf.getDCVendor());
        this.fCreator.setStrContext("dc_jarSAP_name", this.daf.getDCName());
        this.fCreator.setStrContext("dc_jarSAP_scvendor", componentInfo.getCompartment().getScVendor());
        this.fCreator.setStrContext("dc_jarSAP_scname", componentInfo.getCompartment().getScName());
        this.fCreator.setListContext("dc_assembly_dirs", this.daf.getAssemblyDirs());
        this.fCreator.setStrContext("dc_jarSAP_location", this.daf.getCBSLocation());
        this.fCreator.setStrContext("dc_jarSAP_counter", this.daf.getCBSCounter());
        try {
            this.fCreator.setStrContext("compiler_executable_path", this.buildInfo.getCompilerExecutable());
        }
        catch (NoSuchMethodError ex) {
            String msg = "pluginhandler does not supply getCompilerExecutable";
            this.loc.traceThrowableT(300, msg, (Throwable)ex);
        }
        this.fCreator.setListContext("wd_simpletypes", (List)this.simpletypes);
        this.fCreator.setListContext("wd_components", (List)this.components);
        this.fCreator.setListContext("wd_models", (List)this.models);
        this.fCreator.setListContext("wd_component_interfaces", (List)this.compInterfaces);
        this.fCreator.setListContext("wd_structures", (List)this.structures);
        HashMap<String, String> AntPropsDependDirs = new HashMap<String, String>();
        List dependDirs = this.daf.getDependDirs();
        if (dependDirs != null) {
            Iterator it = dependDirs.iterator();
            int no = 0;
            while (it.hasNext()) {
                AntPropsDependDirs.put("dependDir_" + ++no, (String)it.next());
            }
        }
        this.fCreator.setHashMapContext("dc_depend_compileDirs", AntPropsDependDirs);
        List compDep = this.daf.getDependencies();
        if (compDep != null) {
            Iterator it = compDep.iterator();
            while (it.hasNext()) {
                Dependency dep = (Dependency)it.next();
                String name = dep.getComponent().getName();
                String vendor = dep.getComponent().getVendor();
                ComponentType type = null;
                DevelopmentComponent dc = this.daf.getReferencedComponent(dep);
                if (dc != null) {
                    type = dc.getComponentType();
                }
                if (type == null) {
                    this.allDep.add(new ComponentDependencies(name, vendor, dep.isAtDeployTime(), dep.isAtRunTime(), dep.getRuntimeQuialifier(), "", "", ""));
                    continue;
                }
                this.allDep.add(new ComponentDependencies(name, vendor, dep.isAtDeployTime(), dep.isAtRunTime(), dep.getRuntimeQuialifier(), type.getVendor(), type.getType(), type.getSubType()));
            }
        }
        this.fCreator.setListContext("dc_jarSap_dep", (List)this.allDep);
        Map ppMap = this.daf.getPublicParts();
        String wdgenLocation = this.daf.getTempDir() + File.separator + "gwd";
        File wdgenDir = new File(wdgenLocation);
        this.fCreator.setStrContext("temp_genwdp_dir", wdgenLocation);
        try {
            wdgenDir.mkdirs();
        }
        catch (Exception ex) {
            LogFile log = new LogFile();
            log.setErrorMessage(ex.getMessage());
            log.writeLogFile(this.daf.getLogFile());
            this.result.setBuildLogPath(this.daf.getLogFile());
            this.result.setBuildActionRC(2);
            String msg = "problem occurred while creating wdgen folder " + wdgenLocation;
            this.loc.traceThrowableT(500, msg, (Throwable)ex);
            return this.result;
        }
        String wdgenXmlFile = wdgenLocation + File.separator + "PublicPartList.xml";
        this.loc.infoT("creating wdgen xml input file in path " + wdgenXmlFile);
        CreateEntityXML myCreator = new CreateEntityXML(ppMap, wdgenXmlFile);
        try {
            myCreator.saveAsXML();
        }
        catch (BuildToolException e) {
            LogFile log = new LogFile();
            log.setErrorMessage(e.getMessage());
            log.writeLogFile(this.daf.getLogFile());
            this.result.setBuildLogPath(this.daf.getLogFile());
            this.result.setBuildActionRC(2);
            String msg = "problem occurred while creating wdgen xml input file in path " + wdgenXmlFile;
            this.loc.traceThrowableT(500, msg, (Throwable)e);
            return this.result;
        }
        this.fCreator.setStrContext("dc_wdgen_input_file", wdgenXmlFile);
        if (ppMap != null) {
            PPCollector pp = new PPCollector(componentInfo);
            this.br = pp.addData(ppMap);
            this.errMsg = pp.getErrorMsg();
            ArrayList<String> ppNames = new ArrayList<String>();
            Iterator it = ppMap.keySet().iterator();
            while (it.hasNext()) {
                PublicPart ppart = (PublicPart)ppMap.get((String)it.next());
                ppNames.add(ppart.getName());
            }
            this.fCreator.setListContext("dc_public_parts", pp.getList());
            this.fCreator.setListContext("dc_public_wdcomp", (List)pp.getEntityData("Web Dynpro Component", "Source"));
            this.fCreator.setListContext("dc_public_simpletype", (List)pp.getEntityData("Dictionary Simple Type", "Source"));
            this.fCreator.setListContext("dc_public_model", (List)pp.getEntityData("Common Model", "Source"));
            this.fCreator.setListContext("dc_public_component_interface", (List)pp.getEntityData("Web Dynpro Component Interface Definition", "Source"));
            this.fCreator.setListContext("dc_public_structure", (List)pp.getEntityData("Dictionary Structure", "Source"));
            this.fCreator.setListContext("dc_public_component_configuration", (List)pp.getEntityData("Web Dynpro Component Configuration", "Source"));
            this.fCreator.setListContext("dc_public_configuration_object", (List)pp.getEntityData("Web Dynpro Configuration Object", "Source"));
            String mfName = this.daf.getTempDir() + File.separator + "Manifest.mf";
            BuildManifest bmf = new BuildManifest(mfName);
            bmf.add("DC-Name", this.daf.getDCName());
            bmf.add("DC-Vendor", this.daf.getDCVendor());
            bmf.add("DC-Type", this.daf.getDCType());
            bmf.add("PP-Type", this.daf.getDCType());
            bmf.add("Deploy-File-Name", this.daf.getDcFile() + ".ear");
            bmf.write();
            this.fCreator.setStrContext("bi_manifest_Name", mfName);
        }
        String libModel = "lib" + File.separator + "model";
        List allDep = this.daf.getInfrastructurePublicDirs();
        String addPath = this.findAddFiles(allDep, libModel);
        this.fCreator.setStrContext("add_path", addPath);
        List addPathDep = this.daf.getDependDirs();
        String addPathDepStr = "";
        if (addPathDep != null) {
            Iterator it = addPathDep.iterator();
            while (it.hasNext()) {
                String ppDir = (String)it.next();
                File filePPDir = new File(ppDir);
                if (!filePPDir.exists()) continue;
                String[] allFilesInFolder = filePPDir.list();
                int i = 0;
                while (i < allFilesInFolder.length) {
                    String currentFileName = allFilesInFolder[i];
                    if (currentFileName.endsWith(".jar") || currentFileName.endsWith(".zip")) {
                        CheckManifest cm = null;
                        try {
                            cm = new CheckManifest(ppDir + File.separator + currentFileName, "meta-inf/manifest.mf");
                            if (cm.checkValue("PP-Type", "Dictionary") || cm.checkValue("PP-Type", "Web Dynpro") || cm.checkNameExist("MM-Content")) {
                                addPathDepStr = addPathDepStr + ppDir + File.separator + currentFileName + ";";
                            }
                        }
                        catch (IOException e) {
                            String msg = "manifest could not be read from " + currentFileName;
                            this.loc.traceThrowableT(500, msg, (Throwable)e);
                        }
                    }
                    ++i;
                }
            }
        }
        this.fCreator.setStrContext("dc_addPath_dep", addPathDepStr);
        HashMap buildOptions = this.daf.getBuildOptions();
        this.fCreator.setHashMapContext("dc_build_options", buildOptions);
        if (buildOptions.containsKey("ant_wd_languages")) {
            String langInConf = (String)buildOptions.get("ant_wd_languages");
            this.fCreator.setStrContext("dc_language", langInConf);
        } else {
            this.fCreator.setStrContext("dc_language", "");
        }
        this.fCreator.setHashMapContext("dc_jdo_files", this.daf.getJdoMap());
        if (this.daf.hasSQLJ()) {
            this.fCreator.setStrContext("sqlj_exist", "true");
        } else {
            this.fCreator.setStrContext("sqlj_exist", "false");
        }
        if (this.br != 2 && this.br != 3) {
            this.fCreator.createBuildFile();
        } else {
            LogFile log = new LogFile();
            log.setErrorMessage(this.errMsg);
            log.writeLogFile(this.daf.getLogFile());
        }
        this.result.setBuildLogPath(this.daf.getLogFile());
        this.result.setBuildActionRC(this.br);
        return this.result;
    }

    public String findAddFiles(List searchLocation, String subFolder) {
        Iterator iterator = searchLocation.iterator();
        String addPath = "";
        String currentFileName = "";
        String libModel = "lib" + File.separator + "model";
        while (iterator.hasNext()) {
            String modelFolderName = (String)iterator.next() + subFolder;
            File modelFolder = new File(modelFolderName);
            if (!modelFolder.exists()) continue;
            String[] allFilesInFolder = modelFolder.list();
            int i = 0;
            while (i < allFilesInFolder.length) {
                if (subFolder.equalsIgnoreCase(libModel) && (currentFileName = modelFolderName + File.separator + allFilesInFolder[i]).endsWith(".zip")) {
                    addPath = addPath + currentFileName + ";";
                }
                ++i;
            }
        }
        if (addPath.endsWith(";")) {
            addPath = addPath.substring(0, addPath.length() - 1);
        }
        return addPath;
    }

    public void findAllComp(File folder) {
        String wdCompName = "";
        if (folder.isDirectory()) {
            File[] content = folder.listFiles();
            if (content != null) {
                int i = 0;
                while (i < content.length) {
                    this.findAllComp(content[i]);
                    ++i;
                }
            }
        } else {
            String name = folder.getName();
            if (name.endsWith(".wdcomponent")) {
                int pos = name.indexOf(".");
                wdCompName = name.substring(0, pos);
                String fname = folder.getPath();
                String sourcePath = fname.substring(0, fname.indexOf(PACKAGE_DIR + File.separator) + LENGTH_PACKAGES);
                String packagePath = fname.substring(fname.indexOf(PACKAGE_DIR + File.separator) + LENGTH_PACKAGES, fname.lastIndexOf(File.separator));
                packagePath = packagePath.replace(File.separatorChar, '.');
                this.components.add(new CompData(wdCompName, packagePath, sourcePath));
            }
        }
    }

    public void fillSTData() {
        Iterator iter = this.packageSimpleTypes.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            this.simpletypes.add(new STData("+", element, this.daf.getSrcDirPackage()));
        }
    }

    public void findAllSTPackages(File folder) {
        if (folder.isDirectory()) {
            File[] stContent = folder.listFiles();
            if (stContent != null) {
                int i = 0;
                while (i < stContent.length) {
                    this.findAllSTPackages(stContent[i]);
                    ++i;
                }
            }
        } else {
            String name = folder.getName();
            if (name.endsWith(".dtsimpletype")) {
                int pos = name.indexOf(".");
                String fname = folder.getPath();
                String sourcePath = fname.substring(0, fname.indexOf(PACKAGE_DIR + File.separator) + LENGTH_PACKAGES);
                String packagePath = fname.substring(fname.indexOf(PACKAGE_DIR + File.separator) + LENGTH_PACKAGES, fname.lastIndexOf(File.separator));
                if (!this.packageSimpleTypes.contains(packagePath = packagePath.replace(File.separatorChar, '.'))) {
                    this.packageSimpleTypes.add(packagePath);
                }
            }
        }
    }

    public void findAllModels(File folder) {
        if (folder.isDirectory()) {
            File[] modelContent = folder.listFiles();
            if (modelContent != null) {
                int i = 0;
                while (i < modelContent.length) {
                    this.findAllModels(modelContent[i]);
                    ++i;
                }
            }
        } else {
            String name = folder.getName();
            if (name.endsWith(".wdmodel")) {
                int pos = name.indexOf(".");
                String modelName = name.substring(0, pos);
                String fname = folder.getPath();
                String sourcePath = fname.substring(0, fname.indexOf(PACKAGE_DIR + File.separator) + LENGTH_PACKAGES);
                String packagePath = fname.substring(fname.indexOf(PACKAGE_DIR + File.separator) + LENGTH_PACKAGES, fname.lastIndexOf(File.separator));
                String packageWithDots = packagePath.replace(File.separatorChar, '.');
                packagePath = packagePath.replace(File.separatorChar, '/');
                ModelData mdata = new ModelData(modelName, packagePath, packageWithDots, sourcePath);
                String parentDir = folder.getParent();
                this.findModelClasses(parentDir, mdata);
                this.models.add(mdata);
            }
        }
    }

    private void findModelClasses(String strDir, ModelData mdata) {
        File dir = new File(strDir);
        if (dir.isDirectory()) {
            File[] content = dir.listFiles();
            int i = 0;
            while (i < content.length) {
                String name = content[i].getName();
                if (name.endsWith(".wdmodelclass")) {
                    name = name.substring(0, name.indexOf(".wdmodelclass"));
                    mdata.addClassListEntry(name);
                }
                ++i;
            }
        }
    }

    public void findAllCompInterface(File folder) {
        if (folder.isDirectory()) {
            File[] ciContent = folder.listFiles();
            if (ciContent != null) {
                int i = 0;
                while (i < ciContent.length) {
                    this.findAllCompInterface(ciContent[i]);
                    ++i;
                }
            }
        } else {
            String name = folder.getName();
            if (name.endsWith(".wdcompinterfacedef")) {
                int pos = name.indexOf(".");
                String ciName = name.substring(0, pos);
                String fname = folder.getPath();
                String sourcePath = fname.substring(0, fname.indexOf(PACKAGE_DIR + File.separator) + LENGTH_PACKAGES);
                String packagePath = fname.substring(fname.indexOf(PACKAGE_DIR + File.separator) + LENGTH_PACKAGES, fname.lastIndexOf(File.separator));
                String packageWithDots = packagePath.replace(File.separatorChar, '.');
                this.compInterfaces.add(new CIData(ciName, packagePath, packageWithDots, sourcePath));
            }
        }
    }

    public void findAllStructPackages(File folder) {
        String stName = "";
        if (folder.isDirectory()) {
            File[] stContent = folder.listFiles();
            if (stContent != null) {
                int i = 0;
                while (i < stContent.length) {
                    this.findAllStructPackages(stContent[i]);
                    ++i;
                }
            }
        } else {
            String name = folder.getName();
            if (name.endsWith(".dtstructure")) {
                String fname = folder.getPath();
                String sourcePath = fname.substring(0, fname.indexOf(PACKAGE_DIR + File.separator) + LENGTH_PACKAGES);
                String packagePath = fname.substring(fname.indexOf(PACKAGE_DIR + File.separator) + LENGTH_PACKAGES, fname.lastIndexOf(File.separator));
                if (!this.packageStructures.contains(packagePath = packagePath.replace(File.separatorChar, '.'))) {
                    this.packageStructures.add(packagePath);
                }
            }
        }
    }

    public void fillStructData() {
        Iterator iter = this.packageStructures.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            this.structures.add(new StructureData("+", element, this.daf.getSrcDirPackage()));
        }
    }

    public BuildActionResult getBuildActionResult() {
        return this.result;
    }

    public BuildActionSeverity getBuildActionSeverity() {
        return this.severity;
    }

    public void setBuildActionSeverity(BuildActionSeverity _severity) {
        this.severity = _severity;
    }

    public String getCaption() {
        return "Create Build file";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

