/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.secstorefs;

import com.sap.security.core.server.secstorefs.FileExistsException;
import com.sap.security.core.server.secstorefs.FileIOException;
import com.sap.security.core.server.secstorefs.FileInvalidException;
import com.sap.security.core.server.secstorefs.FileMissingException;
import com.sap.security.core.server.secstorefs.InvalidStateException;
import com.sap.security.core.server.secstorefs.KeyHandler;
import com.sap.security.core.server.secstorefs.NoEncryptionException;
import com.sap.security.core.server.secstorefs.NoHashException;
import com.sap.security.core.server.secstorefs.NoKeyRequiredException;
import com.sap.security.core.server.secstorefs.NoSIDException;
import com.sap.security.core.server.secstorefs.SecStoreFSException;
import iaik.security.cipher.PBEKeyBMP;
import iaik.security.provider.IAIK;
import iaik.utils.Base64Exception;
import iaik.utils.Base64InputStream;
import iaik.utils.Base64OutputStream;
import iaik.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class Crypt {
    private boolean possible;
    private Throwable rootCause;
    private KeyHandler kh = new KeyHandler();
    private PBEParameterSpec pbeParamSpec;

    static void setDefaultKeyFilename(String keyFilename) throws InvalidStateException {
        KeyHandler.setDefaultKeyFilename(keyFilename);
    }

    static void setDefaultKeyPhrase(String keyPhrase) {
        KeyHandler.setDefaultKeyPhrase(keyPhrase);
    }

    static void setSID(String SID) {
        KeyHandler.setSID(SID);
    }

    Crypt() {
        try {
            Cipher cipher = Cipher.getInstance("PbeWithSHAAnd3_KeyTripleDES_CBC", "IAIK");
            KeyHandler localKh = new KeyHandler();
            localKh.setKeyForSession("xxx");
            PBEKeyBMP key = localKh.getEffectiveKey();
            byte[] salt = new byte[16];
            salt[15] = 0;
            salt[14] = 0;
            salt[13] = 0;
            salt[12] = 0;
            salt[11] = 0;
            salt[10] = 0;
            salt[9] = 0;
            salt[8] = 0;
            salt[7] = 0;
            salt[6] = 0;
            salt[5] = 0;
            salt[4] = 0;
            salt[3] = 0;
            salt[2] = 0;
            salt[1] = 0;
            salt[0] = 0;
            int count = 0;
            this.pbeParamSpec = new PBEParameterSpec(salt, count);
            cipher.init(1, (Key)key, this.pbeParamSpec);
            this.possible = true;
            this.rootCause = null;
        }
        catch (NoSuchAlgorithmException ex) {
            this.possible = false;
            this.rootCause = ex;
            return;
        }
        catch (NoSuchProviderException ex) {
            this.possible = false;
            this.rootCause = ex;
            return;
        }
        catch (NoSuchPaddingException ex) {
            this.possible = false;
            this.rootCause = ex;
            return;
        }
        catch (NoSIDException ex) {
            this.possible = false;
            this.rootCause = ex;
            return;
        }
        catch (InvalidKeyException ex) {
            this.possible = false;
            this.rootCause = ex;
            return;
        }
        catch (InvalidAlgorithmParameterException ex) {
            this.possible = false;
            this.rootCause = ex;
            return;
        }
        catch (SecurityException ex) {
            this.possible = false;
            this.rootCause = ex;
            return;
        }
        catch (FileInvalidException ex) {
            this.possible = true;
            this.rootCause = null;
        }
        catch (FileIOException ex) {
            this.possible = true;
            this.rootCause = null;
        }
        catch (FileMissingException ex) {
            this.possible = true;
            this.rootCause = null;
        }
        catch (InvalidStateException ex) {
            this.possible = true;
            this.rootCause = null;
        }
        catch (NoHashException ex) {
            this.possible = true;
            this.rootCause = null;
        }
    }

    boolean isEncryptionPossible() {
        return this.possible;
    }

    Throwable getRootCause() {
        return this.rootCause;
    }

    boolean isKeyRequired() {
        return this.isEncryptionPossible();
    }

    void setKeyFilename(String keyFilename) {
        this.kh.setKeyFilename(keyFilename);
    }

    boolean isKeyDialogRequiredForThisInstance() {
        boolean result = this.kh.isKeyDialogRequiredForThisInstance();
        return result;
    }

    void setKeyForSession(String keyPhrase) throws NoKeyRequiredException {
        if (!this.isKeyRequired()) {
            throw new NoKeyRequiredException(this.rootCause);
        }
        this.kh.setKeyForSession(keyPhrase);
    }

    void setNewKeyInFile(String keyPhrase, String fileFormatVersion) throws NoKeyRequiredException, InvalidStateException, FileIOException, InvalidStateException, NoHashException {
        if (!this.isKeyRequired()) {
            throw new NoKeyRequiredException(this.rootCause);
        }
        try {
            this.kh.setNewKeyInFile(keyPhrase, fileFormatVersion);
        }
        catch (FileExistsException ex1) {
            try {
                this.kh.updateKeyInFile(keyPhrase, fileFormatVersion);
            }
            catch (FileMissingException ex2) {
                throw new InvalidStateException("security.class_secStoreFS_0022", (Throwable)((Object)ex2));
            }
        }
    }

    void updateKeyInFile(String keyPhrase, String fileFormatVersion) throws NoKeyRequiredException, FileMissingException, FileIOException, InvalidStateException, NoHashException {
        if (!this.isKeyRequired()) {
            throw new NoKeyRequiredException(this.rootCause);
        }
        this.kh.updateKeyInFile(keyPhrase, fileFormatVersion);
    }

    void deleteKeyFile() throws NoKeyRequiredException, FileMissingException, FileIOException {
        if (!this.isKeyRequired()) {
            throw new NoKeyRequiredException(this.rootCause);
        }
        this.kh.deleteKeyFile();
    }

    String createKeyCopy() throws NoKeyRequiredException, FileIOException {
        if (!this.isKeyRequired()) {
            throw new NoKeyRequiredException(this.rootCause);
        }
        String backupName = this.kh.createKeyCopy();
        return backupName;
    }

    void deleteKeyCopy(String filename) throws NoKeyRequiredException, FileMissingException, FileIOException {
        if (!this.isKeyRequired()) {
            throw new NoKeyRequiredException(this.rootCause);
        }
        this.kh.deleteKeyCopy(filename);
    }

    byte[] encrypt(byte[] plaintext) throws NoEncryptionException, FileMissingException, FileIOException, FileInvalidException, NoSIDException, InvalidStateException, NoHashException {
        if (!this.isEncryptionPossible()) {
            throw new NoEncryptionException(this.rootCause);
        }
        try {
            Cipher cipher = Cipher.getInstance("PbeWithSHAAnd3_KeyTripleDES_CBC", "IAIK");
            PBEKeyBMP key = this.kh.getEffectiveKey();
            cipher.init(1, (Key)key, this.pbeParamSpec);
            byte[] ciphertext = cipher.doFinal(plaintext);
            return ciphertext;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new NoEncryptionException(ex);
        }
        catch (NoSuchProviderException ex) {
            throw new NoEncryptionException(ex);
        }
        catch (NoSuchPaddingException ex) {
            throw new NoEncryptionException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0027", ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0027", ex);
        }
        catch (IllegalStateException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0027", ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0027", ex);
        }
        catch (BadPaddingException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0027", ex);
        }
    }

    byte[] decrypt(byte[] ciphertext) throws NoEncryptionException, FileMissingException, FileIOException, FileInvalidException, NoSIDException, InvalidStateException, NoHashException {
        if (!this.isEncryptionPossible()) {
            throw new NoEncryptionException(this.rootCause);
        }
        try {
            Cipher cipher = Cipher.getInstance("PbeWithSHAAnd3_KeyTripleDES_CBC", "IAIK");
            PBEKeyBMP key = this.kh.getEffectiveKey();
            cipher.init(2, (Key)key, this.pbeParamSpec);
            byte[] plaintext = cipher.doFinal(ciphertext);
            return plaintext;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new NoEncryptionException(ex);
        }
        catch (NoSuchProviderException ex) {
            throw new NoEncryptionException(ex);
        }
        catch (NoSuchPaddingException ex) {
            throw new NoEncryptionException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0028", ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0028", ex);
        }
        catch (IllegalStateException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0028", ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0028", ex);
        }
        catch (BadPaddingException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0028", ex);
        }
    }

    byte[] generateKey() throws SecStoreFSException {
        try {
            KeyGenerator myKeyGenerator = null;
            myKeyGenerator = KeyGenerator.getInstance("DESede", "IAIK");
            return myKeyGenerator.generateKey().getEncoded();
        }
        catch (NoSuchProviderException e) {
            throw new SecStoreFSException(e);
        }
        catch (NoSuchAlgorithmException e) {
            return new byte[0];
        }
    }

    byte[] encryptByteArray(byte[] byteArrayToEncrypt, byte[] keyInBytes) throws SecStoreFSException {
        if (keyInBytes.length == 0) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Base64OutputStream base64os = new Base64OutputStream((OutputStream)baos);
                base64os.write(byteArrayToEncrypt);
                base64os.flush();
                base64os.close();
                byte[] cipherText = baos.toByteArray();
                baos.close();
                return cipherText;
            }
            catch (IOException e) {
                throw new SecStoreFSException(e);
            }
        }
        Cipher cipher = null;
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance("DESede");
            DESedeKeySpec desEdeKeySpec = new DESedeKeySpec(keyInBytes);
            SecretKey key = skf.generateSecret(desEdeKeySpec);
            cipher = Cipher.getInstance("DESede/ECB/PKCS5Padding", "IAIK");
            cipher.init(1, key);
            byte[] cipherText = cipher.doFinal(byteArrayToEncrypt);
            return Util.Base64Encode((byte[])cipherText);
        }
        catch (NoSuchPaddingException e) {
            throw new SecStoreFSException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecStoreFSException(e);
        }
        catch (InvalidKeyException e) {
            throw new SecStoreFSException(e);
        }
        catch (BadPaddingException e) {
            throw new SecStoreFSException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new SecStoreFSException(e);
        }
        catch (NoSuchProviderException e) {
            throw new SecStoreFSException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new SecStoreFSException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    byte[] decryptByteArray(byte[] byteArrayToDecrypt, byte[] keyInBytes) throws SecStoreFSException {
        if (keyInBytes.length == 0) {
            try {
                int i;
                ByteArrayInputStream bais = new ByteArrayInputStream(byteArrayToDecrypt);
                Base64InputStream base64is = new Base64InputStream((InputStream)bais);
                byte[] data = new byte[1024];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((i = base64is.read(data)) > 0) {
                    void var6_15;
                    baos.write(data, 0, (int)var6_15);
                }
                base64is.close();
                baos.close();
                return baos.toByteArray();
            }
            catch (IOException e) {
                throw new SecStoreFSException(e);
            }
        }
        Cipher cipher = null;
        try {
            byteArrayToDecrypt = Util.Base64Decode((byte[])byteArrayToDecrypt);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("DESede");
            DESedeKeySpec desEdeKeySpec = new DESedeKeySpec(keyInBytes);
            SecretKey key = skf.generateSecret(desEdeKeySpec);
            cipher = Cipher.getInstance("DESede/ECB/PKCS5Padding", "IAIK");
            cipher.init(2, key);
            byte[] cipherText = cipher.doFinal(byteArrayToDecrypt);
            return cipherText;
        }
        catch (NoSuchPaddingException e) {
            throw new SecStoreFSException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecStoreFSException(e);
        }
        catch (InvalidKeyException e) {
            throw new SecStoreFSException(e);
        }
        catch (BadPaddingException e) {
            throw new SecStoreFSException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new SecStoreFSException(e);
        }
        catch (NoSuchProviderException e) {
            throw new SecStoreFSException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new SecStoreFSException(e);
        }
        catch (Base64Exception e) {
            throw new SecStoreFSException(e);
        }
    }

    static {
        IAIK.addAsJDK14Provider();
    }
}

