/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.dii.namereservation;

import com.sap.ide.eclipse.dii.DiiPlugin;
import com.sap.ide.eclipse.dii.component.ComponentUtil;
import com.sap.ide.eclipse.dii.namereservation.NameServerManager;
import com.sap.lcr.namealloc.NameAllocator;
import com.sap.lcr.namealloc.api.AllocationState;
import com.sap.lcr.namealloc.api.CommunicationFailureException;
import com.sap.lcr.namealloc.api.NameNotFoundException;
import com.sap.tc.complib.DevelopmentConfiguration;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.dtr.client.eclipse.ui.SelectActivityDialog;
import com.tssap.dtr.client.eclipse.ui.util.WorkspacesWithDefaultActivity;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsProperty;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.security.KeyStore;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.naming.CompoundName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class NameServerUtil {
    public static String NAME_RESERVATION_PROPERTIY = "XCM:name-reservation";
    public static String REVERT_PENDING_STATE = "REVERT_PENDING";
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$dii$namereservation$NameServerUtil == null ? (class$com$sap$ide$eclipse$dii$namereservation$NameServerUtil = NameServerUtil.class$("com.sap.ide.eclipse.dii.namereservation.NameServerUtil")) : class$com$sap$ide$eclipse$dii$namereservation$NameServerUtil));
    static /* synthetic */ Class class$com$sap$ide$eclipse$dii$namereservation$NameServerUtil;

    public static String getNameserverURL(com.tssap.selena.model.elements.Element element) {
        if (element == null) {
            return null;
        }
        IDevelopmentConfiguration config = ComponentUtil.getParentDevConf((com.tssap.selena.model.elements.Element)element.getModel());
        return NameServerUtil.getNameserverURL(config);
    }

    public static String getNameserverURL(IDevelopmentConfiguration config) {
        if (config == null) {
            return null;
        }
        DevelopmentConfiguration data = config.getConfigurationData();
        if (data == null) {
            return null;
        }
        return data.getNameServer();
    }

    public static NameAllocator getNameAllocator(com.tssap.selena.model.elements.Element element) throws MalformedURLException, CommunicationFailureException {
        String url = NameServerUtil.getNameserverURL(element);
        return NameServerManager.getNameserver(url);
    }

    public static NameAllocator getNameAllocator(IProject project) throws MalformedURLException, CommunicationFailureException {
        IDevelopmentConfiguration config = ComponentUtil.getParentDevConf(project);
        String url = NameServerUtil.getNameserverURL(config);
        return NameServerManager.getNameserver(url);
    }

    public static boolean reserveInDTR(IVfsFile file, String category, String name, String key, String server, Shell shell) throws VfsException, Exception {
        return NameServerUtil.reserveInDTR(file, category, name, key, server, null, shell);
    }

    public static boolean reserveInDTR(IVfsFile file, String category, String name, String key, String server, IVfsActivity activity, Shell shell) throws VfsException, Exception {
        String NRProperty = NameServerUtil.createProperty(category, name, key, server, null);
        if ((activity = NameServerUtil.getValidActivity(activity, file, shell)) == null) {
            return false;
        }
        NameServerUtil.setDTRPropertiy(file, activity, NRProperty);
        return true;
    }

    public static boolean reserveMultiNameInDTR(IVfsFile file, NameReservationData data, IVfsActivity activity, Shell shell) throws VfsException, Exception {
        return NameServerUtil.reserveMultiNameInDTR(file, new NameReservationData[]{data}, activity, shell);
    }

    public static boolean reserveMultiNameInDTR(IVfsFile file, NameReservationData[] data, IVfsActivity activity, Shell shell) throws VfsException, Exception {
        String NRProperty = "";
        IVfsProperty property = file.getProperty(NAME_RESERVATION_PROPERTIY);
        if (property == null) {
            NRProperty = NameServerUtil.createMultiProperty(data);
        } else {
            String value = property.getValue();
            NRProperty = NameServerUtil.addMultiProperty(value, data);
        }
        activity = NameServerUtil.getValidActivity(activity, file, shell);
        if (activity == null) {
            return false;
        }
        NameServerUtil.setDTRPropertiy(file, activity, NRProperty);
        return true;
    }

    public static boolean removeMultiNameFromDTR(IVfsFile file, String name, String category, IVfsActivity activity, Shell shell) throws VfsException, Exception {
        String NRProperty = "";
        IVfsProperty property = file.getProperty(NAME_RESERVATION_PROPERTIY);
        if (property == null) {
            return true;
        }
        String value = property.getValue();
        NRProperty = NameServerUtil.removeMultiProperty(value, name, category);
        if ((activity = NameServerUtil.getValidActivity(activity, file, shell)) == null) {
            return false;
        }
        NameServerUtil.setDTRPropertiy(file, activity, NRProperty);
        return true;
    }

    public static boolean removeMultiNameFromDTR(IVfsFile file, NameReservationData data, IVfsActivity activity, Shell shell) throws VfsException, Exception {
        if (data != null) {
            return NameServerUtil.removeMultiNameFromDTR(file, data.getName(), data.getCategory(), activity, shell);
        }
        return true;
    }

    public static NameReservationData[] getMultiNameFromDTR(IVfsFile file) throws VfsException {
        Document mainDocument = null;
        IVfsProperty property = file.getProperty(NAME_RESERVATION_PROPERTIY);
        if (property == null) {
            return new NameReservationData[0];
        }
        String document = property.getValue();
        if (document != null && document.length() > 0) {
            try {
                mainDocument = NameServerUtil.createNewDocumentBuilder().parse(new ByteArrayInputStream(document.getBytes()));
            }
            catch (Throwable e) {
                theTracer.warning("Parsing failed", e);
                return null;
            }
            Element docElement = mainDocument.getDocumentElement();
            List existingData = NameServerUtil.getExistingNRData(docElement);
            if (existingData != null && !existingData.isEmpty()) {
                return existingData.toArray(new NameReservationData[existingData.size()]);
            }
        }
        return new NameReservationData[0];
    }

    private static String removeMultiProperty(String document, String name, String category) {
        List existingData = new ArrayList();
        if (document != null && document.length() > 0) {
            Document mainDocument;
            try {
                mainDocument = NameServerUtil.createNewDocumentBuilder().parse(new ByteArrayInputStream(document.getBytes()));
            }
            catch (Throwable e) {
                theTracer.warning("parsing failed", e);
                return null;
            }
            Element docElement = mainDocument.getDocumentElement();
            existingData = NameServerUtil.getExistingNRData(docElement);
            Iterator it = existingData.iterator();
            while (it.hasNext()) {
                NameReservationData nrData = (NameReservationData)it.next();
                if (!name.equals(nrData.getName()) || !category.equals(nrData.getCategory())) continue;
                nrData.setState(REVERT_PENDING_STATE);
            }
        }
        return NameServerUtil.createMultiProperty(existingData.toArray(new NameReservationData[existingData.size()]));
    }

    public static IVfsActivity getValidActivity(IVfsActivity activity, IVfsFile file, Shell shell) throws VfsException {
        if (activity != null) {
            return activity;
        }
        IVfsWorkspace workspace = file.getWorkspace();
        if (workspace == null) {
            return null;
        }
        if (WorkspacesWithDefaultActivity.usingDefaultActivity((IVfsWorkspace)workspace)) {
            activity = workspace.getDefaultActivity();
        }
        if (activity == null) {
            if (shell == null) {
                shell = DiiPlugin.getPlugin().getMyShell();
            }
            activity = NameServerUtil.getActivity(shell, workspace);
        }
        return activity;
    }

    private static boolean setDTRPropertiy(IVfsFile file, IVfsActivity activity, String NRProperty) throws VfsException, Exception {
        block10: {
            if (activity == null) {
                return false;
            }
            VfsFolderItemActivityState activityState = file.getActivityState();
            VfsFolderItemLocationState locationState = file.getLocationState();
            if (VfsFolderItemActivityState.NOT_CHECKED_OUT.equals(activityState)) {
                if (VfsFolderItemLocationState.LOCAL_ONLY.equals(locationState)) {
                    file.getWorkspace().createAndCheckout(new IVfsActivityRecordedFolderItem[]{file}, activity, 0);
                    try {
                        file.setProperty(NAME_RESERVATION_PROPERTIY, NRProperty, activity);
                        break block10;
                    }
                    catch (VfsException ex) {
                        file.uncheckout(activity);
                        throw ex;
                    }
                }
                if (VfsFolderItemLocationState.SYNCED_TO_LATEST.equals(locationState)) {
                    file.setProperty(NAME_RESERVATION_PROPERTIY, NRProperty, activity);
                    break block10;
                }
                if (VfsFolderItemLocationState.SYNCED_TO_FORMER.equals(locationState) || VfsFolderItemLocationState.SERVER_ONLY.equals(locationState)) {
                    file.sync();
                    file.setProperty(NAME_RESERVATION_PROPERTIY, NRProperty, activity);
                    break block10;
                }
                throw new Exception(MessageFormat.format("The File {0} has invalide location state.\n Location state: {1}", file.getDisplayName(), locationState.toString()));
            }
            if (VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT.equals(activityState) || VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE.equals(activityState)) {
                file.setProperty(NAME_RESERVATION_PROPERTIY, NRProperty, activity);
                break block10;
            }
            throw new Exception(MessageFormat.format("The File {0} has invalide activity state.\n Activity state: {1}", file.getDisplayName(), activityState.toString()));
        }
        return true;
    }

    public static boolean removeFile(IVfsFile file, Shell shell) throws VfsException {
        IVfsWorkspace workspace;
        IVfsActivity activity = null;
        if (shell == null) {
            shell = new Shell();
        }
        if ((workspace = file.getWorkspace()) == null) {
            return false;
        }
        if (WorkspacesWithDefaultActivity.usingDefaultActivity((IVfsWorkspace)workspace)) {
            activity = workspace.getDefaultActivity();
        }
        if (activity == null) {
            activity = NameServerUtil.getActivity(shell, workspace);
        }
        if (activity == null) {
            return false;
        }
        file.checkOutAndDelete(activity);
        return true;
    }

    public static boolean isNamereservationSetted(IVfsFile file) {
        IVfsProperty property = null;
        try {
            property = file.getProperty(NAME_RESERVATION_PROPERTIY);
        }
        catch (VfsException e) {
            theTracer.error("Check for name reservation failed.", (Throwable)e);
            return false;
        }
        catch (Throwable e) {
            theTracer.error("Check for name reservation failed.", e);
            return false;
        }
        return property != null;
    }

    public static String createProperty(String category, String name, String key, String server) {
        return NameServerUtil.createProperty(category, name, key, server, null);
    }

    public static String createProperty(String category, String name, String key, String server, String state) {
        Document mainDocument;
        try {
            mainDocument = NameServerUtil.createNewDocumentBuilder().newDocument();
        }
        catch (Throwable e) {
            theTracer.warning("Creating new Document", e);
            return null;
        }
        Element root = mainDocument.createElement("reservation");
        mainDocument.appendChild(root);
        NameServerUtil.putNewNode(mainDocument, root, "server", server);
        NameServerUtil.putNewNode(mainDocument, root, "category", category);
        NameServerUtil.putNewNode(mainDocument, root, "name", name);
        NameServerUtil.putNewNode(mainDocument, root, "key", key);
        if (state != null) {
            NameServerUtil.putNewNode(mainDocument, root, "state", state);
        }
        return NameServerUtil.DOMtoString(mainDocument);
    }

    private static String createMultiProperty(NameReservationData[] data) {
        Document mainDocument;
        try {
            mainDocument = NameServerUtil.createNewDocumentBuilder().newDocument();
        }
        catch (Throwable e) {
            theTracer.warning("Creating new Document failed", e);
            return null;
        }
        Element root = mainDocument.createElement("multi-reservation");
        mainDocument.appendChild(root);
        if (data != null) {
            int i = 0;
            while (i < data.length) {
                Element resRoot = mainDocument.createElement("reservation");
                root.appendChild(resRoot);
                NameServerUtil.putNewNode(mainDocument, resRoot, "server", data[i].getServer());
                NameServerUtil.putNewNode(mainDocument, resRoot, "category", data[i].getCategory());
                NameServerUtil.putNewNode(mainDocument, resRoot, "name", data[i].getName());
                NameServerUtil.putNewNode(mainDocument, resRoot, "key", data[i].getKey());
                if (data[i].getState() != null) {
                    NameServerUtil.putNewNode(mainDocument, resRoot, "state", data[i].getState());
                }
                ++i;
            }
        }
        return NameServerUtil.DOMtoString(mainDocument);
    }

    private static String addMultiProperty(String document, NameReservationData[] data) {
        ArrayList<NameReservationData> results = new ArrayList<NameReservationData>();
        if (document != null && document.length() > 0) {
            Document mainDocument;
            try {
                mainDocument = NameServerUtil.createNewDocumentBuilder().parse(new ByteArrayInputStream(document.getBytes()));
            }
            catch (Throwable e) {
                theTracer.warning("Parsing failed", e);
                return null;
            }
            Element docElement = mainDocument.getDocumentElement();
            List existingData = NameServerUtil.getExistingNRData(docElement);
            Iterator it = existingData.iterator();
            while (it.hasNext()) {
                NameReservationData nrData = (NameReservationData)it.next();
                boolean valid = true;
                int i = 0;
                while (i < data.length) {
                    if (nrData.getName() != null && nrData.getName().equals(data[i].getName()) && nrData.getCategory() != null && nrData.getCategory().equals(data[i].getCategory())) {
                        valid = false;
                        break;
                    }
                    ++i;
                }
                if (!valid) continue;
                results.add(nrData);
            }
        }
        results.addAll(Arrays.asList(data));
        return NameServerUtil.createMultiProperty(results.toArray(new NameReservationData[results.size()]));
    }

    private static List getExistingNRData(Element docElement) {
        ArrayList<NameReservationData> existingData = new ArrayList<NameReservationData>();
        if ("reservation".equals(docElement.getNodeName())) {
            existingData.add(NameServerUtil.getNameReservationData(docElement));
        } else if ("multi-reservation".equals(docElement.getNodeName())) {
            NodeList children = docElement.getChildNodes();
            int i = 0;
            while (children != null && i < children.getLength()) {
                if (children.item(i) instanceof Element) {
                    existingData.add(NameServerUtil.getNameReservationData((Element)children.item(i)));
                }
                ++i;
            }
        }
        return existingData;
    }

    private static NameReservationData getNameReservationData(Element docElement) {
        if ("reservation".equals(docElement.getNodeName())) {
            NodeList children = docElement.getChildNodes();
            String name = "";
            String key = "";
            String server = "";
            String category = "";
            String state = null;
            int i = 0;
            while (children != null && i < children.getLength()) {
                if (children.item(i) instanceof Element) {
                    Element element = (Element)children.item(i);
                    String nodeName = element.getNodeName().toLowerCase();
                    if ("server".equals(nodeName)) {
                        server = ((Text)element.getFirstChild()).getData();
                    } else if ("category".equals(nodeName)) {
                        category = ((Text)element.getFirstChild()).getData();
                    } else if ("name".equals(nodeName)) {
                        name = ((Text)element.getFirstChild()).getData();
                    } else if ("key".equals(nodeName)) {
                        key = ((Text)element.getFirstChild()).getData();
                    } else if ("state".equals(nodeName)) {
                        state = ((Text)element.getFirstChild()).getData();
                    }
                }
                ++i;
            }
            return new NameReservationData(category, name, key, server, state);
        }
        return null;
    }

    private static DocumentBuilder createNewDocumentBuilder() throws ParserConfigurationException {
        return new DocumentBuilderFactoryImpl().newDocumentBuilder();
    }

    private static String DOMtoString(Document doc) {
        try {
            OutputFormat format = new OutputFormat(doc);
            StringWriter stringOut = new StringWriter();
            XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
            serial.asDOMSerializer();
            serial.serialize(doc.getDocumentElement());
            return stringOut.toString();
        }
        catch (Exception ex) {
            theTracer.warning("DOM to String failed", (Throwable)ex);
            return null;
        }
    }

    private static void putNewNode(Document doc, Element parent, String tagName, String textValue) {
        Element element = doc.createElement(tagName);
        Text text = doc.createTextNode(textValue);
        element.appendChild(text);
        parent.appendChild(element);
    }

    public static String getDCReservationName(String vendor, String name) {
        return vendor + "/" + name;
    }

    public static boolean isDCReserved(String objName, NameAllocator allocator) throws CommunicationFailureException {
        AllocationState state = null;
        try {
            state = allocator.getAllocationState("SAP_DevelopmentComponentName", objName);
        }
        catch (NameNotFoundException e) {
            return false;
        }
        if (state == null) {
            return false;
        }
        return state.isReserved();
    }

    public static AllocationState reserveDC(String name, NameAllocator nameAllocator) throws Throwable {
        String user = nameAllocator.getMyConnectUser();
        return nameAllocator.reservePreliminary("SAP_DevelopmentComponentName", name, user, name.toString(), "DC RESERVATION", null, null);
    }

    public static void revertDCReservation(String name, NameAllocator nameAllocator) throws Throwable {
        AllocationState state = null;
        try {
            state = nameAllocator.getAllocationState("SAP_DevelopmentComponentName", name);
        }
        catch (NameNotFoundException e) {
            return;
        }
        if (state.isReserved()) {
            if (state.isReservedFinally()) {
                throw new Exception("The Name '" + name + "' is finally reserved.\n It is impossible to revert this Reservation.");
            }
            if (state.getReservationKey() != null) {
                try {
                    nameAllocator.revert("SAP_DevelopmentComponentName", name, state.getReservationKey());
                }
                catch (NameNotFoundException e) {
                    theTracer.warning("Name " + name + " no more existing", (Throwable)e);
                }
            } else {
                throw new Exception("The Reservation key couldn' be acquired.");
            }
        }
    }

    public static NameAllocator createNewNameAllocator(String nameServerUrl, String mUser, String mPassword, KeyStore keyStore) throws MalformedURLException, CommunicationFailureException {
        NameAllocator mNameAllocator = null;
        if (nameServerUrl == null || nameServerUrl.length() <= 0) {
            return null;
        }
        URL url = new URL(nameServerUrl);
        mNameAllocator = new NameAllocator(url, mUser, mPassword, keyStore);
        return mNameAllocator;
    }

    public static String getURL(NameAllocator nameAlloc) throws MalformedURLException {
        if (nameAlloc == null) {
            return null;
        }
        URL url = new URL("http", nameAlloc.getMyServerHost(), nameAlloc.getMyServerPort(), "");
        if (url != null) {
            return url.toString();
        }
        return null;
    }

    public static String PrefixesToString(CompoundName[] prefixes) {
        String ret = null;
        if (prefixes != null) {
            ret = "[";
            int i = 0;
            while (i < prefixes.length) {
                if (i != 0) {
                    ret = ret + ";";
                }
                ret = ret + prefixes[i].toString();
                ++i;
            }
            ret = ret + "]";
        }
        return ret;
    }

    private static IVfsActivity getActivity(Shell shell, IVfsWorkspace workspace) {
        IVfsActivity[] results;
        SelectActivityDialog selectActivity;
        IVfsActivity activity = null;
        if (workspace != null && (selectActivity = new SelectActivityDialog(shell, workspace, false, null, null, 0)).open() == 0 && (results = selectActivity.getActivitySelection()).length > 0) {
            activity = results[0];
        }
        return activity;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class NameReservationData {
        String category;
        String name;
        String key;
        String server;
        String state;

        public NameReservationData(String category, String name, String key, String server, String state) {
            this.category = category;
            this.name = name;
            this.key = key;
            this.server = server;
            this.state = state;
        }

        public boolean equals(Object obj) {
            if (obj instanceof NameReservationData) {
                NameReservationData nrd = (NameReservationData)obj;
                return this.category != null && this.category.equals(nrd.getCategory()) && this.name != null && this.name.equals(nrd.getName()) && this.key != null && this.key.equals(nrd.getKey()) && this.server != null && this.server.equals(nrd.getServer());
            }
            return false;
        }

        public String getCategory() {
            return this.category;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public String getServer() {
            return this.server;
        }

        public void setCategory(String string) {
            this.category = string;
        }

        public void setKey(String string) {
            this.key = string;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setServer(String string) {
            this.server = string;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String string) {
            this.state = string;
        }

        public int hashCode() {
            return (this.name != null ? this.name.hashCode() : 0) + (this.category != null ? this.category.hashCode() : 0);
        }
    }
}

