/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.dii.namereservation;

import com.sap.ide.eclipse.dii.component.ComponentUtil;
import com.sap.ide.eclipse.dii.namereservation.NameServerUtil;
import com.sap.ide.login.UserValidator;
import com.sap.lcr.namealloc.NameAllocator;
import com.sap.lcr.namealloc.api.AllocationState;
import com.sap.lcr.namealloc.api.CommunicationFailureException;
import com.sap.lcr.namealloc.api.NameNotFoundException;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class NameServerManager {
    protected static Map allocatorMap = null;
    protected static Map packageMap = null;
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$dii$namereservation$NameServerManager == null ? (class$com$sap$ide$eclipse$dii$namereservation$NameServerManager = NameServerManager.class$("com.sap.ide.eclipse.dii.namereservation.NameServerManager")) : class$com$sap$ide$eclipse$dii$namereservation$NameServerManager));
    static /* synthetic */ Class class$com$sap$ide$eclipse$dii$namereservation$NameServerManager;

    protected static Map getMap() {
        if (allocatorMap == null) {
            allocatorMap = new HashMap();
        }
        return allocatorMap;
    }

    protected static Map getPackageMap() {
        if (packageMap == null) {
            packageMap = new HashMap();
        }
        return packageMap;
    }

    public static void reset() {
        NameServerManager.getMap().clear();
    }

    public static NameAllocator getNameserver(String url) throws CommunicationFailureException, MalformedURLException {
        if (url == null) {
            return null;
        }
        UserValidator.Data userData = null;
        if (!UserValidator.isDefaultServerOnline()) {
            NameServerManager.reset();
            return null;
        }
        Object obj = NameServerManager.getMap().get(url);
        if (obj != null) {
            return (NameAllocator)obj;
        }
        userData = UserValidator.getDefaultServerData();
        NameAllocator allocator = NameServerUtil.createNewNameAllocator(url, userData.getUser(), userData.getPassword(), UserValidator.getKeyStore());
        NameServerManager.getMap().put(url, allocator);
        return allocator;
    }

    public static AllocationState getPackageState(IPackageFragment fragment) {
        return NameServerManager.getPackageState(fragment, null, false);
    }

    public static void setPackageState(IPackageFragment fragment, AllocationState state) {
        String url = NameServerManager.getURL(fragment);
        if (url == null) {
            return;
        }
        String name = NameServerManager.getPackageName(fragment, url);
        if (name == null) {
            return;
        }
        NameServerManager.getPackageMap().put(name, state);
    }

    public static void refreshPackage(IPackageFragment fragment) {
        NameServerManager.getPackageState(fragment, null, true);
    }

    private static AllocationState getPackageState(IPackageFragment fragment, String url, boolean refresh) {
        if (fragment == null) {
            return null;
        }
        if (!UserValidator.isDefaultServerOnline()) {
            NameServerManager.getPackageMap().clear();
            return null;
        }
        if (url == null && (url = NameServerManager.getURL(fragment)) == null) {
            return null;
        }
        String packageName = NameServerManager.getPackageName(fragment, url);
        if (!refresh) {
            Object obj = NameServerManager.getPackageMap().get(packageName);
            if (obj instanceof AllocationState) {
                return (AllocationState)obj;
            }
            if (obj != null) {
                return null;
            }
        }
        AllocationState mState = null;
        try {
            NameAllocator allocator = NameServerManager.getNameserver(url);
            if (allocator != null) {
                mState = allocator.getAllocationState("SAP_DesignTimePackage", fragment.getElementName());
            }
        }
        catch (NameNotFoundException e) {
            theTracer.warning("Getting Name State for Package failed", (Throwable)e);
        }
        catch (Exception e) {
            theTracer.warning("Getting Name State for Package failed", (Throwable)e);
        }
        if (mState != null) {
            NameServerManager.getPackageMap().put(packageName, mState);
        } else {
            NameServerManager.getPackageMap().put(packageName, "");
        }
        return mState;
    }

    private static String getURL(IPackageFragment fragment) {
        IJavaProject jPrj = fragment.getJavaProject();
        if (jPrj == null) {
            return null;
        }
        IDevelopmentConfiguration config = ComponentUtil.getParentDevConf(jPrj.getProject());
        String url = NameServerUtil.getNameserverURL(config);
        return url;
    }

    private static String getPackageName(IPackageFragment fragment, String url) {
        return fragment.getElementName() + "/" + url;
    }

    public static void refreshProjectPackageNR(IProject project) {
        if (project == null) {
            return;
        }
        IDevelopmentConfiguration config = ComponentUtil.getParentDevConf(project);
        if (config == null) {
            return;
        }
        String url = NameServerUtil.getNameserverURL(config);
        if (url == null) {
            return;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            IPackageFragment[] fragments = null;
            try {
                fragments = javaProject.getPackageFragments();
            }
            catch (Throwable e) {
                theTracer.warning("Getting Package Fragments failed", e);
            }
            if (fragments != null) {
                int i = 0;
                while (i < fragments.length) {
                    IPackageFragment fragment = fragments[i];
                    try {
                        if (!(1 != fragment.getKind() || !fragment.hasChildren() && fragment.hasSubpackages() || "".equals(fragment.getElementName()))) {
                            NameServerManager.getPackageState(fragment, url, true);
                        }
                    }
                    catch (JavaModelException e) {
                        theTracer.warning("Getting Package State failed", (Throwable)e);
                    }
                    ++i;
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

