/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.dii.component.ui.properties;

import com.sap.ide.eclipse.dii.component.ui.properties.IElementWrapperConverter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class ComponentWrapperSelectionConverter
implements ISelectionChangedListener,
ISelectionProvider {
    private IElementWrapperConverter myConverter;
    private ISelectionProvider mySource;
    private HashSet myListeners = new HashSet();
    private IStructuredSelection myConvertedSelection;

    public ComponentWrapperSelectionConverter(ISelectionProvider source, IElementWrapperConverter converter) {
        this.myConverter = converter;
        this.mySource = source;
        this.mySource.addSelectionChangedListener((ISelectionChangedListener)this);
        this.buildSelection();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.buildSelection();
        SelectionChangedEvent propertyEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Iterator it = this.myListeners.iterator();
        while (it.hasNext()) {
            ((ISelectionChangedListener)it.next()).selectionChanged(propertyEvent);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.myListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.myConvertedSelection;
    }

    private void buildSelection() {
        ISelection selectionToConvert = this.mySource.getSelection();
        if (selectionToConvert instanceof IStructuredSelection) {
            ArrayList<Object> converted = new ArrayList<Object>();
            Iterator it = ((IStructuredSelection)selectionToConvert).iterator();
            while (it.hasNext()) {
                Object nextWrapper = this.myConverter.getWrapper(it.next());
                if (nextWrapper == null) continue;
                converted.add(nextWrapper);
            }
            this.myConvertedSelection = new StructuredSelection(converted);
        } else {
            this.myConvertedSelection = StructuredSelection.EMPTY;
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.myListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }
}

